/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1998  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Graphics;
import java.awt.Color;
import javax.swing.*;
import jp.gr.java_conf.jaba2.awt.UAWT;

/**
 * GraphDock
 *
 * @since   Dec.  8, 1998
 * @version Dec. 24, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class GraphDock extends AbstractGraphObject {
    protected List nodes_ = new ArrayList(); // List<GraphNode>

    public GraphDock() {
    }

    public GraphDock(GraphModel model) {
	super(model);
    }

    /**
     * Whether if this dock can accept the dragged node.
     */
    public boolean canAccept(GraphNode node) {
	return (false);
    }

    public void addNode(GraphNode node) {
	nodes_.add(node);
	node.setDock(this);
    }
}
