/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt;

import java.util.*;
import java.awt.*;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jp.gr.java_conf.jaba2.util.ArrayMap;
import jp.gr.java_conf.jaba2.awt.lwlayout.*;

/**
 * LightWeightMasterPanel
 *
 * @since   Jan.  5, 1998
 * @version Feb.  8, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class LightWeightLayoutPanel extends JComponent {
    protected LightWeightMasterLayout layout_;

    public LightWeightLayoutPanel() {
	_init(new BorderMetaLayout());
    }

    public LightWeightLayoutPanel(MetaLayoutManager metaLayout) {
	_init(metaLayout);
    }

    private void _init(MetaLayoutManager metaLayout) {
	layout_ = new LightWeightMasterLayout();
	layout_.setMetaLayoutManager(metaLayout);
	setLayout(layout_);
    }

    public void add(String lwName, Component comp, Object lwConstraints) {
	LightWeightLayoutConstraints constraints
	    = new LightWeightLayoutConstraints(lwName, lwConstraints);
	add(comp, constraints);
    }

    public void setMetaLayoutManager(MetaLayoutManager layout) {
	layout_.setMetaLayoutManager(layout);
    }

    public void addLightWeightLayoutManager(
	String name,
	LightWeightLayoutManager layout,
	Object constraints
    ) {
	layout_.addLightWeightLayoutManager(name, layout, constraints);
    }

    // test driver
    public static void main(String[] args) {
	LightWeightLayoutPanel panel = new LightWeightLayoutPanel();
	panel.addLightWeightLayoutManager(
	    "north",
	    new ColumnLightWeightLayout(),
	    "north"
	);
	panel.add("north", new JLabel("North1"), null);
	panel.add("north", new JLabel("North2"), null);
	panel.add("north", new JLabel("North3"), null);

	panel.addLightWeightLayoutManager(
	    "south",
	    new ColumnLightWeightLayout(),
	    "south"
	);
	panel.add("south", new JLabel("South1"), null);
	panel.add("south", new JLabel("South2"), null);
	panel.add("south", new JLabel("South3"), null);
	
	panel.addLightWeightLayoutManager(
	    "west",
	    new RowLightWeightLayout(),
	    "west"
	);
	panel.add("west", new JLabel("West1"), null);
	panel.add("west", new JLabel("West2"), null);
	panel.add("west", new JLabel("West3"), null);

	panel.addLightWeightLayoutManager(
	    "east",
	    new RowLightWeightLayout(),
	    "east"
	);
	panel.add("east", new JLabel("East1"), null);
	panel.add("east", new JLabel("East2"), null);
	panel.add("east", new JLabel("East3"), null);

	new JTestFrame(panel);
    }
}
