/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998,1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.cdf;

import java.util.*;
import java.io.*;
import java.net.URL;
import jp.gr.java_conf.jaba2.util.ParameterInfo;
import jp.gr.java_conf.jaba2.util.AppParameterInfo;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * CDFConfig
 *
 * @since   Aug. 28, 1999
 * @version Sep. 23, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class CDFConfig extends AbstractSmartDocFormatConfig {
    protected File channelFile_;
    protected String baseURL_;

    // SmartDocFormatConfig
    public void setup(SmartDocConfig config, String[] args)
	throws IOException {

	ParameterInfo info = new AppParameterInfo(
	    "jp.gr.java_conf.jaba2.SmartDoc",
	    args,
	    "jp.gr.java_conf.jaba2.SmartDoc.cdf.CDFDefaults",
	    new File("SmartDoc.properties")
	);
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.cdf");
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.cdf.handler");
	channelFile_ = info.getParameterAsFile("cdf.channelFile");
	baseURL_ = info.getParameterAsString("cdf.baseURL");
	_init(config, "cdf", info);
    }

    // SmartDocFormatConfig
    public String getID() {
	return ("cdf");
    }

    // SmartDocFormatConfig
    public String getName() {
	return ("CDF");
    }

    // SmartDocFormatConfig
    public String[] getImageCandidates() {
	return (null);
    }

    public String getBaseURL() {
	return (baseURL_);
    }

    public File getChannelFile() {
	return (channelFile_);
    }
}
