/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MACRO_H
#define MACRO_H

#include <qstring.h>
#include "general/errorreport.h"
#include <qobject.h>
#include "includes.h"
/**
@author Juergen Thies
*/
enum varType  {varInt,varInt16,varInt32,ptrInt16, ptrInt32,varVoid, varDouble,varString,
varBool,ptrVoid, ptrInt,ptrDouble,ptrString,ptrBool, ptrLayout,varDrawingField, varStringList, ptrStringList,
ptrDrawingField,varCell, ptrCell,varCellList, ptrCellList, ptrElementList,varElementList, 
ptrElement, varElement, ptrPoint, varPoint, ptrRect, varRect, ptrPointArray, varPointArray, 
ptrFile, varFile, varDrc, ptrDrc,ptrLayerTranslator,varLayerTranslator, ptrNetListModule, ptrBackgroundModule,ptrBarcodeModule,ptrView3dModule, ptrNetList,varNetList,ptrNetListDevice,varNetListDevice,
ptrSchematic,ptrSchematicDisplay,ptrSheetList,ptrSheet,ptrSElement,ptrSElementList,varSElementList
,ptrTextEdit,ptrTextDisplay
};
class keywords;
class variant;
class layout;
#ifdef SCHEMATIC
class schematic;
class componentPlacement;
#endif

class parserValue;
class macro :private QObject{
Q_OBJECT
private:
#include "generalhandler.h"
public:
    macro();
    macro(layout *main);
    virtual ~macro();

    static bool isMacro(QString *filename, QString *name,QString *help);
    
    returnValue functionHandler (int *counter,int *funcCode,int *parameter, keywords *keyword);
private:
   
   layout *layoutWindow;
#ifdef SCHEMATIC
   schematic *schematicWindow;
#endif
   //keywords *globals;
   //bool layoutLock,schematicLock;
   int registerGlobals();
   void registerKeywords();
   void errorMessage(int num,errorreport *error);
#include "inthandler.h"
#include "doublehandler.h"
#include "voidhandler.h"
#include "stringhandler.h"
#include "stringlisthandler.h"
#include "boolhandler.h"
#include "layouthandler.h"
#include "cellhandler.h"
#include "celllisthandler.h"
#include "drawingfieldhandler.h"
#include "recthandler.h"
#include "elementhandler.h"
#include "elementlisthandler.h"
#include "pointhandler.h"
#include "pointarrayhandler.h"
#include "filehandler.h"
#include "drchandler.h"
#include "layershandler.h"
#include "setuphandler.h"
#include "mathhandler.h"
#include "stdlibhandler.h"
#include "layertranslatorhandler.h"
#include "processhandler.h"
#ifdef netlistutility
#include "netlistmodulehandler.h"
#include "netlisthandler.h"
#include "netlistdevicehandler.h"
#endif
#ifdef barcodeutility
#include "barcodemodulehandler.h"
#endif
#ifdef backgroundutility
#include "backgroundmodulehandler.h"
#endif
#ifdef USE_3d
#include "view3dmodulehandler.h"
#endif
#ifdef SCHEMATIC
#include "schematichandler.h"
#include "schematicdisplayhandler.h"
#include "sheethandler.h"
#include "sheetlisthandler.h"
#include "selementhandler.h"
#include "selementlisthandler.h"
#include "celhandler.h"
#endif
#ifdef TEXTEDIT
#include "textedithandler.h"
#include "textdisplayhandler.h"
#endif
public slots:

    void load(QString *filename);
    void setLayout(layout *window){layoutWindow=window;}
#ifdef SCHEMATIC
    void setSchematic(schematic *window){schematicWindow=window;}
#endif
    int execute(errorreport *error,QString parameter="");
    int execute();
    void executeSingle(QString line,errorreport *error);
    void define(QString s1,QString s2);
    friend class variant;
    friend class componentParameter;
  private:
    QString codec;
};

#endif
