/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "layout.h"
#include "general/project.h"
#include "general/guiworkthread.h"
#include "bool/booleanhandler.h"

void macro::layoutHandler_registerKeywords(keywords **keyword_,layout *l){
 *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="layout";
 (*keyword_)->type=intClass;
 (*keyword_)->r=new returnValue();
 (*keyword_)->r->setType(ptrLayout);
 (*keyword_)->r->setPtrLayout(l);
 (*keyword_)->classHandler=&macro::layoutHandler_classHandler;
}

returnValue macro::layoutHandler_classHandler(int *counter, keywords *keyword_,returnValue* r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrLayout){
   if (checkClassPointer(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 //else (r->type==varLayout){}
 layout *l=r->getLayout();
#ifdef SCHEMATIC
 if (l==NULL) {
	l = project::getLayout(schematicWindow);
	}
#endif
 p=next(counter);
 // variables
 if ((p.type==keyword)&&(p.value=="filename")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(l->filename);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
else if ((p.type==keyword)&&(p.value=="drawing")){
 		returnValue r2;
		r2.setType(ptrDrawingField);
		r2.deleteAfter=false;
		r2.DrawingField=(l->drawing);
		r2=drawingFieldHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
else if ((p.type==keyword)&&(p.value=="drcTool")){
 		returnValue r2;
		r2.setType(ptrDrc);
		r2.deleteAfter=false;
		r2.Drc=(l->drcTool);
		r2=drcHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
#ifdef netlistutility
else if ((p.type==keyword)&&(p.value=="netlistTool")){
 		returnValue r2;
		r2.setType(ptrNetListModule);
		r2.deleteAfter=false;
		r2.NetListModule=(l->netlistTool);
		r2=netListModuleHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
#endif
#ifdef barcodeutility
else if ((p.type==keyword)&&(p.value=="barcodeTool")){
 		returnValue r2;
		r2.setType(ptrBarcodeModule);
		r2.deleteAfter=false;
		r2.BarcodeModule=(l->barcodeTool);
		r2=barcodeModuleHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
#endif
#ifdef USE_3d
else if ((p.type==keyword)&&(p.value=="view3dTool")){
 		returnValue r2;
		r2.setType(ptrView3dModule);
		r2.deleteAfter=false;
		r2.View3dModule=(l->view3dTool);
		r2=view3dModuleHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
#endif
else if ((p.type==keyword)&&(p.value=="debug")){
 		returnValue r2;
		r2.setType(varBool);
		r2.deleteAfter=false;
		r2.b=&(l->debug);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;
 	}
 // methods
 else if (((p.type==keyword)&&(p.value=="showTextEditor"))) { testParenOpen(counter);
	testParenClose(counter);
#ifdef TEXTEDIT
	ret.setPtrTextEdit(l->showTextEditor());
	ret=textEditHandler_classHandler(counter,keyword_,&ret,false);
#endif
	}
#ifdef USE_3d
 else if (((p.type==keyword)&&(p.value=="trigger3dRenderAll"))) { testParenOpen(counter);
	testParenClose(counter);
	l->trigger3dRenderAll();}
 else if (((p.type==keyword)&&(p.value=="trigger3dRenderSelect"))) { testParenOpen(counter);
	testParenClose(counter);
	l->trigger3dRenderSelect();}
 else if (((p.type==keyword)&&(p.value=="trigger3dRenderAuto"))) { testParenOpen(counter);
	testParenClose(counter);
	l->trigger3dRenderAuto();}
#endif
 else {
  	error->addItem(tr("Class layout has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}

