/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "elements/element.h"

void macro::elementHandler_registerKeywords(keywords **keyword_){
 *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="element";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::elementHandler_typeHandler;
}
void macro::elementHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrElement,varElement,single);
}

returnValue macro::elementHandler_classHandler(int *counter, keywords *keyword_,returnValue* r,bool left){
 returnValue ret;
 parserValue p;
 QString s; 
if (r->type==ptrElement){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else  {return *r;}
	}
   }
 else if (r->type==varElement){
     if (checkDot(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
    }
 bool staticClass=checkStaticClass(counter);
 p=next(counter);

 // static methods
 if (((p.type==keyword)&&(p.value=="runden"))) { testParenOpen(counter); 
	returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setInt(element::runden(p1.getDouble()));}
 else if (((p.type==keyword)&&(p.value=="round"))) { testParenOpen(counter); 
	returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setInt(element::runden(p1.getDouble()));}
 else if (((p.type==keyword)&&(p.value=="angle"))) { testParenOpen(counter); 
	returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);
	if (checkParenClose(counter)) {
		ret.setDouble(element::angle(*p1.getPoint(),*p2.getPoint()));}
	else {  testComma(counter);
		returnValue p3=calculate(counter,keyword_);
		testParenClose(counter);
		ret.setDouble(element::angle(*p1.getPoint(),*p2.getPoint(),*p3.getPoint()));}
        }
 else if (((p.type==keyword)&&(p.value=="distance"))) { testParenOpen(counter); 
	returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);
	if (checkParenClose(counter)) {
		ret.setDouble(element::distance(*p1.getPoint(),*p2.getPoint()));}
	else {  testComma(counter);
		returnValue p3=calculate(counter,keyword_);
		testParenClose(counter);
		ret.setDouble(element::distance(*p1.getPoint(),*p2.getPoint(),*p3.getPoint()));}
        }
 else if (staticClass) {error->addItem(tr("Class element has no static member ")+p.value,1,message((*counter)));
	throw 1;}
 else {
 element *e=r->getElement();
 // variables
 if ((p.type==keyword)&&(p.value=="layerNum")){
 		returnValue r2;
		r2.type=varInt16;
		r2.deleteAfter=false;
		r2.int16=&(e->layerNum);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;
 	}
 if ((p.type==keyword)&&(p.value=="datatype")){
 		returnValue r2;
		r2.type=varInt16;
		r2.deleteAfter=false;
		r2.int16=&(e->datatype);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;
 	}
 else if ((p.type==keyword)&&(p.value=="select")){
 		returnValue r2;
		r2.type=varBool;
		r2.deleteAfter=false;
		r2.b=&(e->select);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;
 	}
 // methods
 else {
  	error->addItem(tr("Class element has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}
