/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "general/drawingfield.h"





void macro::drawingFieldHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="drawingField";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::drawingFieldHandler_typeHandler;
}

void macro::drawingFieldHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrDrawingField,ptrDrawingField,single);
}

returnValue macro::drawingFieldHandler_classHandler(int *counter, keywords *keyword_,returnValue *r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrDrawingField){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else if (r->type==varDrawingField){
     if (checkDot(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
    }
 drawingField *d= r->getDrawingField();
 p=next(counter);
 // variables
 if ((p.type==keyword)&&(p.value=="activeLayer")){
 		returnValue r2;
		r2.type=varInt;
		r2.deleteAfter=false;
		r2.i=&(d->activeLayer);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 if ((p.type==keyword)&&(p.value=="gridX")){
 		returnValue r2;
		r2.type=varInt;
		r2.deleteAfter=false;
		r2.i=&(d->gridX);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 if ((p.type==keyword)&&(p.value=="gridY")){
 		returnValue r2;
		r2.type=varInt;
		r2.deleteAfter=false;
		r2.i=&(d->gridY);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 if ((p.type==keyword)&&(p.value=="gridOffsetX")){
 		returnValue r2;
		r2.type=varInt;
		r2.deleteAfter=false;
		r2.i=&(d->gridOffsetX);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 if ((p.type==keyword)&&(p.value=="gridOffsetY")){
 		returnValue r2;
		r2.type=varInt;
		r2.deleteAfter=false;
		r2.i=&(d->gridOffsetY);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 if ((p.type==keyword)&&(p.value=="gridauto")){
 		returnValue r2;
		r2.type=varBool;
		r2.deleteAfter=false;
		r2.b=&(d->gridauto);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 if ((p.type==keyword)&&(p.value=="userunits")){
 		returnValue r2;
		r2.type=varDouble;
		r2.deleteAfter=false;
		r2.d=&(d->userunits);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 if ((p.type==keyword)&&(p.value=="databaseunits")){
 		returnValue r2;
		r2.type=varDouble;
		r2.deleteAfter=false;
		r2.d=&(d->databaseunits);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 if ((p.type==keyword)&&(p.value=="currentCell")){
 		returnValue r2;
		r2.setType(ptrCell);
		r2.deleteAfter=false;
		r2.Cell=(d->currentCell);
		r2=cellHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 if ((p.type==keyword)&&(p.value=="firstCell")){
 		returnValue r2;
		r2.setType(ptrCellList);
		r2.deleteAfter=false;
		r2.CellList=(d->firstCell);
		r2=cellListHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 if ((p.type==keyword)&&(p.value=="libname")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(d->libname);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 if ((p.type==keyword)&&(p.value=="fileType")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(d->fileType);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 if ((p.type==keyword)&&(p.value=="previousCell")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(d->previousCell);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 // methods
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}

