/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LAYOUTIMAGE_H
#define LAYOUTIMAGE_H
#include <QImage>
#include "elements/strans.h"
#include "setup.h"
#ifdef multithread
#include "threads/layoutimagedispatcher.h"
#endif
/**
	@author Juergen Thies <layout@juergenthies.de>
*/
class layoutImagePainter;
class layoutImage
#ifdef multithread
	:public layoutImageDispatcher
#endif
{
public:
    layoutImage(int x,int y);

   virtual ~layoutImage();


   virtual void resize(int x, int y);
   void reset();
   bool imageChanged;
//   void setTrans(strans trans);
   strans getDrawTrans()const{return drawTrans; }
   void setDrawTrans(strans trans);
   layoutImagePainter *imagePainter;
   void setPaintAbort(bool *b);
   void fill(uint color){image->fill(color);}
   QImage *getImage(){return image;}
   void setMultiThread();
   bool multiThreadDraw;
   void setBackground();
protected:
   QImage *image;
   uint backgroundColor;
   bool *paintAbort;
private:
   strans drawTrans;
friend class layoutImagePainter;
friend class layoutImagePainterTransparent;
friend class layoutImagePainterWhiteTransparent;
friend class layoutImagePainterStacked;
#ifdef multithread
friend class layoutImageDispatcher;
#endif 
};

#endif
