/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GDS_H
#define GDS_H

#include <qobject.h>
#include <qstring.h>
#include "filegeneral.h"
#include "filewrite.h"
#include <QHash>
/**
@author Juergen Thies
*/
class errorreport;
class drawingField;
class fileRead;

class gds : public QObject
{
Q_OBJECT
public:
    gds(QObject *parent = 0, const char *name = 0);

    ~gds();

errorreport *error;
fileWrite *write;
QDataStream *streamPtr;
//void save(QDataStream *streamPtr,drawingField *, errorreport *report);       
void save();
static void open(QString filename,drawingField *);
static void import(QString filename,drawingField *);
static void update(QString filename,drawingField *);
static void save(QString filename,drawingField *);
static void writeString (QDataStream *stream,QString s,int type);
static void write8ByteReal(double d,QDataStream *stream);
void write8ByteReal(double d);
void writeString (QString s,int type);
void count();
private:
int recordCount;
drawingField *drawing;
static void load(QString filename,drawingField *, fileOpenType type);
static double read8ByteReal(fileRead *stream);
static QString readString (fileRead *stream,int items);
};

#endif
