/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CELLLIST_H
#define CELLLIST_H

#include "cell.h"
/**
@author Juergen Thies
*/
//#define celllist cellList
#define next_cell nextCell
#define this_cell thisCell
//! elements of the list with all cells
/*!
This class is a list-element for the cells 
*/
class cellList{
public:
    cellList();

    ~cellList();
//! pointer to further cells
/*!
This is a pointer to further cells.
*/
cellList *nextCell;   
//! pointer to a cell
/*!
This is a point to a cell.
*/ 
cell *thisCell;    
void paintInfoClear(){
	thisCell->paintInfoClear();
	if (nextCell!=NULL) nextCell->paintInfoClear();
	}
void clearNode(){
	thisCell->clearNode();
	if (nextCell!=NULL) nextCell->clearNode();
	}
void clearMarker(){
	thisCell->marker=false;
	if (nextCell!=NULL) nextCell->clearMarker();
	}
bool useLayer(int layer);
void useLayer(QBitArray *);
void useLayerMarked(QBitArray *);
void clearDefaultLayer(){
	thisCell->defaultLayer=-2;
	if (nextCell!=NULL) nextCell->clearDefaultLayer();
}
};

#endif
