/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "boxproperties.h"
#include "general/userunitsvalidator.h"
#include "box.h"
#include <qspinbox.h>
#include <qlineedit.h>
#include "general/setup.h"
#include <qrect.h>
#include <qstring.h>
#include <qpushbutton.h>
#include "propertyedit.h"

boxproperties::boxproperties(double uunits)
: boxpropertiesdialog()
{setupUi(this);
calcOperation=true;
userunits=uunits;
userunitsValidator v(uunits,this);
decimals=v.decimals();
layerNr->setMaximum(layersMax-1);
layerNr->setMinimum(0);
connect(layerNr,SIGNAL(valueChanged(int)),this,SLOT(setLayerName(int)));
//left->setValidator(new QIntValidator((-1<<30),(1<<30),left));
valid=new userunitsValidator(uunits,this);
left->setValidator(valid);
right->setValidator(valid);
top->setValidator(valid);
bottom->setValidator(valid);
widthBox->setValidator(valid);
heightBox->setValidator(valid);
/*left->setValidator(new userunitsValidator(uunits,left));
right->setValidator(new userunitsValidator(uunits,right));
top->setValidator(new userunitsValidator(uunits,top));
bottom->setValidator(new userunitsValidator(uunits,bottom));*/
connect(left,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(right,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(top,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(bottom,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(widthBox,SIGNAL(textChanged(const QString &)),this,SLOT(checkInputWidth(const QString &)));
connect(heightBox,SIGNAL(textChanged(const QString &)),this,SLOT(checkInputHeight(const QString &)));
connect(toPolygon,SIGNAL( clicked()),this,SLOT(DoneToPolygon()));
connect(deleteBox,SIGNAL( clicked()),this,SLOT(DoneDeleteBox()));
connect(attributeButton,SIGNAL(clicked()),this,SLOT(showAttributes()));
connect(fullDisplay,SIGNAL( clicked()),this,SLOT(displayAll()));
setModal(true);
}

boxproperties::~boxproperties()
{
left->setValidator(NULL);
right->setValidator(NULL);
top->setValidator(NULL);
bottom->setValidator(NULL);
widthBox->setValidator(NULL);
heightBox->setValidator(NULL);
delete valid;
}

/*$SPECIALIZATION$*/
void boxproperties::reject()
{
  QDialog::reject();
}

void boxproperties::accept()
{
  updateElement();
  QDialog::accept();
}

void boxproperties::updateElement(){
  calcOperation=true;
  element->rect.setLeft(element::round(left->text().toDouble()/userunits));
  element->rect.setRight(element::round(right->text().toDouble()/userunits));
  element->rect.setTop(element::round(top->text().toDouble()/userunits));
  element->rect.setBottom(element::round(bottom->text().toDouble()/userunits));
  element->layerNum=layerNr->value();
  element->datatype=datatype->value();
}

void boxproperties::setElement(box *b){
   calcOperation=true;
   element=b;
   QString s;
   s.setNum((double)(b->rect.left())*userunits,'f',decimals);
   left->setText(s);
   s.setNum((double)(b->rect.right())*userunits,'f',decimals);
   right->setText(s);
   s.setNum((double)(b->rect.top())*userunits,'f',decimals);
   top->setText(s);
   s.setNum((double)(b->rect.bottom())*userunits,'f',decimals);
   bottom->setText(s);
   layerNr->setValue(b->layerNum);
   setLayerName(b->layerNum);
   datatype->setValue(b->datatype);
   bool hide_=true;
   if (b->datatype==0) {datatypeBox->hide();hide_=false;}
   OK->setFocus();
   if (element->property.size()==0) attributeButton->hide();
   else if (hide_) fullDisplay->hide();
   calcCenter();
   calcOperation=false;
}

 void boxproperties::displayAll(){
fullDisplay->hide();
datatypeBox->show();
attributeButton->show();
}

void boxproperties::setLayerName(int val){
   layerName->setText(layers::num[val].name);
}

void boxproperties::check(){

QString s;
bool b=true;
int i=0;
s=left->text();
if (left->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=right->text();
if (right->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=top->text();
if (top->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=bottom->text();
if (bottom->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=widthBox->text();
if (widthBox->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=heightBox->text();
if (heightBox->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
OK->setEnabled(b);
}

void boxproperties::checkInput(const QString &){
check();
if (OK->isEnabled()&&(!calcOperation)) calcCenter();
}

void boxproperties::checkInputWidth(const QString &){
check();
if (OK->isEnabled()&&(!calcOperation)){
	calcOperation=true;
	int width= element::round(widthBox->text().toDouble()/userunits);
	int left_=center.x()-width/2;
	QString s;
   	s.setNum((double)(left_)*userunits,'f',decimals);
   	left->setText(s);
   	s.setNum((double)(left_+width)*userunits,'f',decimals);
   	right->setText(s);
	calcOperation=false;
}
}

void boxproperties::checkInputHeight(const QString &){
check();
if (OK->isEnabled()&&(!calcOperation)){
	calcOperation=true;
	int height= element::round(heightBox->text().toDouble()/userunits);
	int bottom_=center.y()-height/2;
	QString s;
   	s.setNum((double)(bottom_)*userunits,'f',decimals);
   	bottom->setText(s);
   	s.setNum((double)(bottom_+height)*userunits,'f',decimals);
   	top->setText(s);
	calcOperation=false;
}
}

void boxproperties::calcCenter(){
  calcOperation=true;
  int x=(element::round(left->text().toDouble()/userunits)+element::round(right->text().toDouble()/userunits))/2;
  int y=(element::round(top->text().toDouble()/userunits)+element::round(bottom->text().toDouble()/userunits))/2;
  int width= (-element::round(left->text().toDouble()/userunits)+ element::round(right->text().toDouble()/userunits));
  int height= (element::round(top->text().toDouble()/userunits) -element::round(bottom->text().toDouble()/userunits));
  center=QPoint(x,y);
  QString s;
  s.setNum((double)(height)*userunits,'f',decimals);
  heightBox->setText(s);
  s.setNum((double)(width)*userunits,'f',decimals);
  widthBox->setText(s);
  calcOperation=false;
}

void boxproperties::showAttributes(){
propertyEdit pe(&element->property);
pe.exec();

}

