/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "defines.h"
#include "setupwindow.h"
#include <qpushbutton.h>
#include <qvalidator.h>
#include <qlineedit.h>
#include "general/setup.h"
#include <qstring.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qfiledialog.h>
#include "layout.h"
#include <qcheckbox.h> 
#include <qcolordialog.h>
#include "elements/text.h"
#include <QFileDialog>
#include <QInputDialog>
#include <QLabel>
#include <QStyleFactory>
#include "styles.cpp"
#include <QMessageBox>
#include "general/userunitsvalidator.h"
#ifdef FULL_VERSION
#include "license/license.h"
#endif



layerManager *setupWindow::layerManagerWindow=NULL;

setupWindow::setupWindow(QWidget* parent)
: setupWindowDialog()
{setupUi(this);
netlistDisplayed="";
layoutPtr.p=parent;
circularDefault->setValidator(new QDoubleValidator(0.00001,360,6,circularDefault));
userunits->setValidator(new QDoubleValidator(0.0000000001,1000000000,10,userunits));
databaseunits->setValidator(new QDoubleValidator(0.00000000001,1000000000,10,databaseunits));
connect(circularDefault,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(userunits,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(databaseunits,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(defaultTextWidth,SIGNAL(valueChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(fontFileSelect,SIGNAL(clicked()),this,SLOT(chooseFont()));
connect(viewMouseColor,SIGNAL(clicked()),this,SLOT(setMouseColor()));
connect(viewGridColor,SIGNAL(clicked()),this,SLOT(setGridColor()));
connect(viewSelectColor,SIGNAL(clicked()),this,SLOT(setSelectColor()));
connect(viewHighlightColor,SIGNAL(clicked()),this,SLOT(setHighlightColor()));
connect(viewZeroColor,SIGNAL(clicked()),this,SLOT(setZeroColor()));
connect(viewBackgroundColor,SIGNAL(clicked()),this,SLOT(setBackgroundColor()));
connect(wireColor,SIGNAL(clicked()),this,SLOT(setWireColor()));
connect(busColor,SIGNAL(clicked()),this,SLOT(setBusColor()));
connect(pinColor,SIGNAL(clicked()),this,SLOT(setPinColor()));
connect(textColor,SIGNAL(clicked()),this,SLOT(setTextColor()));
connect(deviceColor,SIGNAL(clicked()),this,SLOT(setDeviceColor()));
connect(instanceColor,SIGNAL(clicked()),this,SLOT(setInstanceColor()));
connect(setDocumentationDirectory,SIGNAL(clicked()),this,SLOT(chooseDocumentationDirectory()));
connect(setMacroDirectory,SIGNAL(clicked()),this,SLOT(chooseMacroDirectory()));
connect(showLayerManager,SIGNAL(clicked()),this,SLOT(openLayerManager()));
connect(showLayerManager2,SIGNAL(clicked()),this,SLOT(openLayerManager()));
connect(netListType,SIGNAL(currentIndexChanged(int)),this,SLOT(netlistSet(int)));
connect(netlistTypeAdd,SIGNAL(clicked()),this,SLOT(netlistAdd()));
connect(hierarchyType,SIGNAL(currentIndexChanged(int)),this,SLOT(netlistSubSet(int)));
connect(hierarchyAdd,SIGNAL(clicked()),this,SLOT(netlistSubAdd()));
setModal(true);
pixelOptimizeLayerColorStart->setMaximum(layersMax-1);
LefBondingBoxLayer->setMaximum(layersMax-1);
displayedLayers->setMaximum(layersMax-1);
listWidget->setCurrentItem(0);
stackedWidget->setCurrentIndex(0);
setWindowIcon(QIcon(":/layoutIcon"));
windowStyle->addItems(mystyles::existingStyles());
language->addItem("auto");
language->addItem("english");
language->addItem("german");
language->addItem("russian");
}

setupWindow::~setupWindow()
{
if (layerManagerWindow!=NULL) {
	delete layerManagerWindow;
	layerManagerWindow=NULL;
}
}

void setupWindow::setHelpWindow(helpWindow *w){ 
connect(buttonHelp,SIGNAL(clicked()),w,SLOT(showSetupHelp())); 
}

void setupWindow::checkInput(const QString &){
  QString s;
  bool b=true;
  int i=0;
  double dbunits=databaseunits->text().toDouble();
  if (dbunits==0) dbunits=layoutPtr.l->drawing->databaseunits;
  double userunits_=dbunits/userunits->text().toDouble();
  if (userunits_==0) userunits_=layoutPtr.l->drawing->userunits;
//printf("%f %f\n",dbunits,userunits_);
  userunitsValidator vali(userunits_,this);
  if (defaultTextWidth->value()>0) defaultTextWidth->setDecimals(vali.decimals());
  else defaultTextWidth->setDecimals(0);
  s=circularDefault->text();
  if (circularDefault->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
  s=userunits->text();
  if (userunits->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
  s=databaseunits->text();
  if (databaseunits->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
  buttonOk->setEnabled(b);
}

/*$SPECIALIZATION$*/
void setupWindow::reject()
{
  QDialog::reject();
}

void setupWindow::accept()
{
  QDialog::accept();
  //default
  setup::circularDefault=circularDefault->text().toDouble();
//  setup::defaultPathWidth=defaultPathWidth->value();
  if (defaultPathNoCaps->isChecked()){setup::defaultPathCap=0;}
  if (defaultPathRoundCaps->isChecked()){setup::defaultPathCap=1;}
  if (defaultPathSquareCaps->isChecked()){setup::defaultPathCap=2;}
  if (defaultTextTopLeft->isChecked()) {setup::defaultTextPresentation=0;}
  else if (defaultTextTopCenter->isChecked()) {setup::defaultTextPresentation=1;}
  else if (defaultTextTopRight->isChecked()) {setup::defaultTextPresentation=2;}
  else if (defaultTextCenterLeft->isChecked()) {setup::defaultTextPresentation=4;}
  else if (defaultTextCenterCenter->isChecked()) {setup::defaultTextPresentation=5;}
  else if (defaultTextCenterRight->isChecked()) {setup::defaultTextPresentation=6;}
  else if (defaultTextBottomLeft->isChecked()) {setup::defaultTextPresentation=8;}
  else if (defaultTextBottomCenter->isChecked()) {setup::defaultTextPresentation=9;}
  else if (defaultTextBottomRight->isChecked()) {setup::defaultTextPresentation=10;}
  setup::defaultBezierIteration=defaultBezierIteration->value();
  //fileformat
  if (cifSaveCircle->isChecked()) {setup::cifSaveCircle=true;} 
    else setup::cifSaveCircle=false;
   if (cifTopCell->isChecked()) {setup::cifTopCell=true;} 
    else setup::cifTopCell=false;   
  if (dxfSaveCircle->isChecked()) {setup::dxfSaveCircle=true;} 
    else setup::dxfSaveCircle=false;
  if (oasisSaveCircle->isChecked()) {setup::oasisSaveCircle=true;} 
    else setup::oasisSaveCircle=false;
  if (oasisSaveCtrapezoid->isChecked()) {setup::oasisSaveCtrapezoid=true;} 
    else setup::oasisSaveCtrapezoid=false;
  if (oasisSaveTrapezoid->isChecked()) {setup::oasisSaveTrapezoid=true;} 
    else setup::oasisSaveTrapezoid=false;
  if (oasisSaveCBlock->isChecked()) {setup::oasisSaveCBlock=true;} 
    else setup::oasisSaveCBlock=false;
 
  if (gdsAutoMapDatatypes->isChecked()) {setup::gdsAutoMapDatatypes=true;} 
    else setup::gdsAutoMapDatatypes=false;  
  if (oasisAutoMapDatatypes->isChecked()) {setup::oasisAutoMapDatatypes=true;} 
    else setup::oasisAutoMapDatatypes=false;
  if (gdsPad2048->isChecked()) {setup::gdsPad2048=true;} 
    else setup::gdsPad2048=false;
  if (gdsMultiXYRecord->isChecked()) {setup::gdsMultiXYRecord=true;} 
    else setup::gdsMultiXYRecord=false;
  if (gdsMapLayer->isChecked()) {setup::gdsMapLayer=true;} 
    else setup::gdsMapLayer=false;
  if (gdsBoxToPolygon->isChecked()) {setup::gdsBoxToPolygon=true;} 
    else setup::gdsBoxToPolygon=false;
  if (oasisMapLayer->isChecked()) {setup::oasisMapLayer=true;} 
    else setup::oasisMapLayer=false;
  if (fixselfintersecting->isChecked()) {setup::defaultPolygonFixSelfintersectingPolygons=true;} 
    else setup::defaultPolygonFixSelfintersectingPolygons=false;
  if (removenotneededpoints->isChecked()) {setup::defaultPolygonRemoveNotNeededPoints=true;} 
    else setup::defaultPolygonRemoveNotNeededPoints=false;
// layers 
  layers::displayedLayers=(int)displayedLayers->value()+1;
 if (autoDisableUnusedLayers->isChecked()) {setup::autoDisableUnusedLayers=true;} 
    else setup::autoDisableUnusedLayers=false;  
  //font
 if (fontExternal->isChecked())
  setup::font=fontFile->text();
 else if (fontInternal0->isChecked()) setup::font="0";
 else if (fontInternal1->isChecked()) setup::font="1";
 else if (fontInternal2->isChecked()) setup::font="2";
 else if (fontInternal3->isChecked()) setup::font="3";
 else if (fontInternal4->isChecked()) setup::font="4";
 else setup::font="";
  setup::fontIteration=fontIteration->value();
  setup::fontSize=fontSize->value();
  textRender::reset();
  //report
  if (showReportNever->isChecked()) setup::showReport=-1;
  else if (showReportFatalError->isChecked()) setup::showReport=0;
  else if (showReportError->isChecked()) setup::showReport=1;
  else if (showReportStrongWarning->isChecked()) setup::showReport=2;
  else if (showReportWarning->isChecked()) setup::showReport=3;
  else if (showReportInformation->isChecked()) setup::showReport=4;
  else if (showReportAlways->isChecked()) setup::showReport=5;
  //units
  double dbunits=databaseunits->text().toDouble();
  if (dbunits!=layoutPtr.l->drawing->databaseunits) {
  	if (databaseunitScale->isChecked())
		for (cellList *f =layoutPtr.l->drawing->firstCell; f!=NULL;f=f->next_cell) {f->this_cell->resize(layoutPtr.l->drawing->databaseunits/dbunits);}
	layoutPtr.l->drawing->databaseunits=dbunits;
  	}
  layoutPtr.l->drawing->userunits=layoutPtr.l->drawing->databaseunits/userunits->text().toDouble();
  //view
  setup::preferedLanguage=language->currentText();
  if (viewMouseCross->isChecked()) setup::mouseView=1;
  else if (viewMouseLines->isChecked()) setup::mouseView=2;
  else if (viewMouseDualCross->isChecked()) setup::mouseView=3;
  else if (viewMousePoint->isChecked()) setup::mouseView=0;
  setup::mouseColor=viewMouseColor->palette().color(QPalette::Window);
  setup::gridColor= viewGridColor->palette().color(QPalette::Window);
  setup::selectColor=viewSelectColor->palette().color(QPalette::Window);
  setup::highlightColor= viewHighlightColor->palette().color(QPalette::Window);
  setup::zeroColor= viewZeroColor->palette().color(QPalette::Window);
  setup::backgroundColor= viewBackgroundColor->palette().color(QPalette::Window);
  if (viewMenubar->isChecked()) layoutPtr.l->showMenuBar();
  else layoutPtr.l->hideMenuBar();
   if (showMenuIcons->isChecked()) setup::showMenuIcons=true;
  else setup::showMenuIcons=false;
  setup::scrollDirection=scrollDir->isChecked();
  setup::displayCellName=viewCellrefName->isChecked();
  setup::displayCellOrigin=viewCellrefOrigin->isChecked();
  setup::displayCells= viewCellrefCell->isChecked();
  setup::depthOfCellrefs=depthOfCellrefs->value();
  setup::layerDockStyle=layerDockStyle->currentIndex();
  setup::documentationDirectory=documentationDirectory->text();
  int eng=0;
  if (paintEngineNormal->isChecked())eng=0;
  if (paintEngineTransparent->isChecked())eng=1;
  if (paintEngineStacked->isChecked())eng=2;
  if (eng!=setup::paintEngine){
		setup::paintEngine=eng;
		/*if ((eng==1)&&(setup::backgroundColor.value ()>150)) {
			setup::backgroundColor=QColor(0,0,0);
	QMessageBox::information ( this, QString("PaintEngine"), QString("The transparent paint engine requires a dark<br>background. Background color is set to black."));
			}*/
  }
  if (setup::macroDirectory!=macroDirectory->text()){
  	setup::macroDirectory=macroDirectory->text();
	}
  if (windowStyle->currentText()!=setup::windowStyle){
         setup::windowStyle=windowStyle->currentText();
          QApplication::setStyle(mystyles::createStyle(setup::windowStyle));
	};
   if (updateCheck->isChecked()) setup::updateCheck=true;
  else setup::updateCheck=false;
  
#ifndef GENISYS
  int v=1;
  if (custommodeButton->isChecked()) v=5;
  if (viewermodeButton->isChecked()) v=4;
  if (basicmodeButton->isChecked()) v=3;
  if (intermediatemodeButton->isChecked()) v=2;
  if (fullmodeButton->isChecked()) v=1;
  if (v!=setup::getViewMode()) {
	  setup::setViewMode(v);
  }
#endif
  setup::gdsMaxPoints=gdsMaxPoints->value();
  setup::apLamda=apLambaValue->value();
  setup::sourceDatabase=sourceDatabase->value();
  setup::tldLamda=tldLambaValue->value();
  setup::pixelColorBits=pixelColorResolution->value();
  setup::csvFieldDelimiter= csvFieldDelimiterChair->text();
  if (setup::csvFieldDelimiter.size()==0)setup::csvFieldDelimiter=",";
  //netlist
  if (autotriggerExtract->isChecked()) setup::netlistAutotrigger=true;
  else setup::netlistAutotrigger=false;
  setup::netlistUnnamedNodes=prefixNodes->text();
  setup::netlistGlobalNodes=globalNodes->text();
  setup::wireColor= wireColor->palette().color(QPalette::Window);
  setup::busColor= busColor->palette().color(QPalette::Window);
  setup::pinColor= pinColor->palette().color(QPalette::Window);
  setup::textColor= textColor->palette().color(QPalette::Window);
  setup::instanceColor= instanceColor->palette().color(QPalette::Window);
  setup::deviceColor= deviceColor->palette().color(QPalette::Window);
  setup::lefCellBoundaryLayer=LefBondingBoxLayer->value();
  if (pixelOptmizeLayerColors->isChecked())
         setup::pixelLayerMap=pixelOptimizeLayerColorStart->value();
  else  setup::pixelLayerMap=-1;
  if (pixelPreMeter->isChecked()){
	setup::pixelResolution=pixelresolution->value();
	}
  else if (pixelInDPI->isChecked()){
	setup::pixelResolution=element::runden(1.0*pixelresolution->value()*100.0/2.54);
	}
  else if (pixelFromFile->isChecked()){
	setup::pixelResolution=-1;
	}
  else setup::pixelResolution=0;

 if (epsCrLf->isChecked())
  setup::epsEndOfLine=0;
 else if (epsLf->isChecked()) setup::epsEndOfLine=1;
 if (svgCrLf->isChecked())
  setup::svgEndOfLine=0;
 else if (svgLf->isChecked()) setup::svgEndOfLine=1;
 setup::epsScale=epsScale->value();
 setup::defaultPathWidth=abs(element::round(defaultPathWidth->value()/layoutPtr.l->drawing->userunits));
 setup::defaultTextWidth=element::round(defaultTextWidth->value()/layoutPtr.l->drawing->userunits);
 if (defaultTextWidth->value()<0)setup::defaultTextWidth=(int)defaultTextWidth->value();
 netlistStore();
 setup::netlistFormat=netlistFormat;
 netlistSubStore();
 setup::netlistSubFormat=netlistSubFormat;
 setup::netlistSubModelFormat=netlistSubModelFormat;
}

void setupWindow::openFont(){
listWidget->setCurrentRow(2);
stackedWidget->setCurrentIndex(2);
open();
}

void setupWindow::open()
{
  QString s;
  //defaults
  circularDefault->setText(s.setNum(setup::circularDefault));
   userunitsValidator vali(layoutPtr.l->drawing->userunits,this);
   defaultPathWidth->setValue((double)(setup::defaultPathWidth)*layoutPtr.l->drawing->userunits);
   defaultPathWidth->setDecimals(vali.decimals());
  //defaultPathWidth->setValue(setup::defaultPathWidth);
  switch (setup::defaultPathCap){
   case 0: defaultPathNoCaps->setChecked(true);
   	break;
   case 1: defaultPathRoundCaps->setChecked(true);
   	break;
   case 2: defaultPathSquareCaps->setChecked(true);
   	break;
   }
   defaultTextWidth->setValue((double)(setup::defaultTextWidth)*layoutPtr.l->drawing->userunits);
   if (setup::defaultTextWidth<0) defaultTextWidth->setValue(setup::defaultTextWidth);
   if (setup::defaultTextWidth>0)defaultTextWidth->setDecimals(vali.decimals());
   else defaultTextWidth->setDecimals(0);
   switch (setup::defaultTextPresentation){
   case 0: defaultTextTopLeft->setChecked(true);break;
   case 1: defaultTextTopCenter->setChecked(true);break;
   case 2: defaultTextTopRight->setChecked(true);break;
   case 4: defaultTextCenterLeft->setChecked(true);break;
   case 5: defaultTextCenterCenter->setChecked(true);break;
   case 6: defaultTextCenterRight->setChecked(true);break;
   case 8: defaultTextBottomLeft->setChecked(true);break;
   case 9: defaultTextBottomCenter->setChecked(true);break;
   case 10: defaultTextBottomRight->setChecked(true);break;
   }
   defaultBezierIteration->setValue(setup::defaultBezierIteration);
   //fileformat
   cifSaveCircle->setChecked(setup::cifSaveCircle);
   cifTopCell->setChecked(setup::cifTopCell);
   dxfSaveCircle->setChecked(setup::dxfSaveCircle);
   oasisSaveCircle->setChecked(setup::oasisSaveCircle);
   oasisSaveCtrapezoid->setChecked(setup::oasisSaveCtrapezoid);
   oasisSaveTrapezoid->setChecked(setup::oasisSaveTrapezoid);
   oasisSaveCBlock->setChecked(setup::oasisSaveCBlock);
   gdsPad2048->setChecked(setup::gdsPad2048);
   gdsMultiXYRecord->setChecked(setup::gdsMultiXYRecord);
   gdsMapLayer->setChecked(setup::gdsMapLayer);
   gdsBoxToPolygon->setChecked(setup::gdsBoxToPolygon);
   oasisMapLayer->setChecked(setup::oasisMapLayer);
   fixselfintersecting->setChecked(setup::defaultPolygonFixSelfintersectingPolygons);
   removenotneededpoints->setChecked(setup::defaultPolygonRemoveNotNeededPoints);
   gdsMaxPoints->setValue(setup::gdsMaxPoints);
   apLambaValue->setValue(setup::apLamda);
   sourceDatabase->setValue(setup::sourceDatabase);
   tldLambaValue->setValue(setup::tldLamda);
   csvFieldDelimiterChair->setText(setup::csvFieldDelimiter);
   oasisAutoMapDatatypes->setChecked(setup::oasisAutoMapDatatypes);
   gdsAutoMapDatatypes->setChecked(setup::gdsAutoMapDatatypes);
   pixelColorResolution->setValue(setup::pixelColorBits);
   //layer
   autoDisableUnusedLayers->setChecked(setup::autoDisableUnusedLayers);
   displayedLayers->setValue(layers::displayedLayers-1);
   //font
   fontFile->setText("");
   if (setup::font.length()>1) {
			fontExternal->setChecked(true);
			fontFile->setText(setup::font);
			}
   else if (setup::font=="0") fontInternal0->setChecked(true);
   else if (setup::font=="1") fontInternal1->setChecked(true);
   else if (setup::font=="2") fontInternal2->setChecked(true);
   else if (setup::font=="3") fontInternal3->setChecked(true);
   else if (setup::font=="4") fontInternal4->setChecked(true);
   else fontInternal0->setChecked(true);
   if (textRender::internalFonts.size()<5) fontInternal4->hide();
   if (textRender::internalFonts.size()<4) fontInternal3->hide();
   if (textRender::internalFonts.size()<3) fontInternal2->hide();
   if (textRender::internalFonts.size()<2) fontInternal1->hide();
   fontIteration->setValue(setup::fontIteration);
   fontSize->setValue(setup::fontSize);
   //report
   switch (setup::showReport){
   case -1: showReportNever->setChecked(true);break;
   case 0: showReportFatalError->setChecked(true);break;
   case 1: showReportError->setChecked(true);break;
   case 2: showReportStrongWarning->setChecked(true);break;
   case 3: showReportWarning->setChecked(true);break;
   case 4: showReportInformation->setChecked(true);break;
   case 5: showReportAlways->setChecked(true);break;
   }
   //units
   userunits->setText(s.setNum(layoutPtr.l->drawing->databaseunits/layoutPtr.l->drawing->userunits));
   databaseunits->setText(s.setNum(layoutPtr.l->drawing->databaseunits));
   databaseunitScale->setChecked(true);
   //view
   switch (setup::mouseView){
   case 1: viewMouseCross->setChecked(true);break;
   case 2: viewMouseLines->setChecked(true);break;
   case 3: viewMouseDualCross->setChecked(true);break;
   case 0: viewMousePoint->setChecked(true);break;
   }
   QPalette p=viewMouseColor->palette();
   p.setColor(QPalette::Window,setup::mouseColor);
   p.setColor(QPalette::Button,setup::mouseColor);
   viewMouseColor->setPalette(p);
   viewMouseColor->setAutoFillBackground(true);
   p=viewGridColor->palette();
   p.setColor(QPalette::Window,setup::gridColor);
   p.setColor(QPalette::Button,setup::gridColor);
   viewGridColor->setPalette(p);
   viewGridColor->setAutoFillBackground(true);
   p=viewSelectColor->palette();
   p.setColor(QPalette::Window,setup::selectColor);
   p.setColor(QPalette::Button,setup::selectColor);
   viewSelectColor->setPalette(p);
   viewSelectColor->setAutoFillBackground(true);
   p=viewHighlightColor->palette();
   p.setColor(QPalette::Window,setup::highlightColor);
   p.setColor(QPalette::Button,setup::highlightColor);
   viewHighlightColor->setPalette(p);
   viewHighlightColor->setAutoFillBackground(true);
   p=viewZeroColor->palette();
   p.setColor(QPalette::Window,setup::zeroColor);
   p.setColor(QPalette::Button,setup::zeroColor);
   viewZeroColor->setPalette(p);
   viewZeroColor->setAutoFillBackground(true);
   p=viewBackgroundColor->palette();
   p.setColor(QPalette::Window,setup::backgroundColor);
   p.setColor(QPalette::Button,setup::backgroundColor);
   viewBackgroundColor->setPalette(p);
   viewBackgroundColor->setAutoFillBackground(true);
   if (layoutPtr.l->isMenuBarVisible()) viewMenubar->setChecked(true);
   else  viewMenubar->setChecked(false);
   showMenuIcons->setChecked( setup::showMenuIcons);
   scrollDir->setChecked(setup::scrollDirection);
   viewCellrefName->setChecked(setup::displayCellName);
   viewCellrefCell->setChecked(setup::displayCells);
   viewCellrefOrigin->setChecked(setup::displayCellOrigin);
   depthOfCellrefs->setValue(setup::depthOfCellrefs);
   layerDockStyle->setCurrentIndex(setup::layerDockStyle);
   documentationDirectory->setText(setup::documentationDirectory);
   macroDirectory->setText(setup::macroDirectory);
   updateCheck->setChecked(setup::updateCheck);
   int eng=setup::paintEngine;
   if (eng==0) paintEngineNormal->setChecked(true);
   if (eng==1) paintEngineTransparent->setChecked(true);
   if (eng==2) paintEngineStacked->setChecked(true);
   //windowStyle->addItems(QStyleFactory::keys ());
   //windowStyle->addItems(mystyles::existingStyles());
   windowStyle->setCurrentIndex(windowStyle->findText(setup::windowStyle));
   language->setCurrentIndex(language->findText(setup::preferedLanguage));
   int v=setup::getViewMode();
#ifdef ADDON_CUSTOMMODE
   if (v==5) custommodeButton->setChecked(true);
#else
   custommodeButton->setVisible(false);
#endif
   if (v==4) viewermodeButton->setChecked(true);
   if (v==3) basicmodeButton->setChecked(true);
   if (v==2) intermediatemodeButton->setChecked(true);
   if (v==1) fullmodeButton->setChecked(true);
#ifdef FULL_VERSION
   if (license::licenseLevel()<5) fullmodeButton->setCheckable(false);
   if (license::licenseLevel()<4) intermediatemodeButton->setCheckable(false);
   if (license::licenseLevel()<3) basicmodeButton->setCheckable(false);
#endif
#ifndef FULL_VERSION
	fullmodeButton->setCheckable(false);
	intermediatemodeButton->setCheckable(false);
#endif
#ifdef GENISYS
	modeBox->hide();
	listWidget->takeItem(7);
	viewTab->setTabEnabled(2,false);
#endif
   //netlist
  autotriggerExtract->setChecked(setup::netlistAutotrigger);
  prefixNodes->setText(setup::netlistUnnamedNodes);
  globalNodes->setText(setup::netlistGlobalNodes);
  netlistDisplayed="";
  netlistFormat=setup::netlistFormat;
  netlistSet();
  netlistSubDisplayed="";
  netlistSubFormat=setup::netlistSubFormat;
  netlistSubModelFormat=setup::netlistSubModelFormat;
  netlistSubSet();
   p.setColor(QPalette::Window,setup::wireColor);
   p.setColor(QPalette::Button,setup::wireColor);
   wireColor->setPalette(p);
   wireColor->setAutoFillBackground(true);
   p.setColor(QPalette::Window,setup::busColor);
   p.setColor(QPalette::Button,setup::busColor);
   busColor->setPalette(p);
   busColor->setAutoFillBackground(true);
   p.setColor(QPalette::Window,setup::pinColor);
   p.setColor(QPalette::Button,setup::pinColor);
   pinColor->setPalette(p);
   pinColor->setAutoFillBackground(true);
   p.setColor(QPalette::Window,setup::textColor);
   p.setColor(QPalette::Button,setup::textColor);
   textColor->setPalette(p);
   textColor->setAutoFillBackground(true);
   p.setColor(QPalette::Window,setup::deviceColor);
   p.setColor(QPalette::Button,setup::deviceColor);
   deviceColor->setPalette(p);
   deviceColor->setAutoFillBackground(true);
   p.setColor(QPalette::Window,setup::instanceColor);
   p.setColor(QPalette::Button,setup::instanceColor);
   instanceColor->setPalette(p);
   instanceColor->setAutoFillBackground(true);
  LefBondingBoxLayer->setValue(setup::lefCellBoundaryLayer);
  if (setup::pixelLayerMap>=0) {
    pixelOptimizeLayerColorStart->setValue(setup::pixelLayerMap);
    pixelOptmizeLayerColors->setChecked(true);
	}
  else {
       pixelOptimizeLayerColorStart->setValue(128);
    pixelOptmizeLayerColors->setChecked(false);
	}
  if (setup::pixelResolution>0){
	pixelPreMeter->setChecked(true);
	pixelresolution->setValue(setup::pixelResolution);
	int resDPI=element::runden(1.0*setup::pixelResolution*2.54/100.0);
	if ((resDPI%10==0) && (setup::pixelResolution%100 != 0)){
	  pixelresolution->setValue(resDPI);
	  pixelInDPI->setChecked(true);
	}
  } else if (setup::pixelResolution==-1) {
	pixelFromFile->setChecked(true);
	}
   else pixelUseUserunits->setChecked(true);
 if (setup::epsEndOfLine==0) epsCrLf->setChecked(true);
 else if(setup::epsEndOfLine==1) epsLf->setChecked(true);
 if (setup::svgEndOfLine==0) svgCrLf->setChecked(true);
 else if(setup::svgEndOfLine==1) svgLf->setChecked(true);
 epsScale->setValue(setup::epsScale);

   show();
}

void setupWindow::chooseDocumentationDirectory(){
 QFileDialog file;
 file.setAcceptMode ( QFileDialog::AcceptOpen);
 file.setFileMode(QFileDialog::DirectoryOnly);
 file.setWindowTitle(tr("Choose Documentation Directory"));
 file.setModal(true);
 file.setViewMode(QFileDialog::List);
 file.setDirectory(documentationDirectory->text()+"/..");
 file.selectFile(documentationDirectory->text());
 file.show();
 int i=file.exec();
 if (i==QDialog::Accepted) {
 	QStringList files = file.selectedFiles();
       if (!files.isEmpty()) {
		int i=files[0].length();
		if (i>1) documentationDirectory->setText(files[0]);}
 }
}

void setupWindow::chooseMacroDirectory(){
 QFileDialog file;
 file.setAcceptMode ( QFileDialog::AcceptOpen);
 file.setFileMode(QFileDialog::DirectoryOnly);
 file.setWindowTitle(tr("Choose Macro Directory"));
 file.setModal(true);
 file.setViewMode(QFileDialog::List);
 file.setDirectory(macroDirectory->text()+"/..");
 file.selectFile(macroDirectory->text());
 file.show();
 int i=file.exec();
 if (i==QDialog::Accepted) {
 	QStringList files = file.selectedFiles();
       if (!files.isEmpty()) {
		int i=files[0].length();
		if (i>1) macroDirectory->setText(files[0]);}
 }
}

void setupWindow::chooseFont(){
 QFileDialog file;
 file.setWindowTitle(tr("Select Font"));
 file.setAcceptMode ( QFileDialog::AcceptOpen);
 file.setViewMode(QFileDialog::List);
 file.setModal(true);
 QStringList l;
 l<<tr("supported Formats")+"(*.ttf *.pfb *.bdf *.pfr *.pcf *cff *.cid)";
 l<<tr("All Files")+" (*)";
 file.setFilters(l);
// file.setPreviewMode(QFileDialog::NoPreview);
 QString s=setup::font;
 int i=s.lastIndexOf("/");
 if (i>0) {s=s.left(i);}
 file.setDirectory(s);
 file.show();
 i=file.exec();
 if (i==QDialog::Accepted){
 	QStringList files = file.selectedFiles();
        if (!files.isEmpty()) fontFile->setText(files[0]);
	fontExternal->setChecked(true);
	}
}

void setupWindow::setMouseColor(){
  QColor color=QColorDialog::getColor(setup::mouseColor);
  if (color.isValid()){
	QPalette p=viewMouseColor->palette();
  	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	viewMouseColor->setPalette(p);
  	}
}

void setupWindow::setGridColor(){
  QColor color=QColorDialog::getColor(setup::gridColor);
  if (color.isValid()){
   	QPalette p=viewGridColor->palette();
   	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	viewGridColor->setPalette(p);
	}
}
void setupWindow::setSelectColor(){
  QColor color=QColorDialog::getColor(setup::selectColor);
  if (color.isValid()){
  	QPalette p=viewSelectColor->palette();
   	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	viewSelectColor->setPalette(p);
        }
}
void setupWindow::setHighlightColor(){
  QColor color=QColorDialog::getColor(setup::highlightColor);
  if (color.isValid()){
  	QPalette p=viewHighlightColor->palette();
   	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	viewHighlightColor->setPalette(p);
        }
}
void setupWindow::setZeroColor(){
  QColor color=QColorDialog::getColor(setup::zeroColor);
  if (color.isValid()){
  	QPalette p=viewZeroColor->palette();
   	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	viewZeroColor->setPalette(p);
  	}
}
void setupWindow::setBackgroundColor(){
  QColor color=QColorDialog::getColor(setup::backgroundColor);
  if (color.isValid()){
  	QPalette p=viewBackgroundColor->palette();
   	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	viewBackgroundColor->setPalette(p);
  	}
}

void setupWindow::setWireColor(){
  QColor color=QColorDialog::getColor(setup::wireColor);
  if (color.isValid()){
	QPalette p=wireColor->palette();
  	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	wireColor->setPalette(p);
  	}
}

void setupWindow::setBusColor(){
  QColor color=QColorDialog::getColor(setup::busColor);
  if (color.isValid()){
	QPalette p=busColor->palette();
  	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	busColor->setPalette(p);
  	}
}

void setupWindow::setPinColor(){
  QColor color=QColorDialog::getColor(setup::pinColor);
  if (color.isValid()){
	QPalette p=pinColor->palette();
  	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	pinColor->setPalette(p);
  	}
}

void setupWindow::setTextColor(){
  QColor color=QColorDialog::getColor(setup::textColor);
  if (color.isValid()){
	QPalette p=textColor->palette();
  	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	textColor->setPalette(p);
  	}
}

void setupWindow::setDeviceColor(){
  QColor color=QColorDialog::getColor(setup::deviceColor);
  if (color.isValid()){
	QPalette p=deviceColor->palette();
  	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	deviceColor->setPalette(p);
  	}
}

void setupWindow::setInstanceColor(){
  QColor color=QColorDialog::getColor(setup::instanceColor);
  if (color.isValid()){
	QPalette p=instanceColor->palette();
  	p.setColor(QPalette::Window,color);
	p.setColor(QPalette::Button,color);
   	instanceColor->setPalette(p);
  	}
}

void setupWindow::openLayerManager(){
  if (gdsMapLayer->isChecked()) {setup::gdsMapLayer=true;} 
  if (oasisMapLayer->isChecked()) {setup::oasisMapLayer=true;} 
 if (layerManagerWindow==NULL) layerManagerWindow=new layerManager();
 layerManagerWindow->open();
}


void setupWindow::netlistAdd(){
bool b;
QString s=QInputDialog::getText(this,"Add Netlist Format","Enter Netlist Name:",QLineEdit::Normal,QString::null,&b);
if (b&&(s!=QString::null)) {
	netListType->addItem(s);
	netlistSet(s);
	}
}

void setupWindow::netlistSubAdd(){
bool b;
QString s=QInputDialog::getText(this,"Add Hierarchy Format","Enter Type Name:",QLineEdit::Normal,QString::null,&b);
if (b&&(s!=QString::null)) {
	hierarchyType->addItem(s);
	netlistSubSet(s);
	}
}

void setupWindow::netlistSet(int){
QString s=netListType->currentText();
if (s!=netlistDisplayed) netlistSet(s);
}

void setupWindow::netlistSubSet(int){
QString s=hierarchyType->currentText();
if (s!=netlistSubDisplayed) netlistSubSet(s);
}

void setupWindow::netlistSet(QString s){
netlistStore();
netlistExport->setPlainText(netlistFormat.value(s).toString());
netlistDisplayed=s;
int i=netListType->findText(s);
if (i>=0) netListType->setCurrentIndex(i);
}

void setupWindow::netlistSubSet(QString s){
netlistSubStore();
hierarchyNetlist->setPlainText(netlistSubFormat.value(s).toString());
hierarchyModel->setPlainText(netlistSubModelFormat.value(s).toString());
netlistSubDisplayed=s;
int i=hierarchyType->findText(s);
if (i>=0) hierarchyType->setCurrentIndex(i);
}

void setupWindow::netlistSet(){
netlistStore();
QStringList sl;
sl=netlistFormat.keys();
 sl.sort();
 netListType->clear();
 netListType->addItems(sl);
 if (sl.size()>0) netlistSet(sl.at(0));
}

void setupWindow::netlistSubSet(){
netlistSubStore();
QStringList sl;
sl=netlistSubFormat.keys();
 sl.sort();
 hierarchyType->clear();
 hierarchyType->addItems(sl);
 if (sl.size()>0) netlistSubSet(sl.at(0));
}

void setupWindow::netlistStore(){
if (netlistDisplayed!=""){
	if (netlistExport->toPlainText ().trimmed()!=""){
		netlistFormat.insert(netlistDisplayed,QVariant(netlistExport->toPlainText ()));
	}
	else netlistFormat.remove(netlistDisplayed);
	netlistDisplayed="";
	}
}

void setupWindow::netlistSubStore(){
if (netlistSubDisplayed!=""){
	if (hierarchyNetlist->toPlainText ().trimmed()!=""){
		netlistSubFormat.insert(netlistSubDisplayed,QVariant(hierarchyNetlist->toPlainText ()));
		netlistSubModelFormat.insert(netlistSubDisplayed,QVariant(hierarchyModel->toPlainText ()));
	}
	else {
	  netlistSubFormat.remove(netlistSubDisplayed);
	  netlistSubModelFormat.remove(netlistSubDisplayed);
	}
	netlistSubDisplayed="";
	}
}
