/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LAYERMANAGER_H
#define LAYERMANAGER_H


#include "general/layers.h"
#include "ui_layermanagerdialog.h"
#include <QDialog>
#include "layersetupwidget2.h"
#include "widgets/layersetupbutton.h"

class display3dData {
  public:
    int top;
    int bottom;
    QBrush brush;
    int col;
    int layer;
};

class display3d : public QWidget{
  Q_OBJECT
  public:
  display3d(QWidget* parent = 0);
  ~display3d();
  QBrush brush;
  int top;
  int bottom;
  int cols;
  QList<display3dData> data;
  int min,max;
  QString layerName;
  int mouseMovePos;
  bool moveTop,moveBottom;
  
  int w;
  int o;
  double scale;
  protected:
    virtual void paintEvent ( QPaintEvent * event );
    virtual void mousePressEvent ( QMouseEvent * event );
    virtual void mouseReleaseEvent ( QMouseEvent * event );
    virtual void mouseMoveEvent ( QMouseEvent * event );
  signals:
    void selectLayer(int layer);
    void setupChange(int level,int thickness);
};

class layerManager : public QDialog, private Ui::layerManagerDialog
{
  Q_OBJECT
public:
  layerManager(QWidget* parent = 0);
  ~layerManager();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
  void open();

  
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
  void changeStyle(int bs);
  void setPixmap();
  void allEnable();
  void allDisable();
  void readLayer();
  void writeLayer();
  void changeColor();
  void layerChanged(int);
  void change3d(int);
  void setup3d();
  void set3d(int,int);
private:
  display3d *setup3dView;
  layersetupbutton *b[layerStyle];
  layerSetupWidget2 *layerWidget[layersMax];
  QPixmap pixmap;
  QBrush brush;
  QPen pen;
  int brushStyle;
  int currentLayer;
  int initLayer;
  bool ignoreChange;
};

#endif

