/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SINGLETOOLBUTTON_H
#define SINGLETOOLBUTTON_H

#include "mousewidget.h"
#include <qtoolbutton.h>
#include <QEvent>
#include <QToolBar>
#include "widgets/shortkeytoolbutton.h"

/**
@author Juergen Thies
*/
class singleToolButton : public shortKeyToolButton
{
Q_OBJECT
public:
	singleToolButton (QWidget *parent = 0);
    singleToolButton ( const QIcon & iconSet, const QString & textLabel, QObject * receiver, const char * slot, QToolBar * parent,QString WhatThis,helpText helptext  ) ;
    singleToolButton ( const QString & textLabel, QObject * receiver, const char * slot, QToolBar * parent, helpText helptext  ) ;
    singleToolButton ( const QString & textLabel, bool * b, QToolBar * parent,helpText helptext  ) ;
    singleToolButton ( const QIcon & iconSet, const QString & textLabel, bool * b, QToolBar * parent,QString WhatThis,helpText helptext  ) ;
    //helpText helpMouse;
    ~singleToolButton();
    bool *boolValue;

    void setIndicator( bool * b);
    void setMode(int mode);
    void updateBool(){setChecked (*boolValue);}
private:
    quint16 mode;
protected:
    void enterEvent ( QEvent * e ){mouseWidget::set(helpMouse);QToolButton::enterEvent(e);}
    bool event(QEvent * e);
public slots:
    void processClick();
    void modeChanged(int oldMode,int newMode);
};

#endif
