/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "layer.h"
#include "widgets/shortkey.h"
#include <QBitmap>

layer::layer():shortKey()
{
layerType=layerTypeUnknown;
name="???";
visible=true;
use=true;
pen.setColor(qRgb(255,0,0));
//brush.setColor(qRgb(255,0,0));
//brush.setStyle(Qt::FDiagPattern);
level3d=0;
thickness3d=0;
brushStyle=0;
shortkey="";
}


layer::~layer()
{
}

bool layer::isEnabled(){
return use;
}

 void layer::setColor(int red, int green, int blue){
 pen.setColor(qRgb(red,green,blue));
 //brush.setColor(qRgb(red,green,blue));
 }
 
 void layer::setStyle(int style){
 brushStyle=style;
 //brush=getBrush(style);
 //brush.setColor(pen.color());
/*
 switch (style){
 case 0: brush.setStyle(Qt::NoBrush); break;
 case 1: brush.setStyle(Qt::SolidPattern); break;
 case 2: brush.setStyle(Qt::Dense1Pattern); break;
 case 3: brush.setStyle(Qt::Dense2Pattern); break;
 case 4: brush.setStyle(Qt::Dense3Pattern); break;
 case 5: brush.setStyle(Qt::Dense4Pattern); break;
 case 6: brush.setStyle(Qt::Dense5Pattern); break;
 case 7: brush.setStyle(Qt::Dense6Pattern); break;
 case 8: brush.setStyle(Qt::Dense7Pattern); break;
 case 9: brush.setStyle(Qt::HorPattern); break;
 case 10: brush.setStyle(Qt::VerPattern); break;
 case 11: brush.setStyle(Qt::CrossPattern); break;
 case 12: brush.setStyle(Qt::BDiagPattern); break;
 case 13: brush.setStyle(Qt::FDiagPattern); break;
 case 14: brush.setStyle(Qt::DiagCrossPattern); break;
 default: brush.setStyle(Qt::NoBrush); break;}*/
 }

QBrush layer::getBrush(int i){
QBrush brush;
switch (i){
 case 0: brush.setStyle(Qt::NoBrush); break;
 case 1: brush.setStyle(Qt::Dense7Pattern); break; //7%
 case 2: brush.setStyle(Qt::Dense6Pattern); break; //13%
 case 3:  //dense 19%
	{
	QBitmap b(4,4);
	b.clear();
	static const uchar ahj[] = {
  	 0x04, 0x00, 0x08, 0x01};
	b=QBitmap::fromData(QSize(4,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 4:  //dense 25%
	{
	QBitmap b(4,4);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x08, 0x01, 0x04};
	b=QBitmap::fromData(QSize(4,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 5:  //dense 31%
	{
	QBitmap b(4,4);
	b.clear();
	static const uchar ahj[] = {
  	 0x08, 0x02, 0x05, 0x02};
	b=QBitmap::fromData(QSize(4,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 6: brush.setStyle(Qt::Dense5Pattern); break; //dense 37%
 case 7:  //dense 44%
	{
	QBitmap b(4,4);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x05, 0x0a, 0x05};
	b=QBitmap::fromData(QSize(4,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 8: brush.setStyle(Qt::Dense4Pattern); break; //dense 50%
 case 9: brush.setStyle(Qt::SolidPattern); break;
 case 10:  //hor 1:3
	{
	QBitmap b(4,4);
	b.clear();
	static const uchar ahj[] = {
  	 0x00, 0x00, 0x0f, 0x00};
	b=QBitmap::fromData(QSize(4,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
case 11:  //27
	{
	QBitmap b(8,4);
	b.clear();
	static const uchar ahj[] = {
  	 0x03, 0x0C,0x30,0xC0};
	b=QBitmap::fromData(QSize(8,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 12:  //45
	{
	QBitmap b(5,5);
	b.clear();
	static const uchar ahj[] = {
  	 0x01, 0x02,0x04, 0x08,0x10,0x20,0x40,0x80};
	b=QBitmap::fromData(QSize(5,5),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 13:  //72
	{
	QBitmap b(4,8);
	b.clear();
	static const uchar ahj[] = {
	0x01, 0x01, 0x02,  0x02,0x04, 0x04, 0x08,  0x08 };
	b=QBitmap::fromData(QSize(4,8),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 14:  //VERTICAL
	{
	QBitmap b(4,4);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x02,0x02,0x02};
	b=QBitmap::fromData(QSize(4,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 15:  //72
	{
	QBitmap b(4,8);
	b.clear();
	static const uchar ahj[] = {
	0x08, 0x08, 0x04,  0x04,0x02, 0x02, 0x01,  0x01 };
	b=QBitmap::fromData(QSize(4,8),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 16:  //45
	{
	QBitmap b(5,5);
	b.clear();
	static const uchar ahj[] = {
  	 0x10, 0x08,0x04, 0x02,0x01,0x00,0x00,0x00};
	b=QBitmap::fromData(QSize(5,5),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 17:  //27
	{
	QBitmap b(8,4);
	b.clear();
	static const uchar ahj[] = {
	0xC0, 0x30, 0x0C,  0x03 };
	b=QBitmap::fromData(QSize(8,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 18:  //45 cross
	{
	QBitmap b(4,4);
	b.clear();
	static const uchar ahj[] = {
  	 0xff, 0x01,0x01, 0x01,0x11,0x00,0x00,0x00};
	b=QBitmap::fromData(QSize(4,4),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 19:  //45 cross
	{
	QBitmap b(5,5);
	b.clear();
	static const uchar ahj[] = {
  	 0x11, 0x0a,0x04, 0x0a,0x11,0x00,0x00,0x00};
	b=QBitmap::fromData(QSize(5,5),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 20: brush.setStyle(Qt::HorPattern); break; //hor 1:7
 case 21:  //27
	{
	QBitmap b(16,16);
	b.clear();
	static const uchar ahj[] = {
  	 0x03, 0x00,0x0C, 0x00,0x30, 0x00,0xC0, 0x00,0x00, 0x03,0x00, 0x0C,0x00, 0x30,0x00, 0xC0,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00};
	b=QBitmap::fromData(QSize(12,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;

 case 22:  //hor 1:7 dot
	{
	QBitmap b(8,8);
	b.clear();
	static const uchar ahj[] = {
  	 0x01, 0x02,0x04, 0x08,0x10,0x20,0x40,0x80};
	b=QBitmap::fromData(QSize(8,8),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 23:  //27
	{
	QBitmap b(16,16);
	b.clear();
	static const uchar ahj[] = {
  	 0x01, 0x01,0x02, 0x02,0x04, 0x04,0x08, 0x08,0x10, 0x10,0x20, 0x20};
	b=QBitmap::fromData(QSize(6,12),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 24: brush.setStyle(Qt::VerPattern); break;
 case 25:  //27
	{
	QBitmap b(16,16);
	b.clear();
	static const uchar ahj[] = {
  	 0x20, 0x20,0x10, 0x10,0x08, 0x08,0x04, 0x04,0x02, 0x02,0x01, 0x01};
	b=QBitmap::fromData(QSize(6,12),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 26: brush.setStyle(Qt::BDiagPattern); break;


 case 27:  //27
	{
	QBitmap b(16,16);
	b.clear();
	static const uchar ahj[] = {
  	//0x01, 0xC0,0x00, 0x30,
	0x00, 0x0C,0x00, 0x03,
	0xC0, 0x00,0x30, 0x00,0x0C, 0x00, 0x03, 0x00, 0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00};
	b=QBitmap::fromData(QSize(12,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 28: brush.setStyle(Qt::CrossPattern); break;
 case 29: brush.setStyle(Qt::DiagCrossPattern); break;
 case 30:  //
	{
	QBitmap b(6,6);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x07,0x02, 0x10,0x28,0x10,0x00,0x00};
	b=QBitmap::fromData(QSize(6,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 31:  //
	{
	QBitmap b(6,6);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x02,0x02, 0x10,0x10,0x10,0x00,0x00};
	b=QBitmap::fromData(QSize(6,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 32:  //
	{
	QBitmap b(6,6);
	b.clear();
	static const uchar ahj[] = {
  	 0x00, 0x07,0x00, 0x00,0x38,0x00,0x00,0x00};
	b=QBitmap::fromData(QSize(6,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 33:  //
	{
	QBitmap b(6,6);
	b.clear();
	static const uchar ahj[] = {
  	 0x00, 0x07,0x00, 0x10,0x10,0x10,0x00,0x00};
	b=QBitmap::fromData(QSize(6,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 34:  //
	{
	QBitmap b(6,6);
	b.clear();
	static const uchar ahj[] = {
  	 0x01, 0x02,0x04, 0x20,0x10,0x08,0x00,0x00};
	b=QBitmap::fromData(QSize(6,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 35:  //
	{
	QBitmap b(6,6);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x07,0x02, 0x10,0x38,0x10,0x00,0x00};
	b=QBitmap::fromData(QSize(6,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 36:  //
	{
	QBitmap b(6,6);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x05,0x02, 0x10,0x28,0x10,0x00,0x00};
	b=QBitmap::fromData(QSize(6,6),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 37:  //
	{
	QBitmap b(5,5);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x05,0x02, 0x00,0x00,0x00,0x00,0x00};
	b=QBitmap::fromData(QSize(5,5),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 38:  //
	{
	QBitmap b(5,5);
	b.clear();
	static const uchar ahj[] = {
  	 0x05, 0x02,0x05, 0x00,0x00,0x00,0x00,0x00};
	b=QBitmap::fromData(QSize(5,5),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 case 39:  //
	{
	QBitmap b(5,5);
	b.clear();
	static const uchar ahj[] = {
  	 0x02, 0x07,0x02, 0x00,0x00,0x00,0x00,0x00};
	b=QBitmap::fromData(QSize(5,5),ahj,QImage::Format_MonoLSB);
	brush.setTexture(b);
	brush.setStyle(Qt::TexturePattern);
	}
	break;
 default: brush.setStyle(Qt::NoBrush); break;}
return brush;
}

int layer::getStyle(){
return brushStyle;
/*if (brush.style()==Qt::NoBrush) return 0;
if (brush.style()==Qt::SolidPattern) return 1;
if (brush.style()==Qt::Dense1Pattern) return 2;
if (brush.style()==Qt::Dense1Pattern) return 3;
if (brush.style()==Qt::Dense1Pattern) return 4;
if (brush.style()==Qt::Dense1Pattern) return 5;
if (brush.style()==Qt::Dense1Pattern) return 6;
if (brush.style()==Qt::Dense1Pattern) return 7;
if (brush.style()==Qt::Dense1Pattern) return 8;
if (brush.style()==Qt::HorPattern) return 9;
if (brush.style()==Qt::VerPattern) return 10;
if (brush.style()==Qt::CrossPattern) return 11;
if (brush.style()==Qt::BDiagPattern) return 12;
if (brush.style()==Qt::FDiagPattern) return 13;
if (brush.style()==Qt::DiagCrossPattern) return 14;
return 0;*/
}

int layer::getShortkeyKey(){
return shortKey::getShortkeyKey(shortkey);
/*int i=shortkey.indexOf("+",1);
QString s=shortkey;
if (i>0) {
  s=s.mid(i+1).trimmed().left(1);
} else
s=s.trimmed().left(1);
if (s=="1") return Qt::Key_1;
if (s=="2") return Qt::Key_2;
if (s=="3") return Qt::Key_3;
if (s=="4") return Qt::Key_4;
if (s=="5") return Qt::Key_5;
if (s=="6") return Qt::Key_6;
if (s=="7") return Qt::Key_7;
if (s=="8") return Qt::Key_8;
if (s=="9") return Qt::Key_9;
if (s=="0") return Qt::Key_0;
if (s=="a") return Qt::Key_A;
if (s=="b") return Qt::Key_B;
if (s=="c") return Qt::Key_C;
if (s=="d") return Qt::Key_D;
if (s=="e") return Qt::Key_E;
if (s=="f") return Qt::Key_F;
if (s=="g") return Qt::Key_G;
if (s=="h") return Qt::Key_H;
if (s=="i") return Qt::Key_I;
if (s=="j") return Qt::Key_J;
if (s=="k") return Qt::Key_K;
if (s=="l") return Qt::Key_L;
if (s=="m") return Qt::Key_M;
if (s=="n") return Qt::Key_N;
if (s=="o") return Qt::Key_O;
if (s=="p") return Qt::Key_P;
if (s=="q") return Qt::Key_Q;
if (s=="r") return Qt::Key_R;
if (s=="s") return Qt::Key_S;
if (s=="t") return Qt::Key_T;
if (s=="u") return Qt::Key_U;
if (s=="v") return Qt::Key_V;
if (s=="w") return Qt::Key_W;
if (s=="x") return Qt::Key_X;
if (s=="y") return Qt::Key_Y;
if (s=="z") return Qt::Key_Z;
if (s=="+") return Qt::Key_Plus;
if (s=="-") return Qt::Key_Minus;
if (s==",") return Qt::Key_Comma;
if (s=="*") return Qt::Key_Asterisk;
if (s=="F1") return Qt::Key_F1;
if (s=="F2") return Qt::Key_F2;
if (s=="F3") return Qt::Key_F3;
if (s=="F4") return Qt::Key_F4;
if (s=="F5") return Qt::Key_F5;
if (s=="F6") return Qt::Key_F6;
if (s=="F7") return Qt::Key_F7;
if (s=="F8") return Qt::Key_F8;
if (s=="F9") return Qt::Key_F9;
if (s=="F10") return Qt::Key_F10;
if (s=="F11") return Qt::Key_F11;
if (s=="F12") return Qt::Key_F12;
if (s=="Insert") return Qt::Key_Insert;
if (s=="Delete") return Qt::Key_Delete;
if (s=="Clear") return Qt::Key_Clear;
if (s=="Home") return Qt::Key_Home;
if (s=="End") return Qt::Key_End;
if (s=="Left") return Qt::Key_Left;
if (s=="Up") return Qt::Key_Up;
if (s=="Right") return Qt::Key_Right;
if (s=="Down") return Qt::Key_Down;
if (s=="PageUp") return Qt::Key_PageUp;
if (s=="PageDown") return Qt::Key_PageDown;
if (s=="Space") return Qt::Key_Space;
if (s=="\"") return Qt::Key_QuoteDbl;
if (s=="#") return Qt::Key_NumberSign;
if (s=="$") return Qt::Key_Dollar;
if (s=="%") return Qt::Key_Percent;
if (s=="&") return Qt::Key_Ampersand;
if (s=="'") return Qt::Key_Apostrophe;
if (s=="(") return Qt::Key_ParenLeft;
if (s==")") return Qt::Key_ParenRight;
if (s==":") return Qt::Key_Colon;
if (s==";") return Qt::Key_Semicolon;
if (s=="?") return Qt::Key_Question;
if (s=="<") return Qt::Key_Less;
if (s=="=") return Qt::Key_Equal;
if (s==">") return Qt::Key_Greater;
if (s=="@") return Qt::Key_At;
return 0;*/
}
 

Qt::KeyboardModifiers layer::getShortkeyModifiers(){

return shortKey::getShortkeyModifiers(shortkey);
/*int i=shortkey.indexOf("+");
QString s=shortkey;
if (i>=0) {
  s=s.left(i).trimmed();
} else
 return Qt::NoModifier;
//printf("%s\n",s.toAscii().data());
if (s== "shift")return Qt::ShiftModifier;
if (s== "Shift")return Qt::ShiftModifier;
if (s== "SHIFT")return Qt::ShiftModifier;
if (s== "ctrl")return Qt::ControlModifier;
if (s== "CTRL")return Qt::ControlModifier;
if (s== "alt")return Qt::AltModifier;
if (s== "ALT")return Qt::AltModifier;
if (s== "Meta")return Qt::MetaModifier ;
if (s== "META")return Qt::MetaModifier ;

return Qt::NoModifier;*/

}

 void layer::setType(layerTypesType t){
layerType=t;
typeParameter.clear();
switch (t){
case layerTypeUnknown:
	break;
case layerTypeVia:
	typeParameter<<0;
	typeParameter<<1;
	typeParameter<<500;
	typeParameter<<500;
	typeParameter<<500;
	typeParameter<<0;
	break;
case layerTypeConductor:
	typeParameter<<0;
	typeParameter<<1000;
	typeParameter<<1000;
	break;
}
}

int layer::getType(){
switch (layerType){
case layerTypeUnknown: return 0;
	break;
case layerTypeVia: return 1;
	break;
case layerTypeConductor: return 2;
	break;
default:
	return 0;
}
}

void layer::setType(int type){
switch (type){
case 0: setType(layerTypeUnknown);
	break;
case 1: setType(layerTypeVia);
	break;
case 2: setType(layerTypeConductor);
	break;
default:
	setType(layerTypeUnknown);
}
}

void layer::setTypeParameter(int i,int value){
if (typeParameter.size()>i) typeParameter[i]=value;
}

int layer::getTypeParameter(int i){
if (typeParameter.size()>i) return typeParameter[i];
return -1;
}
