/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "filegeneral.h"
#include "elements/cell.h"
#include "elements/celllist.h"
#include "layout.h"
#include "macro/macro.h"
#include "general/project.h"
#include <QFileInfo>
#ifdef SCHEMATIC
#include "schematic/schematic.h"
#include "schematic/schematicdisplay.h"
#endif

filegeneral::filegeneral(QObject *parent, const char *)
 : QObject(parent)
{
}


filegeneral::~filegeneral()
{
}

void filegeneral::import(errorreport *err,drawingField *d,cellList *celll){
// modify already existing cellname, add a number, delete existing identical cells
	cellList *f=d->firstCell;
	d->firstCell=celll;
	QString s;
	cellList *e;
	for (e=f;e!=NULL;e=e->next_cell){
		//printf("check with%d\n",e->this_cell);
		 cell *exist=d->findCell(e->this_cell->cellName);
		//printf("check%d\n",exist);
	    // if (d->existCellname(e->this_cell->cellName))
		 if (exist!=NULL)
			{
			//printf("exists!\n");
			 if (exist->identical(e->this_cell)){
				//printf("ident found\n");
				err->addItem(tr("Identical cell exists, cell not added"),3,e->this_cell->cellName);
				cellList *e2=d->firstCell;
  				while (e2!=NULL){
					//printf("while\n");
					if ((e2->thisCell!=NULL)&&(e2->thisCell!=exist)&&(e2->thisCell!=e->this_cell))  
						e2->thisCell->relink(exist,e->this_cell);
					e2=e2->nextCell;
				  	}
				//printf("del %d\n",exist);
				d->deleteCell(exist);
				//printf("del finished %d\n",exist);
			}
			 else {
	     		int i=1;
				s=e->this_cell->cellName+s.setNum(i);
				while (d->existCellname(s)){i++;s=e->this_cell->cellName+s.setNum(i);}
				e->this_cell->cellName=s;
			 }
		 }
	}
	//printf("end loop %d\n",d->firstCell);
	e=d->firstCell;
	if (e!=NULL) {
		while (e->nextCell!=NULL){e=e->nextCell;}
		e->nextCell=f; 
		}
	else d->firstCell=f;
	//printf("end import\n");
}

void filegeneral::update(errorreport *report,drawingField *d,cellList *celll){
//replace existing cells with new cells
  cellList *f=d->firstCell;
  d->firstCell=celll;
  QString s;
  cellList *e;
  for (e=f;e!=NULL;e=e->next_cell){
	if (d->existCellname(e->this_cell->cellName)){
		report->addItem(tr("Cell(s) updated."),4,e->this_cell->cellName);
		cellList *h=d->firstCell;
		while (h->thisCell->cellName!=e->this_cell->cellName) h=h->nextCell;
		cell *help=h->thisCell;
		h->thisCell=e->thisCell;
		e->thisCell=help;
		d->updateCellref(e->thisCell,h->thisCell);
	     	}}
  d->currentCell=d->findTopCell();
  // add required cells
  e=f;
  while (e!=NULL){
  	cellList *h=e->next_cell;
	if (d->depend(e->thisCell)){
		e->nextCell=d->firstCell;
		d->firstCell=e;
		report->addItem(tr("Cell(s) added."),3,e->this_cell->cellName);
		} 
	else {
		delete e;
		}
  	e=h;
  }
}

void filegeneral::fitDifferentDatabaseunits(errorreport *report, drawingField *d, double databaseunitshelp){
if (d->databaseunits!=databaseunitshelp) {
		QString s;
		report->addItem(tr("Databaseunits are different.Import is fitted."),4,s.setNum(d->databaseunits,'g',10));
		bool b=false;
		for (cellList *f =d->firstCell; f!=NULL;f=f->nextCell) {
			//printf("%f\n",d->databaseunits/databaseunitshelp);
			if (d->databaseunits/databaseunitshelp<1){
				int mod=element::runden(databaseunitshelp/d->databaseunits);
				f->this_cell->resize(d->databaseunits/databaseunitshelp,mod,&b);
				//printf("%d\n",mod);
				}
			else
			f->this_cell->resize(d->databaseunits/databaseunitshelp);
			}
		if (b) report->addItem(tr("Databaseunits are different. Precision is reduced!"),4,s.setNum(d->databaseunits,'g',10));
		d->databaseunits=databaseunitshelp;}
}

void filegeneral::resolveBrockenCellrefs(errorreport *report, drawingField *d, cellList *celll, fileOpenType ftype){
 for (cellList *f =d->firstCell; f!=NULL;f=f->nextCell) {
  	if (f->thisCell!=NULL){
  		for (elementList *e=f->thisCell->firstElement;e!=NULL;e=e->nextElement){
			if (e->thisElement->isCellref()||e->thisElement->isCellrefArray()) {
				 if (e->thisElement->depend()==NULL){e->thisElement->setCellRef(d->findCell(e->thisElement->getName()));}
				 if ((e->thisElement->depend()==NULL)&&(ftype==fileImport)){  //refs to before existing cells
						cellList *c=d->firstCell;
						d->firstCell=celll;
				 		e->thisElement->setCellRef(d->findCell(e->thisElement->getName()));
						d->firstCell=c;}
				 if (e->thisElement->depend()==NULL){
				 	//add empty cells
					cellList *c;
  					c=d->addCell();
  					c->thisCell->cellName=e->thisElement->getName();
					e->thisElement->setCellRef(d->findCell(e->thisElement->getName()));
					report->addItem(tr("Cellref(s) can not be resolved. Empty cell added."),1,e->thisElement->getName());}
			}
			if (e==0) {break;}
			
		}
	f->thisCell->clean();
  	}
  }
}


void filegeneral::openBundle(QString fileName,drawingField *d){
  layout *l=reinterpret_cast <layout*>(d->parent());
  QString s1,s2;
  if (macro::isMacro(&fileName,&s1,&s2)) {
			l->executeMacro(fileName);}
  else {
	errorreport report;
	report.setTitle(tr("Load of LayoutEditor-Bundle")+" \""+fileName+"\"");
	report.addItem(tr("Aborted."),0);
	report.addItem(tr("File cannot be loaded. No valid macro!"),1);
	QString s=report.getReport();
	d->showReport(s,report.getLastRang());
  };
}

void filegeneral::saveBundle(QString fileName,drawingField *d){
  layout *l=reinterpret_cast <layout*>(d->parent());
  QFileInfo fi(fileName);
  QString base=fi.baseName();
  QString gdsFile=base+".gds.gz";
  QString s1;
  s1="file f;\n";
  s1+="string path=f.currentPath();\n";
  s1+="layout->closeDesign();\n";
  s1+="layout->drawing->openFile(\""+gdsFile+"\");\n";
  s1+="layout->filename=path+\"/"+gdsFile+"\";\n";
#ifdef SCHEMATIC
  schematic *s=NULL;
  QString lesFile;
  if (project::hasSchematic(l)) {
    s=project::getSchematic(l);
    lesFile=base+".les";
    s1+="schematic->drawing->openFile(\""+lesFile+"\");\n";
    s1+="schematic->filename=path+\"/"+lesFile+"\";\n";
  }
#endif
  layers::writeLayerMacro(0,layers::displayedLayers-1,fileName,s1);
  QString path=fi.path ();
  if (path=="") return;
  d->saveFile(path+"/"+gdsFile);
#ifdef SCHEMATIC
  if (s!=NULL) {
    s->drawing->saveFile(path+"/"+lesFile);
  }
#endif
}
