/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CELLREFPROPERTIES_H
#define CELLREFPROPERTIES_H

#include "ui_cellrefpropertiesdialog.h"
#include "strans.h"
#include <QDialog>
class cellref;
class drawingField;
class cellrefproperties : public QDialog, private Ui::cellrefpropertiesdialog
{
  Q_OBJECT

public:
  cellrefproperties(drawingField *);
  ~cellrefproperties();
  /*$PUBLIC_FUNCTIONS$*/
  cellref *element;
public slots:
  /*$PUBLIC_SLOTS$*/
   void setElement(cellref *b);
   void checkInput(const QString&);
   void updateElement();
   void DoneFlat(){updateElement();done(3);}
   void DoneArray(){updateElement();done(4);}
   void DoneDeleteCell(){done(2);}
   void showAttributes();
   void displayAll();
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
private:
 drawingField *drawing;
 double userunits;
 int decimals;

};

#endif

