/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlineedit.h>
#include <qvalidator.h>
#include "drcdimension.h"
#include "general/userunitsvalidator.h"
#include "elements/element.h"

drcDimension::drcDimension(double ,int  layer)
: drcDimensionDialog()
{
setupUi(this);
layerNr->setMaximum(layersMax-1);
connect(layerNr,SIGNAL(valueChanged(int)),this,SLOT(setLayerName(int)));
layerNr->setValue(layer);
drcWidth->setValue(1);
drcLength->setValue(1);
setModal(true);
}

drcDimension::~drcDimension()
{
}

void drcDimension::setLayerName(int i){
if (i>=0) layerName->setText(layers::num[i].name);
}

/*$SPECIALIZATION$*/
bool drcDimension::dialog(double uunits, int *layer, int *type,  int *length, int *width, bool*merge){
   drcDimension d(uunits,*layer);
    d.show();
    int i=d.exec();
    d.hide();
    switch (i) {
    case QDialog::Rejected :
    	return false;
    case QDialog::Accepted :
	*length=element::runden(d.drcLength->value()/uunits);
	*width=element::runden(d.drcWidth->value()/uunits);
	*layer=d.layerNr->value();
	*merge=d.mergeBefore->isChecked();
	*type=d.typeMinMax->currentIndex()+1;
	return true;
   }
  return false;
}




