/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder.
 */

package com.sun.messaging.jmq.util.timer;

import java.util.logging.Level;
import com.sun.messaging.jmq.util.log.Logger;

public class WakeupableTimer implements Runnable 
{
    private static boolean DEBUG = false;

    private Logger logger = null;
    private java.util.logging.Logger jlogger = null;

    private String name = null;
    private long nexttime = 0;
    private long repeatinterval = 0;
    private Thread thr = null;
    private Runnable runner = null;
    private boolean valid = true;
    private boolean wakeup = false;
    private String startString = null;
    private String exitString = null;

    public void setLogger(Object l) {
        if (l instanceof com.sun.messaging.jmq.util.log.Logger) {
            logger = (Logger)l;
            if (logger.getLevel() <= Logger.DEBUG) DEBUG = true;
        } else if (l instanceof java.util.logging.Logger) {
            jlogger = (java.util.logging.Logger)l;
            if (jlogger.isLoggable(Level.FINE)) DEBUG = true;
        }
    }

    /**
     * @param delaytime in millisecs
     * @param repeatinterval in millisecs, if 0 run runner only once
     */
    public WakeupableTimer(String name, Runnable runner, 
                           long delaytime, long repeatInterval,
                           String startString, String exitString,
                           Object logger) {
        this.name = name;
        this.nexttime = delaytime + System.currentTimeMillis();
        this.repeatinterval = repeatInterval;
        this.runner = runner;
        this.startString = startString;
        this.exitString = exitString;
        setLogger(logger);

        thr = new Thread(this, name);
        thr.start();
    }

    public synchronized void wakeup() {
        wakeup = true;
        notify();
    }

    public void cancel() {
        valid = false;
        wakeup();
        thr.interrupt();
    }

    public void run() {
        logInfo(startString);

        long time = System.currentTimeMillis();
        while (valid) {
            synchronized(this) {
                while (!wakeup && time < nexttime) {
                    try {
                        this.wait(nexttime  - time);
                    } catch (InterruptedException ex) {}
                    time = System.currentTimeMillis();
                }
                if (!valid) break; 
                wakeup =  false;
            }

            if (DEBUG) {
            logInfo(name+" run "+runner.getClass().getName());
            }

            runner.run();

            if (DEBUG) {
            logInfo(name+" completed run "+runner.getClass().getName());
            }

            if (!wakeup && repeatinterval == 0) break;
            time = System.currentTimeMillis();
            nexttime = time + repeatinterval;
        }

        logInfo(exitString);
    }

    private void logInfo(String msg) {
        if (logger != null) {
            logger.log(Logger.INFO, msg);
        } else if (jlogger != null) {
            jlogger.log(Level.INFO, msg);
        }
    }
}
