/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)PHashMapLoadException.java	1.3 06/29/07
 */ 

package com.sun.messaging.jmq.util;

/**
 * This class provides information about problems and/or data corruptions
 * encountered when loading the a VRecord from the backing file.
 * If the key and/or the value of the hash map entry is loaded successfully,
 * it can be retrieved by calling <code>getKey()</code> and/or
 * <code>getValue</code> respectively. The throwable caught while
 * deserializing the key can be retrieved by calling
 * <code>getKeyCause()</code>. Similarly, the throwable caught while
 * deserializing the value can be retrieved by calling
 * <code>getValueCause()</code>. Other exception caught while parsing
 * the record, if any, can be retrieved by <code>getCause</code>.
 * <code>getNextException()</code> returns
 * the next chained exception for other loading problems or
 * <code>null</code> if there's no more chained exception.
 */

public class PHashMapLoadException extends Exception {

    private Object key = null;
    private Object value = null;
    private PHashMapLoadException next = null;
    private Throwable keyCause = null;
    private Throwable valueCause = null;

    /**
     * Constructs a PHashMapLoadException
     */ 
    public PHashMapLoadException(String msg) {
        super(msg);
    }

    public void setKey(Object k) {
	this.key = k;
    }

    /**
     * Return the key of the HashMap entry loaded from file.
     */
    public Object getKey() {
	return key;
    }

    public void setValue(Object v) {
	this.value = v;
    }

    /**
     * Return the value of the HashMap entry loaded from file.
     */
    public Object getValue() {
	return value;
    }

    public void setKeyCause(Throwable t) {
	this.keyCause = t;
    }

    /**
     * Return the Throwable caught while deserializing the key.
     */
    public Throwable getKeyCause() {
	return this.keyCause;
    }

    public void setValueCause(Throwable t) {
	this.valueCause = t;
    }

    /**
     * Return the Throwable caught while deserializing the value.
     */
    public Throwable getValueCause() {
	return this.valueCause;
    }

    public void setNextException(PHashMapLoadException e) {
	this.next = e;
    }

    /**
     * Return the exception chained to this object.
     */
    public PHashMapLoadException getNextException() {
	return next;
    }

    public String toString() {
	return getMessage() + "\nkey="+key+";cause="+keyCause+";value="+value
			+";cause="+valueCause;
    }
}
