/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)QueueConnectionImpl.java	1.22 06/27/07
 */ 

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import java.util.Properties;

import com.sun.messaging.AdministeredObject;

/** A QueueConnection is an active connection to a JMS PTP provider. A
  * client uses a QueueConnection to create one or more QueueSessions
  * for producing and consuming messages.
  *
  * @see         javax.jms.Connection
  * @see	 javax.jms.QueueConnectionFactory
  */

public class QueueConnectionImpl extends UnifiedConnectionImpl implements com.sun.messaging.jms.QueueConnection {

    public
    QueueConnectionImpl(Properties configuration, String username,
                        String password, String type) throws JMSException {
        super(configuration, username, password, type);

        //bug 6172663
        setIsTopicConnection(false);
        super.setIsQueueConnection(true);
    }

    public QueueSession
    createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {

        return super.createQueueSession(transacted, acknowledgeMode);
    }

    public QueueSession
    createQueueSession(int acknowledgeMode) throws JMSException {

        checkConnectionState();

        //disallow to set client ID after this action.
        setClientIDFlag();

        return new QueueSessionImpl ( this, acknowledgeMode );
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param topic the topic to access
    * @param subscriptionName durable subscription name
    * @param messageSelector only messages with properties matching the
    * message selector expression are delivered
    * @param sessionPool the serversession pool to associate with this
    * durable connection consumer.
    * @param maxMessages the maximum number of messages that can be
    * assigned to a server session at one time.
    *
    * @return the durable connection consumer.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    *
    * @see javax.jms.ConnectionConsumer
    */
    public ConnectionConsumer
    createDurableConnectionConsumer(Topic topic,
                                    String subscriptionName,
                                    String messageSelector,
                                    ServerSessionPool sessionPool,
                                    int maxMessages) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createDurableConnectionConsumer");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }
}
