# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libzlib

FIND_PATH(ZLIB_INCLUDE_DIR zlib.h)

SET(ZLIB_NAMES ${ZLIB_NAMES} z libz)
FIND_LIBRARY(ZLIB_LIBRARY NAMES ${ZLIB_NAMES} PATH)

IF(ZLIB_INCLUDE_DIR AND ZLIB_LIBRARY)
	SET(ZLIB_FOUND TRUE)
ENDIF(ZLIB_INCLUDE_DIR AND ZLIB_LIBRARY)

IF(ZLIB_FOUND)
	IF(NOT ZLIB_FIND_QUIETLY)
		MESSAGE(STATUS "Found ZLIB: ${ZLIB_LIBRARY}")
	ENDIF (NOT ZLIB_FIND_QUIETLY)
ELSE(ZLIB_FOUND)
	IF(ZLIB_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find ZLIB")
	ENDIF(ZLIB_FIND_REQUIRED)
ENDIF(ZLIB_FOUND)
