# Try to find the libmemcached
#
# LIBMEMCACHED_FOUND       - system has the libmemcached library
# LIBMEMCACHED_INCLUDE_DIR - the libmemcached include directory
# LIBMEMCACHED_LIBRARIES   - The libraries needed to use libmemcached

FIND_PATH(LIBMEMCACHED_INCLUDE_DIR libmemcached/memcached.h)

FIND_LIBRARY(LIBMEMCACHED_LIBRARY NAMES memcached PATH /usr/lib /usr/local/lib)

IF(LIBMEMCACHED_INCLUDE_DIR AND LIBMEMCACHED_LIBRARY)
	SET(LIBMEMCACHED_FOUND 1)
	SET(LIBMEMCACHED_LIBRARIES ${LIBMEMCACHED_LIBRARY})
	SET(LIBMEMCACHED_INCLUDE_DIRS ${LIBMEMCACHED_INCLUDE_DIR})
ELSE (LIBMEMCACHED_INCLUDE_DIR AND LIBMEMCACHED_LIBRARY)
	SET(LIBMEMCACHED_FOUND 0)
	SET(LIBMEMCACHED_LIBRARIES)
	SET(LIBMEMCACHED_INCLUDE_DIRS)
ENDIF (LIBMEMCACHED_INCLUDE_DIR AND LIBMEMCACHED_LIBRARY)

# Report the results.
IF (NOT LIBMEMCACHED_FOUND)
	SET(LIBMEMCACHED_DIR_MESSAGE "Libmemcached was not found.")
	IF (NOT LIBMEMCACHED_FIND_QUIETLY)
		MESSAGE(STATUS "${LIBMEMCACHED_DIR_MESSAGE}")
	ELSE (NOT LIBMEMCACHED_FIND_QUIETLY)
		IF (LIBMEMCACHED_FIND_REQUIRED)
			MESSAGE(FATAL_ERROR "${LIBMEMCACHED_DIR_MESSAGE}")
		ENDIF (LIBMEMCACHED_FIND_REQUIRED)
	ENDIF (NOT LIBMEMCACHED_FIND_QUIETLY)
ENDIF (NOT LIBMEMCACHED_FOUND)

MARK_AS_ADVANCED(
	LIBMEMCACHED_LIBRARY
	LIBMEMCACHED_INCLUDE_DIR
)
