# Try to find the FFI librairies
# FFI_FOUND - system has FFI lib
# FFI_INCLUDE_DIR - the FFI include directory
# FFI_LIBRARIES - Libraries needed to use FFI

if (FFI_INCLUDE_DIRS AND FFI_LIBRARIES)
	# Already in cache, be silent
	set(FFI_FIND_QUIETLY TRUE)
endif (FFI_INCLUDE_DIRS AND FFI_LIBRARIES)

INCLUDE(FindPkgConfig)

IF ( FFI_FIND_REQUIRED )
	SET( _pkgconfig_REQUIRED "REQUIRED" )
ELSE ( FFI_FIND_REQUIRED )
	SET( _pkgconfig_REQUIRED "" )
ENDIF ( FFI_FIND_REQUIRED )


PKG_SEARCH_MODULE( FFI ${_pkgconfig_REQUIRED} libffi )
IF ( PKG_CONFIG_FOUND )
SET ( FFI_FOUND TRUE )
ENDIF ( PKG_CONFIG_FOUND )

IF ( NOT FFI_FOUND AND NOT PKG_CONFIG_FOUND )
	find_path(FFI_INCLUDE_DIR NAMES ffi.h )
	find_library(FFI_LIBRARIES NAMES ffi libffi )
	SET(FFI_INCLUDE_DIRS ${FFI_INCLUDE_DIR})
ENDIF ( NOT FFI_FOUND AND NOT PKG_CONFIG_FOUND )


include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(FFI DEFAULT_MSG FFI_INCLUDE_DIRS FFI_LIBRARIES)

mark_as_advanced(FFI_INCLUDE_DIRS FFI_LIBRARIES)
