# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libdbi

FIND_PATH(DBI_INCLUDE_DIR dbi/dbi.h)

SET(DBI_NAMES ${DBI_NAMES} dbi libdbi)
FIND_LIBRARY(DBI_LIBRARY NAMES ${DBI_NAMES} PATH)

IF(DBI_INCLUDE_DIR AND DBI_LIBRARY)
	SET(DBI_FOUND TRUE)
ENDIF(DBI_INCLUDE_DIR AND DBI_LIBRARY)

IF(DBI_FOUND)
	IF(NOT DBI_FIND_QUIETLY)
		MESSAGE(STATUS "Found DBI: ${DBI_LIBRARY}")
	ENDIF (NOT DBI_FIND_QUIETLY)
ELSE(DBI_FOUND)
	IF(DBI_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find DBI")
	ENDIF(DBI_FIND_REQUIRED)
ENDIF(DBI_FOUND)
