#ifndef _UDF_H_INCLUDED

/*************************************************************************
vStrip by [maven] (maven@maven.de)
*************************************************************************/

#define _UDF_H_INCLUDED

#include "s_types.h"
#include "aspi.h"
#include "file_io.h"

#ifdef aspi_USE_ASPI

typedef byte Uint8;
typedef word Uint16;
typedef dword Uint32;
typedef unsigned __int64 Uint64;
typedef char dstring; // last byte of string indicates encoding/length

#define udf_LengthMask 0x3fffffff
#define udf_LengthMaskWrong 0x7fffffff

#define udf_TAG_PrimaryVolumeDescriptor 0x0001
#define udf_TAG_AnchorVolumeDescriptor 0x0002
#define udf_TAG_PartitionDescriptor 0x0005
#define udf_TAG_LogicalVolumeDescriptor 0x0006
#define udf_TAG_TerminatingDescriptor 0x0008
#define udf_TAG_FileSetDescriptor 0x0100
#define udf_TAG_FileIdentifierDescriptor 0x0101
#define udf_TAG_IndirectEntry 0x0103
#define udf_TAG_TerminalEntry 0x0104
#define udf_TAG_FileEntry 0x0105

#define udf_FT_IndirectEntry 0x03
#define udf_FT_Directory 0x04
#define udf_FT_File 0x05
#define udf_FT_TerminalEntry 0x0b

#define udf_icbf_Mask 0x0007
#define udf_icbf_ShortAd 0x0000
#define udf_icbf_LongAd 0x0001
#define udf_icbf_ExtAd 0x0002
#define udf_icbf_Direct 0x0003
#define udf_icbf_Contiguous 0x0100

#define udf_FID_Directory 0x02
#define udf_FID_Parent 0x08

#ifdef _WIN32
#pragma pack(push, 1)
#endif

typedef struct
{
	Uint32	Length;	// 00, high 2 bits: 0 ^= recorded & used, 1 ^= not recorded & used, 2 ^= not recorded & not used, 3 ^= linked list
	Uint32	Location;	// 04
} t_udf_short_ad, *tp_udf_short_ad;	// 08

typedef struct
{
	Uint32	Length;	// 00
	Uint32	Location;	// 04
} t_udf_extent_ad, *tp_udf_extent_ad; // 08

typedef struct
{
	Uint32	Location;	// 00, relative to volume
	Uint16	PartitionNumber;	// 04
} t_udf_lb_addr;	// 06

typedef struct
{
	Uint32	Length;	// 00, high 2 bits: 0 ^= recorded & used, 1 ^= not recorded & used, 2 ^= not recorded & not used, 3 ^= linked list
	t_udf_lb_addr	Location;	// 04
	byte	ImplementationUse[6];	// 10
} t_udf_long_ad, *tp_udf_long_ad;	// 16

typedef struct
{
	Uint32	Length;	// 00, high 2 bits: 0 ^= recorded & used, 1 ^= not recorded & used, 2 ^= not recorded & not used, 3 ^= linked list
	Uint32	RecordedLength;	// 04
	Uint32	InformationLength;	// 08
	t_udf_lb_addr	Location;	// 12
	byte	ImplementationUse[2];	// 18
} t_udf_ext_ad, *tp_udf_ext_ad;	// 20

typedef struct
{
	Uint8	CharacterSetType;	// 00
	byte	CharacterSetInfo[63];	// 01
} t_udf_charspec; // 64

typedef struct
{ /* ECMA 167 1/7.3 */
	Uint16	TypeAndTimezone;	// 00
	Uint16	Year;	// 02
	Uint8	Month;	// 04
	Uint8	Day;	// 05
	Uint8	Hour;	// 06
	Uint8	Minute;	// 07
	Uint8	Second;	// 08
	Uint8	Centiseconds;	// 09
	Uint8	HundredsofMicroseconds;	// 10
	Uint8	Microseconds;	// 11
} t_udf_timestamp;	// 12

typedef struct
{ /* ISO 13346 3/7.2 */
	Uint16	TagIdentifier;	// 00
	Uint16	DescriptorVersion;	// 02
	Uint8	TagChecksum;	// 04
	byte	Reserved;	// 05
	Uint16	TagSerialNumber;	// 06
	Uint16	DescriptorCRC;	// 08
	Uint16	DescriptorCRCLength;	// 10
	Uint32	TagLocation;	// 12
} t_udf_tag, *tp_udf_tag;	// 16

typedef struct
{ /* ISO 13346 1/7.4 */
	Uint8	Flags;	// 00
	char	Identifier[23];	// 01
	char	IdentifierSuffix[8];	// 24
} t_udf_EntityID; // 32

typedef struct
{ /* ISO 13346 3/10.2 */
	t_udf_tag	DescriptorTag;	// 00
	t_udf_extent_ad	MainVolumeDescriptorSequenceExtent;	// 16
	t_udf_extent_ad	ReserveVolumeDescriptorSequenceExtent;	// 24
	byte	Reserved[480];	// 32
} t_udf_AnchorVolumeDescriptorPointer, *tp_udf_AnchorVolumeDescriptorPointer;	// 512

typedef struct
{ /* ISO 13346 3/10.6 */
	t_udf_tag	DescriptorTag;	// 00
	Uint32	VolumeDescriptorSequenceNumber;	// 16
	t_udf_charspec	DescriptorCharacterSet;	// 20
	dstring	LogicalVolumeIdentifier[128];	// 84
	Uint32	LogicalBlockSize; //	212
	t_udf_EntityID	DomainIdentifier;	// 244
	//	byte	LogicalVolumeContentsUse[16];	// 276
	t_udf_long_ad	FileSetDescriptorSequence;	// 276
	Uint32	MapTableLength;	// 292
	Uint32	NumberofPartitionMaps;	// 296
	t_udf_EntityID	ImplementationIdentifier;	// 300
	byte	ImplementationUse[128];	// 332
	t_udf_extent_ad	IntegritySequenceExtent;	// 460
	byte	PartitionMaps[1];	// 468
} t_udf_LogicalVolumeDescriptor, *tp_udf_LogicalVolumeDescriptor;

typedef struct
{ 
	t_udf_short_ad	UnallocatedSpaceTable;	// 00
	t_udf_short_ad	UnallocatedSpaceBitmap;	// 08
	t_udf_short_ad	PartitionIntegrityTable;	// 16
	t_udf_short_ad	FreedSpaceTable;	// 24
	t_udf_short_ad	FreedSpaceBitmap;	// 32
	byte	Reserved[88];	// 40
} t_udf_PartitionHeaderDescriptor;	// 128

typedef struct
{ /* ECMA 167 3/10.5  */
	t_udf_tag	DescriptorTag;	// 00
	Uint32	VolumeDescriptorSequenceNumber;	// 16
	Uint16	PartitionFlags;	// 20
	Uint16	PartitionNumber;	// 22
	t_udf_EntityID	PartitionContents;	// 24
	t_udf_PartitionHeaderDescriptor	PartitionHeaderDescriptor;	// 56
	Uint32	AccessType;	// 184, 0 unspecified, 1 read only, 2 write once, 3 rewriteable, 4 overwriteable
	Uint32	PartitionStartingLocation;	// 188
	Uint32	PartitionLength;	// 192
	t_udf_EntityID	ImplementationIdentifier;	// 196
	Uint8	ImplementationUse[128];	// 228
	Uint8	Reserved[156];	// 356
} t_udf_PartitionDescriptor, *tp_udf_PartitionDescriptor;	// 512

typedef struct
{ /* ECMA 167 4/14.1 */
	t_udf_tag	DescriptorTag;	// 00
	t_udf_timestamp	RecordingDateandTime;	// 16
	Uint16	InterchangeLevel;	// 28
	Uint16	MaximumInterchangeLevel;	// 30
	Uint32	CharacterSetList;	// 32
	Uint32	MaximumCharacterSetList;	// 36
	Uint32	FileSetNumber;	// 40
	Uint32	FileSetDescriptorNumber;	// 44
	t_udf_charspec	LogicalVolumeIdentifierCharacterSet;	// 48
	dstring	LogicalVolumeIdentifier[128];	// 112
	t_udf_charspec	FileSetCharacterSet;	// 240
	dstring	FileSetIdentifer[32];	// 304
	dstring	CopyrightFileIdentifier[32];	// 336
	dstring	AbstractFileIdentifier[32];	// 368
	t_udf_long_ad	RootDirectoryICB;	// 400
	t_udf_EntityID	DomainIdentifier;	// 416
	t_udf_long_ad	NextExtent;	// 448
	t_udf_long_ad	StreamDirectoryICB;	// 464
	byte	Reserved[32];	// 480
} t_udf_FileSetDescriptor, *tp_udf_FileSetDescriptor;	// 512

typedef struct
{ /* ECMA 167 4/14.6 */
	Uint32	PriorRecordedNumberofDirectEntries;	// 00
	Uint16	StrategyType;	// 04
	byte	StrategyParameter[2];	// 06
	Uint16	NumberofEntries;	// 08
	byte	Reserved;	// 10
	Uint8	FileType;	// 11
	t_udf_lb_addr	ParentICBLocation;	// 12
	Uint16	Flags;	// 18
} t_udf_icbtag;	// 20

typedef struct
{ /* ECMA 167 4/14.9 */
	t_udf_tag	DescriptorTag;	// 00
	t_udf_icbtag	ICBTag;	// 16
	Uint32	Uid;	// 36
	Uint32	Gid;	// 40
	Uint32	Permissions;	// 44
	Uint16	FileLinkCount;	// 48
	Uint8	RecordFormat;	// 50
	Uint8	RecordDisplayAttributes;	// 51
	Uint32	RecordLength;	// 52
	Uint64	InformationLength;	// 56
	Uint64	LogicalBlocksRecorded;	// 64
	t_udf_timestamp	AccessTime;	// 72
	t_udf_timestamp	ModificationTime;	// 84
	t_udf_timestamp	AttributeTime;	// 96
	Uint32	Checkpoint;	// 108
	t_udf_long_ad	ExtendedAttributeICB;	// 112
	t_udf_EntityID	ImplementationIdentifier;	// 128
	Uint64	UniqueID;	// 160
	Uint32	LengthofExtendedAttributes;	// 168
	Uint32	LengthofAllocationDescriptors;	// 172
	byte	ExtendedAttributes[];	// 176
	//	byte	AllocationDescriptors[];	// 176
} t_udf_FileEntry, *tp_udf_FileEntry;	// >= 176

typedef struct
{ /* ECMA 167 4/14.4 */
	t_udf_tag	DescriptorTag;	// 00
	Uint16	FileVersionNumber;	// 16
	Uint8	FileCharacteristics;	// 18
	Uint8	LengthofFileIdentifier;	// 19
	t_udf_long_ad	ICB;	// 20
	Uint16	LengthofImplementationUse;	// 36
	byte	ImplementationUse[];	// 38
	//	char FileIdentifier[];	// 38
	//	byte Padding[];	// 38
} t_udf_FileIdentifierDescriptor, *tp_udf_FileIdentifierDescriptor; // >= 38

#define udf_MAX_NAMELEN 256
#define udf_MAX_PATHLEN 2048

typedef struct
{
	// public
	char	name[udf_MAX_NAMELEN];
	bool	is_dir, is_parent;
	// internal
	dword	length_mask;	// 0x3FFFFFFF (or 0x7FFFFFFF for illegally mastered)
	byte	*sector;
	tp_udf_FileIdentifierDescriptor	fid;
	dword	partition_lba;
	dword	dir_lba, dir_end_lba;
	dword	sec_size;
	int	dir_left;
} t_udf_file, *tp_udf_file;

#ifdef _WIN32
#pragma pack(pop)
#endif

VSTRIP_DLL_API tp_udf_file VSTRIP_DLL_CC udf_find_file(const dword address, const word partition, const bool support_1gb, const char *name);
VSTRIP_DLL_API tp_udf_file VSTRIP_DLL_CC udf_get_root(const dword address, const word partition_number, const bool support_1gb);
VSTRIP_DLL_API tp_udf_file VSTRIP_DLL_CC udf_get_next(const dword address, tp_udf_file f); // advances f
VSTRIP_DLL_API tp_udf_file VSTRIP_DLL_CC udf_get_sub(const dword address, tp_udf_file f); // creates new f
VSTRIP_DLL_API bool VSTRIP_DLL_CC udf_get_lba(const dword address, const tp_udf_file f, dword *start_lba, dword *end_lba);
VSTRIP_DLL_API void VSTRIP_DLL_CC udf_free(tp_udf_file f);

#endif // aspi_USE_ASPI

#endif
