#ifndef _DVD2AVI_PLUGIN_H_INCLUDED

#define _DVD2AVI_PLUGIN_H_INCLUDED

#include "s_types.h"
#include "file_io.h"

typedef struct
{
	int	type;
	int	trf;
	int lba;
	int	file_idx;
} t_dvd2avi_frame;

typedef struct
{
	int		num;
	int		lba;
	int		file_idx;
	byte	flags[];
} t_dvd2avi_gop;

typedef struct
{
	dword	last_lba, last_idx;
	int		width, height, framerate;
	int		picture_structure, second_field, top_field_first, repeat_first_field;
	int		frame_number;
	t_dvd2avi_frame current, forward, backward;
	t_dvd2avi_gop** gops;
	int		max_inter;
	int		max_iframes;
	int		num_iframes;
	int		buffer_start, buffer_len, buffer_file_idx, buffer_lba;
	bool	found_iframe, skipped_bframe;
	byte	buffer[fio_SECTOR_SIZE * 2];
} t_dvd2avi;

bool dvd2avi_process(byte *data, tp_vs_streaminfo const si, void *user_data);
t_dvd2avi* dvd2avi_init(void);
void dvd2avi_write_free(const char* fname, t_dvd2avi* d2v);

#endif
