/*************************************************************************
  vStrip by [maven] (maven@maven.de)
	auth.c: routines for authentification
*************************************************************************/

#include "auth.h"

// mmc3r10.pdf 
// check for dvd-rom using profile set DVD-ROM (page 110)
// page 67 (authentication process)

#define ASPI_REPORT_KEY 0xA2
#define ASPI_SEND_KEY 0xA3
#define ASPI_READ_DVD_STRUCTURE 0xAD // w/ format code 0x02 

typedef struct
{
	word	Length;
	byte	Reserved[2];
} READ_DVD_STRUCTURE; // READ_DVD_STRUCTURE

typedef struct
{
	byte	CopyrightProtectionSystemType; // 0x00 = no info, 0x01 CSS/CPPM, 0x02 CPRM
	byte	RegionManagementInformation; // Bits for each Region (bit set == cannot play)
	byte	Reserved[2];
} DVD_COPYRIGHT_INFORMATION_OUT; // READ_DVD_STRUCTURE format 0x01

typedef struct
{
	byte	DiscKeys[2048]; // obfuscated w/ Bus Key
} DVD_DISC_KEY; // READ_DVD_STRUCTURE format 0x02

typedef struct
{
	byte	Opcode;	// 0xA4
	byte	Reserved;
	dword	LBA;	// or reserved
	byte	Reserved2;
	byte	KeyClass;	// 00 CSS/CPPM or CPRM
	word	AllocationLength; // maximum length of response data (in byte)
	byte	AGID	: 2; // or reserved when KeyFormat == 0x00, 0x05 or 0x11
	//	000000b:	request AGID (CSS/CPPM)
	//	000001b:	ChallengeKey (AGID req)
	//	000010b:	Key1 (AGID req)
	//	000100b:	TitleKey (obfuscated by Bus Key, AGID req)
	//	000101b:	ASF (Authentication Success Flag) for CSS/CPPM
	//	001000b:	RPC State
	//	010001b:	request AGID (CPRM)
	//	111111b:	Invalidate AGID (AGID req)
	byte	KeyFormat	: 6;
	byte	Control;
} REPORT_KEY; // p344

// use feature 0x0000 to get list of profiles and check for dvd

typedef struct
{
	word	ProfileNumber;
	byte	Reserved	: 7;
	byte	Current	: 1;
	byte	Reserved2;
} PROFILE_DESCRIPTOR;

typedef struct
{
	word	FeatureCode;	// 0x0000 for profile list
	byte	Reserved	: 2;
	byte	Version	: 4;
	byte	Persistent	: 1;
	byte	Current	: 1;
	byte	AdditionalLength;	// NumProfileDescriptors * 4
	PROFILE_DESCRIPTOR	ProfileDescriptors[];
} PROFILE_LIST_DESCRIPTOR;

typedef struct
{
	byte	Opcode;	// 0x47
	byte	Reserved	: 6;
	byte	RT	: 2; // 01b -> return ONE feature header
	word	StartingFeatureNumber; // 0x0000 -> profile list
	byte	Reserved2[3];
	word	AllocationLength;
	byte	Control;
} feature_set_dunno_name;

// ask for AGID
// invalidate if failed
// repeat x times

// got AGID