#ifndef _ASPI_H_INCLUDED

/*************************************************************************
vStrip by [maven] (maven@maven.de)
*************************************************************************/

#define _ASPI_H_INCLUDED

#ifndef __UNIX__
#define aspi_USE_ASPI
#endif

#ifdef aspi_USE_ASPI

#include <windows.h>
#include "aspi/wnaspi32.h"
#include "aspi/scsidefs.h"
#include "s_types.h"

#define aspi_DLL_NAME "WNASPI32.DLL"

typedef struct _SCSI_ADDRESS
{
	unsigned long	Length;
	unsigned char	PortNumber;
	unsigned char	PathId;
	unsigned char	TargetId;
	unsigned char	Lun;
} SCSI_ADDRESS, *PSCSI_ADDRESS;

#define CTL_CODE(DeviceType,Function,Method,Access) (((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method))

#define FILE_ANY_ACCESS 0
#define METHOD_BUFFERED 0
#define FILE_DEVICE_CONTROLLER 0x00000004
#define IOCTL_SCSI_BASE FILE_DEVICE_CONTROLLER
#define IOCTL_SCSI_GET_ADDRESS CTL_CODE(IOCTL_SCSI_BASE, 0x0406, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define aspi_GetHost(a) (((a) >> 16) & 0xff)
#define aspi_GetTarget(a) (((a) >> 8) & 0xff)
#define aspi_GetLun(a) ((a) & 0xff)

#define aspi_MOVESCSIDWORD(pdwSrc,pdwDst) \
{\
    ((byte *)(pdwDst))[0] = ((byte *)(pdwSrc))[3];\
    ((byte *)(pdwDst))[1] = ((byte *)(pdwSrc))[2];\
    ((byte *)(pdwDst))[2] = ((byte *)(pdwSrc))[1];\
    ((byte *)(pdwDst))[3] = ((byte *)(pdwSrc))[0];\
}

#define aspi_MOVESCSIWORD(pwSrc,pwDst) \
{\
    ((byte *)(pwDst))[0] = ((byte *)(pwSrc))[1];\
    ((byte *)(pwDst))[1] = ((byte *)(pwSrc))[0];\
}

typedef struct
{
	// public
	dword	max_lba;
	// private
	SRB_ExecSCSICmd	cmd;
	dword	last_read_lba, last_read_num_lba, last_read_address;
	HANDLE	handle;
	byte	buffer[65536];	// big enough for biggest num_lba * sec_size
} t_aspi_async, *tp_aspi_async;

DWORD aspi_GetSupportInfo(void);
DWORD aspi_SendCommand(LPSRB srb);
DWORD aspi_SendCommandAsync(LPSRB srb, HANDLE* handle);
DWORD aspi_WaitCommandAsync(LPSRB srb, HANDLE handle);
dword aspi_ReadSectors(const dword address, const dword lba, const dword num_lba, const dword sec_size, byte *buf, tp_aspi_async asr);
VSTRIP_DLL_API bool VSTRIP_DLL_CC aspi_GetSectorInfo(const dword address, dword *secSize, dword *maxSec);
VSTRIP_DLL_API bool VSTRIP_DLL_CC aspi_Init(void);
VSTRIP_DLL_API void VSTRIP_DLL_CC aspi_Done(void);
VSTRIP_DLL_API bool VSTRIP_DLL_CC aspi_GetDriveAddress(char drive_letter, dword *address);
VSTRIP_DLL_API bool VSTRIP_DLL_CC aspi_SetTimeout(const dword address, const dword seconds);

#endif

#endif
