//-----------------------------------------------------------------------------
// World
//-----------------------------------------------------------------------------

#ifndef __WORLD_H__
#define __WORLD_H__

#include "cake.h"
#include "shader.h"
#include "client.h"
#include "q3bsp.h"
#include "vars.h"

extern Var sv_gravity;

/**
 * World class
 * @todo Use a stack of frustums and cameras.
 */
class World
{
  public:
    World(void);
    ~World(void);

    /**
     * Adds a map to the world.
     * The function creates a new Q3BSP object and load the map in it.
     * @param name the name of the map
     * @return an integer value that is 1 if map was loaded correctly, 0 if not
     * @todo Check memory leak in the case of unexistent maps
     */
    int AddMap(const char *name);

    /**
     * Get a pointer on Q3 BSP structure.
     * @return A pointer on q3 bsp or null pointer if bsp does not exist.
     */
    Q3BSP* GetBSP(void);

    /**
     * Initialize the world.
     * Initialize the bsp and the shaders. This must be called
     * before trying to render the world.
     */
    void Init(void);

    /**
     * Shuts the world.
     * Destroys the BSP and reset shaders.
     */
    void Shut(void);

    /**
     * Renders the world.
     * @param clients A pointer to the clients array
     * @param numclients The number of clients
     */
    void Render(Client *clients, int numclients);

    /**
     * Set a client to a specific start position.
     * @param c the destination client
     * @param n the indice of start pos
     */
    void SetStartPos(Client *c, int n = 0);

    /**
     * Get the number of start positions in the map.
     * The function returns the number of start position that were found
     * in the map entity.
     * @return the number of start pos.
     */
    int GetNumStartPos(void);

  public:

    char mapname[32];       /**< current map name */

    ShaderManager shaders;

    float gravity;          /**< world gravity */
    float maxvspeed;        /**< world maximum falling speed */

  private:
    Q3BSP *   bsp;
};

#endif  /* __WORLD_H__ */
