#ifndef __SOUND_H__
#define __SOUND_H__

#include "types.h"

/**
 * Following definition allow to enable/disable sound support.
 * This is mainly used for debug.
 */
#define ENABLE_SOUND 1

bool initSoundSystem(void);
void shutdownSoundSystem(void);

void setBGMusic(const char *filename, bool start_paused = false);
void toggleBGMusicPause(void);
void freeBGMusic(int num = -1);
void updateBGMusic(void);

void playSound(int num, float x, float y, float z, bool stop_if_playing = true);
void playSound(int num, vec3_t location = NULL, bool stop_if_playing = true);
int loadSound(const char *filename, float x, float y, float z, bool loop = false,  bool start_playing = false, bool start_paused = true);
int loadSound(const char *filename, vec3_t location = NULL, bool loop = false,  bool start_playing = false, bool start_paused = true);
int load3DSound(const char *filename, vec3_t location = NULL, bool loop = false, bool start_playing = false, bool start_paused = true);
void toggleSoundPause(int num = -1);
void freeSound(int num = -1); /**< Use the -1 parameter with care -> can generate troubles in the rest of engine */

void SoundUpdate(vec3_t position, vec3_t forward);

const char* GetSoundErrorString(int errnum);

#endif  /* __SOUND_H__ */
