//-----------------------------------------------------------------------------
// Layer
//-----------------------------------------------------------------------------

#ifndef __LAYER_H__
#define __LAYER_H__

#include "types.h"

/**
 * Layer manager.
 * This class is much simpler than the ShaderMng class, it only allocates layers
 * and fills them with default values.
 * In the future a best allocation scheme could be used, to maintain all the layers in 
 * blocks.
 * This class could also be used to create special layers without effort, example: 
 * usual lightmap layer, usual model layer, or the usual wall texture layer.
 */
class LayerManager
{
  public:
    LayerManager(void);
    ~LayerManager(void);

    /**
     * Allocates a layer and fills it with default values.
     * @return a pointer to the new layer
     */
    Layer *CreateLayer(void);

    /**
     * Deletes an existing layer.
     * @param layer the layer to destroy
     */
    void DeleteLayer(Layer *layer);

  private:
    // useless statistics
    int num_layers;
};

#endif  /* __LAYER_H__ */
