//////////////////////////////////////////////////////////////////////
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
//  TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//  PARTICULAR PURPOSE.
//
//  Copyright (C) 2003  Microsoft Corporation.  All rights reserved.
//
//  KeyHandler.cpp
//
//          the handler routines for key events
//
//////////////////////////////////////////////////////////////////////

#include "Globals.h"
#include "EditSession.h"
#include "TextService.h"
#include "CandidateList.h"
#include <stdio.h>
#include "ime-key.h"

//+---------------------------------------------------------------------------
//
// CKeyHandlerEditSession
//
//----------------------------------------------------------------------------

UINT FAKE_KEY=VK_F24;

class CKeyHandlerEditSession : public CEditSessionBase
{
public:
    CKeyHandlerEditSession(CTextService *pTextService, ITfContext *pContext, WPARAM wParam, LPARAM lParam) : CEditSessionBase(pTextService, pContext)
    {
        _wParam = wParam;
		_lParam = lParam;
    }

    // ITfEditSession
    STDMETHODIMP DoEditSession(TfEditCookie ec);

private:
    WPARAM _wParam;
	LPARAM _lParam;
};



class CKeyReleaseHandlerEditSession : public CEditSessionBase
{
public:
    CKeyReleaseHandlerEditSession(CTextService *pTextService, ITfContext *pContext, WPARAM wParam, LPARAM lParam) : CEditSessionBase(pTextService, pContext)
    {
        _wParam = wParam;
		_lParam = lParam;
    }

    // ITfEditSession
    STDMETHODIMP DoEditSession(TfEditCookie ec);

private:
    WPARAM _wParam;
	LPARAM _lParam;
};


//+---------------------------------------------------------------------------
//
// DoEditSession
//
//----------------------------------------------------------------------------
#if 0
HWND get_hwnd(CTextService *_pTextService)
{
	HWND hwnd=NULL;
	ITfContextView *view;

	if (_pTextService->_pTextEditSinkContext->GetActiveView(&view)==S_OK && view->GetWnd(&hwnd)==S_OK)
		return hwnd;

	return NULL;
}
#endif

int utf8_to_16(char *text, wchar_t *wtext, int wlen);


void CTextService::set_composition_text(TfEditCookie ec, ITfContext *pContext, char *s)
{
	wchar_t utf16[1024];
	int len = utf8_to_16(s, utf16, sizeof(utf16));
//	dbg("comp '%s' len:%d\n", s, len);
#if 1
    ITfRange *pRangeComposition;

   // get the composition range
    if (_pComposition->GetRange(&pRangeComposition) != S_OK)
        return;

	if (pRangeComposition->SetText(ec, 0, utf16, len) != S_OK)
		return;

    pRangeComposition->Release();
#else
    BOOL fCovered;
    ITfRange *pRange;
    TF_SELECTION tfSelection;

    ULONG cFetched;
	if (pContext->GetSelection(ec, TF_DEFAULT_SELECTION, 1, &tfSelection, &cFetched) != S_OK || cFetched != 1)
        return;

    if (tfSelection.range->SetText(ec, 0, utf16, len) != S_OK)
        goto Exit;

	tfSelection.range->Collapse(ec, TF_ANCHOR_END);
	pContext->SetSelection(ec, 1, &tfSelection);
Exit:
    tfSelection.range->Release();
#endif
}

void CTextService::set_cursor_position(TfEditCookie ec, ITfContext *pContext, int x)
{
    ITfRange *pRangeComposition;
//	dbg("set_cursor_position a\n");

   // get the composition range
    if (!_pComposition || _pComposition->GetRange(&pRangeComposition) != S_OK)
        return;

//	dbg("set_cursor_position b\n");

    TF_SELECTION tfSelection;
    ULONG cFetched;

    // first, test where a keystroke would go in the document if an insert is done
    if (pContext->GetSelection(ec, TF_DEFAULT_SELECTION, 1, &tfSelection, &cFetched) != S_OK || cFetched != 1)
        goto Exit;

//	dbg("set_cursor_position c\n");

	tfSelection.range->ShiftStartToRange(ec, pRangeComposition, TF_ANCHOR_START);

	LONG cch;
	tfSelection.range->ShiftStart(ec, x, &cch, NULL);
	tfSelection.range->Collapse(ec, TF_ANCHOR_START);
	pContext->SetSelection(ec, 1, &tfSelection);

    tfSelection.range->Release();

//	dbg("set_cursor_position finish\n");
Exit:
	pRangeComposition->Release();
}


void CTextService::move_cursor_end(TfEditCookie ec, ITfContext *pContext)
{
    ITfRange *pRangeComposition;

//	dbg("set_cursor_position a\n");

   // get the composition range
    if (!_pComposition || _pComposition->GetRange(&pRangeComposition) != S_OK)
        return;

//	dbg("set_cursor_position b\n");

    TF_SELECTION tfSelection;
    ULONG cFetched;

    // first, test where a keystroke would go in the document if an insert is done
    if (pContext->GetSelection(ec, TF_DEFAULT_SELECTION, 1, &tfSelection, &cFetched) != S_OK || cFetched != 1)
        goto Exit;

//	dbg("set_cursor_position c\n");

	tfSelection.range->ShiftEndToRange(ec, pRangeComposition, TF_ANCHOR_END);
//	tfSelection.range->Collapse(ec, TF_ANCHOR_START);

	tfSelection.range->Collapse(ec, TF_ANCHOR_END);
	pContext->SetSelection(ec, 1, &tfSelection);

    tfSelection.range->Release();

//	dbg("set_cursor_position finish\n");
Exit:
	pRangeComposition->Release();
}


void CTextService::send_text(TfEditCookie ec, ITfContext *pContext, char *pchText)
{
    ITfRange *pRange;
    TF_SELECTION tfSelection;

	wchar_t utf16[1024];
	int len = utf8_to_16(pchText, utf16, sizeof(utf16));

    ITfInsertAtSelection *pInsertAtSelection;
//	dbg("send_text %s\n", pchText);

    // A special interface is required to insert text at the selection
    if (pContext->QueryInterface(IID_ITfInsertAtSelection, (void **)&pInsertAtSelection) != S_OK)
        return;

    // insert the text
    if (pInsertAtSelection->InsertTextAtSelection(ec, 0, utf16, len, &pRange) != S_OK)
        goto Exit;

    // update the selection, we'll make it an insertion point just past
    // the inserted text.
    pRange->Collapse(ec, TF_ANCHOR_END);

    tfSelection.range = pRange;
    tfSelection.style.ase = TF_AE_NONE;
    tfSelection.style.fInterimChar = FALSE;

    pContext->SetSelection(ec, 1, &tfSelection);
    pRange->Release();

Exit:
    pInsertAtSelection->Release();
}


void CTextService::move_gcin_win(TfEditCookie ec, ITfContext *pContext, bool use_selection)
{
    ITfRange *pRange;
	ITfContextView *view;

//	dbg("----------------- move_gcin_win %d \n", use_selection);

	if (_pTextEditSinkContext->GetActiveView(&view)!=S_OK)
		return;

    TF_SELECTION tfSelection;
    ULONG cFetched;

   if (use_selection) {
     if (pContext->GetSelection(ec, TF_DEFAULT_SELECTION, 1, &tfSelection, &cFetched) != S_OK || cFetched != 1)
        goto exit1;
      pRange = tfSelection.range;
   } else {
//	  dbg("move_gcin_win aaa\n");
      // get the composition range
      if (_pComposition->GetRange(&pRange) != S_OK)
		 goto exit1;
   }   

//	dbg("move_gcin_win bbb\n");

   RECT rc;
    BOOL fClipped;


	if (SUCCEEDED(view->GetTextExt(ec, pRange, &rc, &fClipped))) {
#if 1
		POINT pt;
		if (GetCaretPos(&pt)) {
			HWND hwnd = GetFocus();
			if (hwnd && ClientToScreen(hwnd, &pt) && pt.x > rc.left)
				rc.left = pt.x;
		}
#endif
//		dbg("gcin_im_client_set_cursor_location %d,%d\n", rc.left, rc.bottom);
		gcin_im_client_set_cursor_location(handle, rc.left, rc.bottom);
	}

	pRange->Release();
	
exit1:
    view->Release();
}


STDAPI CKeyHandlerEditSession::DoEditSession(TfEditCookie ec)
{
// dbg("CKeyHandlerEditSession::DoEditSession %x\n", _wParam);
// if (_wParam==FAKE_KEY)
//	 dbg("fake key return\n");

 GCIN_client_handle *hand = _pTextService->handle;

 if (!hand) {
		hand = _pTextService->handle = gcin_im_client_open(NULL);
	    if (!hand)
			return S_FALSE;

		gcin_im_client_set_window(hand, 0);
  }

 bool o_has_comp = _pTextService->_IsComposing();
 if (o_has_comp && _wParam==FAKE_KEY) {
	_pTextService->move_gcin_win(ec, _pContext, 1);
	 return S_OK;
 }

	BYTE keystate[256];
	GetKeyboardState(keystate);

	char *rstr=NULL;
	BOOL ret = send_gcin_key(hand, _wParam, GetKeyInfo(_lParam), keystate, &rstr);

	char *gcompstr = NULL;
	GCIN_PREEDIT_ATTR gcin_att[256];
	int cursorpos=0, sub_comp_len;
	int gcin_attN = gcin_im_client_get_preedit(hand, &gcompstr, gcin_att, &cursorpos, &sub_comp_len);
#if _DEBUG
	if (rstr)
		dbg("rstr %s\n", rstr);
#endif
	bool n_has_comp = gcompstr && gcompstr[0];

#if _DEBUG
	dbg("zzzzz %d %d  cursor:%d sub_comp_len:%d\n", o_has_comp, n_has_comp,  cursorpos, sub_comp_len);
#endif

	if (_pTextService->comp_str)
	  free(_pTextService->comp_str);

	_pTextService->comp_str = gcompstr;


	dbg("aaaaaaaaaa\n");

	if (!o_has_comp && (n_has_comp || sub_comp_len)) {
//		dbg("-------------------------------------- comp start %s\n", gcompstr);
		_pTextService->_StartComposition(_pContext);
#if 1
		keybd_event(FAKE_KEY,MapVirtualKey(FAKE_KEY, 0), 0 ,0);
		keybd_event(FAKE_KEY,MapVirtualKey(FAKE_KEY, 0), KEYEVENTF_KEYUP,0);
#endif
#if 1
		if (!n_has_comp) {
			_pTextService->set_composition_text(ec, _pContext, " ");
			_pTextService->_SetCompositionDisplayAttributes(ec, _pContext, _pTextService->_gaDisplayAttributeInput);
		}						
#endif
	}

	dbg("jjjjjjjjjjjjjjj\n");

	if (n_has_comp) {
		_pTextService->set_composition_text(ec, _pContext, gcompstr);
		_pTextService->_SetCompositionDisplayAttributes(ec, _pContext, _pTextService->_gaDisplayAttributeInput);
	}

	_pTextService->set_cursor_position(ec, _pContext, cursorpos);

#if 1
	_pTextService->move_gcin_win(ec, _pContext, 1);
#endif

	if (o_has_comp && !n_has_comp && !sub_comp_len) {
		dbg("end comp\n");
		if (!rstr) // occurs when use backspace to clear the composition
			_pTextService->set_composition_text(ec, _pContext, "");
		else
			_pTextService->set_composition_text(ec, _pContext, rstr);

		_pTextService->move_cursor_end(ec, _pContext);
		_pTextService->_EndComposition(_pContext);
	}

	dbg("llllll %d\n", o_has_comp);
#if 1
	if (!o_has_comp && rstr) {
		dbg("send text %s\n", rstr);
		_pTextService->send_text(ec, _pContext, rstr);
		free(rstr);
	}
#endif

  return S_OK;
}

//+---------------------------------------------------------------------------
//
// IsRangeCovered
//
// Returns TRUE if pRangeTest is entirely contained within pRangeCover.
//
//----------------------------------------------------------------------------

BOOL IsRangeCovered(TfEditCookie ec, ITfRange *pRangeTest, ITfRange *pRangeCover)
{
    LONG lResult;

    if (pRangeCover->CompareStart(ec, pRangeTest, TF_ANCHOR_START, &lResult) != S_OK ||
        lResult > 0)
    {
        return FALSE;
    }

    if (pRangeCover->CompareEnd(ec, pRangeTest, TF_ANCHOR_END, &lResult) != S_OK ||
        lResult < 0)
    {
        return FALSE;
    }

    return TRUE;
}


//+---------------------------------------------------------------------------
//
// _InvokeKeyHandler
//
// This text service is interested in handling keystrokes to demonstrate the
// use the compositions. Some apps will cancel compositions if they receive
// keystrokes while a compositions is ongoing.
//
//----------------------------------------------------------------------------

HRESULT CTextService::_InvokeKeyHandler(ITfContext *pContext, WPARAM wParam, LPARAM lParam)
{
    CKeyHandlerEditSession *pEditSession;
    HRESULT hr = E_FAIL;

//	dbg("_InvokeKeyHandler %x\n", wParam);

    // Insert a char in place of this keystroke
    if ((pEditSession = new CKeyHandlerEditSession(this, pContext, wParam, lParam)) == NULL)
        goto Exit;

//	dbg("CTextService::_InvokeKeyHandler b\n");

    // a lock is required
    // nb: this method is one of the few places where it is legal to use
    // the TF_ES_SYNC flag
    hr = pContext->RequestEditSession(_tfClientId, pEditSession, TF_ES_SYNC | TF_ES_READWRITE, &hr);

    pEditSession->Release();

Exit:
    return hr;
}




STDAPI CKeyReleaseHandlerEditSession::DoEditSession(TfEditCookie ec)
{

 GCIN_client_handle *hand = _pTextService->handle;

 if (!hand) {
	 return S_FALSE;
 }

//  dbg("release move_gcin_win\n");

//	_pTextService->move_gcin_win(ec, _pContext, 1);

#if 1
 bool o_has_comp = _pTextService->_IsComposing();

	char *gcompstr = NULL;
	GCIN_PREEDIT_ATTR gcin_att[256];
	int cursorpos=0, sub_comp_len;
	int gcin_attN = gcin_im_client_get_preedit(hand, &gcompstr, gcin_att, &cursorpos, &sub_comp_len);

	bool n_has_comp = gcompstr && gcompstr[0];
	free(gcompstr);

//	dbg("release %d %d %d\n", o_has_comp, n_has_comp, sub_comp_len);

	if (o_has_comp && !n_has_comp && !sub_comp_len) {
		_pTextService->set_composition_text(ec, _pContext, "");
		_pTextService->_EndComposition(_pContext);
	}
#endif

  return S_OK;
}



HRESULT CTextService::_InvokeKeyReleaseHandler(ITfContext *pContext, WPARAM wParam, LPARAM lParam)
{
    CKeyReleaseHandlerEditSession *pEditSession;
    HRESULT hr = E_FAIL;

//	dbg("_InvokeKeyReleaseHandler\n");
    // Insert a char in place of this keystroke
    if ((pEditSession = new CKeyReleaseHandlerEditSession(this, pContext, wParam, lParam)) == NULL)
        goto Exit;

    // a lock is required
    // nb: this method is one of the few places where it is legal to use
    // the TF_ES_SYNC flag
    hr = pContext->RequestEditSession(_tfClientId, pEditSession, TF_ES_SYNC | TF_ES_READWRITE, &hr);

    pEditSession->Release();

Exit:
    return hr;
}