; The name of the installer
Name "gcin"

; The file to write
!ifdef nogtk
OutFile "gcin-inst-no-gtk.exe"
!else
OutFile "gcin-inst.exe"
!endif

; The default installation directory
InstallDir $PROGRAMFILES\gcin

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\gcin" "Install_Dir"

; Request application privileges for Windows Vista
RequestExecutionLevel admin

;--------------------------------

; Pages

Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------

; The stuff to install
Section "gcin (required)"

  SectionIn RO
!ifndef nogtk
!include gcin-gtk.nsh  
!endif
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR\bin
  File "..\release\sim2trad.exe"
  File "..\release\tsa2d32.exe"
  File "..\release\gtab-merge.exe"
  File "..\release\tsin2gtab-phrase.exe"
  File "..\release\juyin-learn.exe"
  File "..\release\gcin.exe"
  File "..\release\tslearn.exe"
  File "..\release\trad2sim.exe"
  File "..\release\tsd2a32.exe"
  File "..\release\gcin-setup.exe"
  File "..\release\gcin2tab.exe"
  File "\gcin-data\regex2.dll"
  File "\gcin-data\oggdec.exe"
  SetOutPath $INSTDIR\table
  File "\gcin-data\table\*"
  SetOutPath $INSTDIR\script
  File "\gcin-win32\scripts\*.bat"
  SetOutPath $INSTDIR\icons
  File "\gcin-data\icons\*.png"
  SetOutPath $INSTDIR
  File "..\release\installer.exe"
  SetOutPath $SYSDIR
  File "..\gcin-ime0\release\gcin0.ime"
  
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\gcin "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\gcin" "DisplayName" "gcin"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\gcin" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\gcin" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\gcin" "NoRepair" 1
  WriteUninstaller "uninstall.exe"

  Exec "$INSTDIR\installer.exe"
  ClearErrors
; 2005
;  ReadRegDword $R0 HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{7299052b-02a4-4627-81f2-1818da5d550d}" "Version"
; 2010
  ReadRegDword $R0 HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{196BB40D-1578-3D01-B289-BEFC77A11A1E}" "Version"
  IfErrors 0 VSRedistInstalled
  SetOutPath "$TEMP"
  File "\gcin-data\vcredist_x86_2010.exe"
  ExecWait '"$TEMP\vcredist_x86_2010.exe" /qb'
  Delete $INSTDIR\vcredist_x86_2005sp1.exe
VSRedistInstalled:
SectionEnd


; Optional section (can be disabled by the user)
Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\gcin"
  CreateShortCut "$SMPROGRAMS\gcin\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\gcin\gcin.lnk" "$INSTDIR\bin\gcin.exe" "" "$INSTDIR\bin\gcin.exe" 0
  CreateShortCut "$SMPROGRAMS\gcin\gcin-setup.lnk" "$INSTDIR\bin\gcin-setup.exe" "" "$INSTDIR\bin\gcin-setup.exe" 0
  CreateShortCut "$SMPROGRAMS\gcin\tslearn.lnk" "$INSTDIR\bin\tslearn.exe" "" "$INSTDIR\bin\tslearn.exe" 0
  CreateShortCut "$SMPROGRAMS\gcin\juyin-learn.lnk" "$INSTDIR\bin\juyin-learn.exe" "" "$INSTDIR\bin\juyin-learn.exe" 0
  CreateShortCut "$SMPROGRAMS\gcin\trad2sim.lnk" "$INSTDIR\bin\trad2sim.exe" "" "$INSTDIR\bin\trad2sim.exe" 0
  CreateShortCut "$SMPROGRAMS\gcin\sim2trad.lnk" "$INSTDIR\bin\sim2trad.exe" "" "$INSTDIR\bin\sim2trad.exe" 0
  
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\gcin"
  DeleteRegKey HKLM SOFTWARE\gcin

  ; Remove files and uninstaller
  RMDir /r $INSTDIR\bin
  RMDir /r $INSTDIR\etc
  RMDir /r $INSTDIR\icons
  RMDir /r $INSTDIR\lib
  RMDir /r $INSTDIR\table
  RMDir /r $INSTDIR\script
  RMDir /r $INSTDIR\share
  Delete $INSTDIR\uninstall.exe
  Delete $INSTDIR\installer.exe
  Delete $SYSDIR\gcin0.ime

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\gcin\*.*"

  ; Remove directories used
  RMDir "$SMPROGRAMS\gcin"
  RMDir "$INSTDIR"

SectionEnd
