﻿#include "os-dep.h"
#include <shellapi.h>
#include <stdio.h>
#include <shlobj.h>
#include "gcin.h"

char *gcin_program_files_path;
char *gcin_script_path;
bool get_reg_str(char *reg, char *out, DWORD outsz);

void init_gcin_program_files()
{
  char path[MAX_PATH];

  if (!get_reg_str("gcin_dir", path, MAX_PATH)) {
	SHGetFolderPathA(NULL, CSIDL_PROGRAM_FILES , NULL, SHGFP_TYPE_CURRENT, path);
	strcat(path,"\\gcin");
  }

  char tt[MAX_PATH];
  sprintf_s(tt, sizeof(tt), "GCIN_DIR=%s", path);
  _putenv(tt);

  gcin_program_files_path = strdup(path);
  strcat(path, "\\script");
  gcin_script_path = strdup(path);
  dbg("init_gcin_program_files script:%s\n", gcin_script_path);

  char app_gcin[MAX_PATH];
  app_gcin[0]=0;
  SHGetFolderPathA(NULL, CSIDL_APPDATA, NULL, SHGFP_TYPE_CURRENT, app_gcin);
  strcat(app_gcin, "\\gcin");
  sprintf_s(tt, sizeof(tt), "APPDATA_GCIN=%s", app_gcin);
  dbg("appdata %s\n", tt);
  _putenv(tt);

  dbg("env %s\n", getenv("APPDATA_GCIN"));
}

// doesn't wait exec to finish
void win32exec_para(char *s, char *para)
{
  char path[MAX_PATH];
  if (!gcin_program_files_path)
    init_gcin_program_files();

  sprintf_s(path, sizeof(path), "%s\\bin\\%s", gcin_program_files_path, s);

  dbg("win32exec_para %s %s\n", path, para);

  ShellExecuteA(NULL, "open", path, para, NULL, SW_SHOWNORMAL);
}


void win32exec(char *s)
{
  win32exec_para(s, NULL);
}

#if 0
DWORD win32exec_create(char *s)
{
  PROCESS_INFORMATION procinfo;
  STARTUPINFOA si;

  char path[MAX_PATH];
  if (!gcin_program_files_path)
    init_gcin_program_files();

  sprintf_s(path, sizeof(path), "\"%s\\bin\\%s\"", gcin_program_files_path, s);

  ZeroMemory( &si, sizeof(si) );
  si.cb = sizeof(si);
  ZeroMemory( &procinfo, sizeof(procinfo));

  if(!CreateProcessA(NULL, path, NULL,NULL,FALSE, CREATE_NO_WINDOW, NULL,NULL, &si, &procinfo)) {
#if _DEBUG
    dbg("cannot exec %s\n", path);
	return -1;
#endif
  }

  return procinfo.dwThreadId;
}
#endif

int win32exec_va(char *s, ...)
{
  if (!gcin_program_files_path)
	init_gcin_program_files();

  va_list marker;
  va_start(marker, s);

  char cmd[256];

  sprintf_s(cmd, sizeof(cmd), "\"%s\\bin\\%s\"", gcin_program_files_path, s);

  char *para;

  while( (para=va_arg( marker, char *))) {
	char tt[256];
	sprintf_s(tt, sizeof(tt), " \"%s\"", para);
	strcat_s(cmd, sizeof(cmd), tt);
  }

  dbg("cmd %s\n", cmd);

  PROCESS_INFORMATION procinfo;
  STARTUPINFOA si;

  ZeroMemory( &si, sizeof(si) );
  si.cb = sizeof(si);
  ZeroMemory( &procinfo, sizeof(procinfo));

#if 1
  if(!CreateProcessA(NULL, cmd, NULL,NULL,FALSE, CREATE_NO_WINDOW, NULL,NULL, &si, &procinfo)) {
#else
  if(!CreateProcessA(NULL, cmd, NULL,NULL,FALSE, 0, NULL,NULL, &si, &procinfo)) {
#endif
#if _DEBUG
    dbg("cannot exec %s\n", cmd);
	return -1;
#endif
  }

  WaitForSingleObject(procinfo.hProcess, 30000);

  return 0;
}


void win32exec_wait(char *s)
{
  win32exec_va(s, NULL);
}


int win32exec_script_va(char *s, ...)
{
  if (!gcin_program_files_path)
	init_gcin_program_files();

  va_list marker;
  va_start(marker, s);

  char cmd[256];

  sprintf_s(cmd, sizeof(cmd), "\"%s\\%s\"", gcin_script_path, s);

  char *para;

  while( (para=va_arg( marker, char *))) {
	char tt[256];
	sprintf_s(tt, sizeof(tt), " \"%s\"", para);
	strcat_s(cmd, sizeof(cmd), tt);
  }

  dbg("cmd %s\n", cmd);
  dbg("env:'%s'\n", getenv("APPDATA_GCIN"));

  PROCESS_INFORMATION procinfo;
  STARTUPINFOA si;

  ZeroMemory( &si, sizeof(si) );
  si.cb = sizeof(si);
  ZeroMemory( &procinfo, sizeof(procinfo));

#if 1
  if(!CreateProcessA(NULL, cmd, NULL,NULL,FALSE, CREATE_NO_WINDOW, NULL,NULL, &si, &procinfo)) {
#else
  if(!CreateProcessA(NULL, cmd, NULL,NULL,FALSE, 0, NULL,NULL, &si, &procinfo)) {
#endif
#if _DEBUG
    dbg("cannot exec %s\n", cmd);
	return -1;
#endif
  }

  WaitForSingleObject(procinfo.hProcess, 30000);

  return 0;
}


int win32exec_script(char *s, char *para)
{
  dbg("win32exec_script %s\n", s);
  return win32exec_script_va(s, para, NULL);
}
