#include <windows.h>
#include <stdio.h>

static char regpath[]="SOFTWARE\\gcin";

static void init_reg(HKEY &hk)
{
	 DWORD dwDisp;

	if (RegCreateKeyExA(HKEY_LOCAL_MACHINE, regpath,
			  0, NULL, REG_OPTION_NON_VOLATILE,
			KEY_ALL_ACCESS, NULL, &hk, &dwDisp) &&			
		RegCreateKeyExA(HKEY_CURRENT_USER, regpath,
			  0, NULL, REG_OPTION_NON_VOLATILE,
			KEY_ALL_ACCESS, NULL, &hk, &dwDisp))    {
			char tt[256];
			sprintf_s(tt, sizeof(tt), "Could not create the registry key %s.", regpath); 

			MessageBoxA(NULL, "Cannot get host_id", NULL, MB_ICONERROR|MB_OK|MB_SETFOREGROUND|MB_TOPMOST);
			exit(1);
	}
}

bool get_reg_str(char *reg, char *out, DWORD outsz)
{
	HKEY hk;
	init_reg(hk);

	out[0]=0;
	DWORD type;
	DWORD pcb = outsz;

	bool r = RegQueryValueExA(hk, reg, NULL, &type, (LPBYTE)out, &pcb) == ERROR_SUCCESS;
	RegCloseKey(hk);
	return r;
}

#if INSTALLER
void set_reg_str(char *reg, char *str)
{
	HKEY hk;
	init_reg(hk);

	RegSetValueExA(hk, reg,0, REG_SZ, (BYTE *)str, (DWORD)strlen((char *)str));
	RegCloseKey(hk);
}
#endif