#include "os-dep.h"
#include "ChewingIME.h"
#include "IMEUI.h"
#include "gcin-im-client.h"
#include "win32-key.h"
#include "ime-key.h"

KeySym vk2gcin_key(UINT key, char asc, const BYTE* keystate)
{
	bool shift = IsKeyDown(keystate[VK_SHIFT]);
	bool ctrl = IsKeyDown(keystate[VK_CONTROL]);

//	dbg("vk2gcin_key %x %x\n", key, asc);
	if (shift && asc)
		return asc;

	switch (key) {
		case VK_OEM_MINUS:
			return '-';
		case VK_OEM_COMMA:
			return ',';
		case VK_OEM_PERIOD:
			return '.';
		case VK_OEM_1:
			return ';';
		case VK_OEM_2:
			return '/';
		case VK_OEM_3:
			return '`';
		case VK_OEM_4:
			return '[';
		case VK_OEM_5:
			return '\\';
		case VK_OEM_6:
			return ']';
		case VK_OEM_7:
			return '\'';
		case VK_PRIOR:
		case VK_NEXT:
		case VK_END:
		case VK_HOME:
		case VK_LEFT:
		case VK_UP:
		case VK_RIGHT:
		case VK_DOWN:
		case VK_PRINT:
		case VK_INSERT:
		case VK_DELETE:
		case VK_HELP:
		case VK_NUMPAD0:
		case VK_NUMPAD1:
		case VK_NUMPAD2:
		case VK_NUMPAD3:
		case VK_NUMPAD4:
		case VK_NUMPAD5:
		case VK_NUMPAD6:
		case VK_NUMPAD7:
		case VK_NUMPAD8:
		case VK_NUMPAD9:
		case VK_MULTIPLY:
		case VK_ADD:
		case VK_SEPARATOR:
		case VK_SUBTRACT:
		case VK_DECIMAL:
		case VK_DIVIDE:
		case VK_F1:
		case VK_F2:
		case VK_F3:
		case VK_F4:
		case VK_F5:
		case VK_F6:
		case VK_F7:
		case VK_F8:
		case VK_F9:
		case VK_F10:
		case VK_F11:
		case VK_F12:
		case VK_LSHIFT:
		case VK_RSHIFT:
		case VK_LCONTROL:
		case VK_RCONTROL:
		case VK_LMENU:
		case VK_RMENU:
		case VK_LWIN:
		case VK_RWIN:
		case VK_APPS:
		case VK_SLEEP:
			return key + KOFS;
		default:
			if (asc) {
				dbg("return asc %c\n", asc);
				return asc;
			}

			if (ctrl && key>='0' && key<= '9') {
				dbg("key 0..9\n");
				return key;
			}

			dbg("unknown key %x\n", key);
			return key + KOFS;
	}
}

BOOL send_gcin_key(void *hand, UINT key, KeyInfo ki, const BYTE* keystate, char **rstr)
{
	char asc=0;

	char ascii[2];
	ascii[0]=0;
	int ret = ToAscii( key, ki.scanCode, (BYTE*)keystate, (LPWORD)ascii, 0);

	// strane win32 design, L/R is not possible to differentiate dirty solution
	static UINT last_key;
	if (key == VK_SHIFT) {
		if (ki.isKeyUp) {
			if (last_key==VK_LSHIFT || last_key==VK_RSHIFT) {
				key = last_key;
				dbg("last key %x\n", key);
			}
		} else {
			if (IsKeyDown(keystate[VK_LSHIFT]))  {
				key = VK_LSHIFT;
				dbg("L shift\n");
			} else
			if (IsKeyDown(keystate[VK_RSHIFT]) ) {
				key = VK_RSHIFT;
				dbg("R shift\n");
			}
			if (!ki.isKeyUp)
				last_key = key;
		}
	} else
		last_key = 0;

	if (key == VK_CONTROL) {
		if (IsKeyDown(keystate[VK_LCONTROL]))  {
			key = VK_LCONTROL;
			dbg("L control\n");
		} else
		if (IsKeyDown(keystate[VK_RCONTROL])) {
			key = VK_RCONTROL;
			dbg("R control\n");
		} else
			key = VK_LCONTROL;
	} else
	if (key == VK_MENU) {
		if (IsKeyDown(keystate[VK_LMENU]))  {
			key = VK_LMENU;
			dbg("L shift\n");
		} else
		if (IsKeyDown(keystate[VK_RMENU])) {
			key = VK_RMENU;
			dbg("R shift\n");
		}
	}


	KeySym k = vk2gcin_key(key, ascii[0], keystate);
	dbg("hhhhhhhhhhhhhh\n");
#if _DEBUG
	dbg(" key:%x k:%x asc:%x cap:%x shift:%x\n", key,k, asc, IsKeyToggled(keystate[VK_CAPITAL]), IsKeyDown(keystate[VK_SHIFT])); 
#endif

	int state=0;

	if (IsKeyDown(keystate[VK_CONTROL])) {
		state |= ControlMask;
		dbg("ctrl\n");
	}
	if (IsKeyDown(keystate[VK_SHIFT])) {
		state |= ShiftMask;
		dbg("shift\n");
	}
	if (IsKeyDown(keystate[VK_LMENU])) {
		state |= Mod1Mask;
		dbg("alt l\n");
	}
	if (IsKeyDown(keystate[VK_RMENU])) {
		state |= Mod5Mask;
		dbg("alt r\n");
	}

	if (IsKeyToggled(keystate[VK_CAPITAL])) {
		state |= LockMask;
		dbg("caps\n");
	}


#if TSF
	if (rstr) 
	{
#endif
		*rstr = NULL;
		if (ki.isKeyUp)
		{
			return gcin_im_client_forward_key_release((GCIN_client_handle *)hand, k, state, rstr);
		} else {
			return gcin_im_client_forward_key_press((GCIN_client_handle *)hand, k, state, rstr);		
		}
#if TSF
	} else {
		return gcin_im_client_key_eaten((GCIN_client_handle *)hand, ki.isKeyUp,  k, state);
	}
#endif
}