// ChewingIME.cpp : wq DLL ε{iJIC
//

#include "ChewingIME.h"
#include <assert.h>
#include "CompStr.h"
#include "CandList.h"
#include "IMCLock.h"

#include <winreg.h>
#include <shlobj.h>
#include <windowsx.h>

#include "CompWnd.h"
#include "CandWnd.h"
#include "StatusWnd.h"

#include "IMEUI.h"
#include <share.h>
#include <io.h>
#include "os-dep.h"
#include "gcin-im-client.h"
#include "ime-key.h"

HINSTANCE g_dllInst = NULL;
bool g_isWindowNT = false;
bool g_useUnicode = true;

// Some functions should be disabled under WinLogon for security reason
bool g_isWinLogon = false;


BOOL GenerateIMEMessage( HIMC hIMC, UINT msg, WPARAM wp, LPARAM lp )
{
	if(!hIMC)
		return FALSE;

	BOOL success = FALSE;
	INPUTCONTEXT* ic = ImmLockIMC(hIMC);
	if(!ic)
		return FALSE;

#if _DEBUG
	switch (msg) {
		case WM_IME_COMPOSITION:
			dbg("generate WM_IME_COMPOSITION\n");
			break;
		case WM_IME_STARTCOMPOSITION:
			dbg("generate WM_IME_STARTCOMPOSITION\n");
			break;
		case WM_IME_ENDCOMPOSITION:
			dbg("generate WM_IME_ENDCOMPOSITION\n");
			break;
	}
#endif

	HIMCC hbuf = ImmReSizeIMCC( ic->hMsgBuf, sizeof(TRANSMSG) * (ic->dwNumMsgBuf + 1) );
	if( hbuf )
	{
		ic->hMsgBuf = hbuf;
		TRANSMSG* pbuf = (TRANSMSG*)ImmLockIMCC( hbuf );
		if( pbuf )
		{
			pbuf[ic->dwNumMsgBuf].message = msg;
			pbuf[ic->dwNumMsgBuf].wParam = wp;
			pbuf[ic->dwNumMsgBuf].lParam = lp;
			ic->dwNumMsgBuf++;
			success = TRUE;
			ImmUnlockIMCC(hbuf);
		}
	}
	ImmUnlockIMC(hIMC);

	if( success )
		success = ImmGenerateMessage(hIMC);

	return success;
}


BOOL    APIENTRY ImeInquire(LPIMEINFO lpIMEInfo, LPTSTR lpszUIClass, LPCTSTR lpszOptions)
{
//	dbg("ImeInquire\n");
	_tcscpy( lpszUIClass, _T(g_chewingIMEClass) );

	lpIMEInfo->fdwConversionCaps = IME_CMODE_NOCONVERSION | IME_CMODE_FULLSHAPE | IME_CMODE_CHINESE;
	lpIMEInfo->fdwSentenceCaps = IME_SMODE_NONE;
	lpIMEInfo->fdwUICaps = UI_CAP_2700;
	lpIMEInfo->fdwSCSCaps = 0;
	lpIMEInfo->fdwSelectCaps = SELECT_CAP_CONVERSION;
	lpIMEInfo->fdwProperty = /*IME_PROP_IGNORE_UPKEYS|*/IME_PROP_AT_CARET|IME_PROP_KBD_CHAR_FIRST|
							 IME_PROP_CANDLIST_START_FROM_1|IME_PROP_COMPLETE_ON_UNSELECT
							 |IME_PROP_END_UNLOAD;

	if( g_useUnicode )	{
		 lpIMEInfo->fdwProperty |= IME_PROP_UNICODE;
#ifndef UNICODE
		int len = (int) strlen(g_chewingIMEClass) + 1;
		MultiByteToWideChar( CP_ACP, 0, g_chewingIMEClass, len, (LPWSTR)lpszUIClass, len );
#endif
	}

	if(g_isWindowNT && (DWORD(lpszOptions) & IME_SYSINFO_WINLOGON ))
	{
		// Some functions should be disabled under WinLogon for security reason
		g_isWinLogon = true;
	}
	return TRUE;
}



// Encoding conversion tools

string utf16_to_utf8( const WCHAR* wtext )
{
	char *text = NULL;
	int len = WideCharToMultiByte( CP_UTF8, 0, wtext,
									-1,
									NULL, 0, NULL, NULL );
	text = new char[len + 1];
	len = WideCharToMultiByte( CP_UTF8, 0, wtext,
								-1,
								text, len, NULL, NULL );
	text[len] = 0;
	string ret(text);
	delete []text;
	return ret;
}

wstring utf8_to_utf16( const char* text )
{
	WCHAR *wtext = NULL;
	int wlen = MultiByteToWideChar( CP_UTF8, 0, text, 
									-1,
									NULL, 0 );
	wtext = new WCHAR[wlen + 1];
	wlen = MultiByteToWideChar( CP_UTF8, 0, text, 
								-1,
								wtext, wlen );
	wtext[wlen] = 0;
	wstring ret(wtext);
	delete []wtext;
	return ret;
}


BOOL    APIENTRY ImeConfigure(HKL hkl, HWND hWnd, DWORD dwMode, LPVOID pRegisterWord)
{
	// This should be disabled in WinLogon for security reason.
	if( g_isWinLogon )
		return TRUE;

    win32exec("gcin-setup.exe");

	return TRUE;
}

DWORD   APIENTRY ImeConversionList(HIMC, LPCTSTR, LPCANDIDATELIST, DWORD dwBufLen, UINT uFlag)
{
	return 0;
}

BOOL    APIENTRY ImeDestroy(UINT)
{
//	dbg("ImeDestroy\n");
	return TRUE;
}

LRESULT APIENTRY ImeEscape(HIMC, UINT, LPVOID)
{
//	dbg("ImeEscape\n");
	return FALSE;
}


BOOL ProcessCandidateList( HIMC hIMC, HIMCC hCandInfo )
{
	return FALSE;
}


bool is_exe_file(char *in_exe)
{
	char exe[MAX_PATH];
	GetModuleFileName(NULL, exe, sizeof(exe));

	return strstr(exe, in_exe) != NULL;
}


BOOL APIENTRY ImeProcessKey(HIMC hIMC, UINT uVirKey, LPARAM lParam, CONST BYTE *lpbKeyState )
{
	if( !hIMC )
		return FALSE;
	if ( g_isWinLogon )
		return FALSE;

	if (is_exe_file("\\WINWORD.EXE")) {
	  if (IsKeyDown(lpbKeyState[VK_CONTROL]) && !IsKeyDown(lpbKeyState[VK_MENU]) && !IsKeyDown(lpbKeyState[VK_SHIFT]))
		return FALSE;
	}

	dbg("ImeProcessKey %x\n", uVirKey);

	INPUTCONTEXT* ic = (INPUTCONTEXT*)ImmLockIMC(hIMC);
	CompStr* cs = (CompStr*)ImmLockIMCC(ic->hCompStr);
	GCIN_client_handle *hand = cs->gcin_handle;

	if (!hand) {
		hand = cs->gcin_handle = gcin_im_client_open(NULL);
	    if (!cs->gcin_handle)
			return FALSE;
#if 1
		if (ic->hWnd)
			gcin_im_client_set_window(cs->gcin_handle, ic->hWnd);
#endif
	}

	ImmUnlockIMCC(ic->hCompStr);

	if (!hand) 
		goto stop;
#if 0
	if (!(hand->flag & FLAG_GCIN_client_handle_has_focus)) {
		ImmUnlockIMC(hIMC);
		return FALSE;
	}
#endif

	char *rstr=NULL;
	BOOL ret = send_gcin_key(hand, uVirKey, GetKeyInfo(lParam), lpbKeyState, &rstr);

	char *gcompstr = NULL;
	bool has_comp_str = false;
	GCIN_PREEDIT_ATTR gcin_att[256];
	int cursorpos, sub_comp_len;
	int gcin_attN = gcin_im_client_get_preedit(cs->gcin_handle, &gcompstr, gcin_att, &cursorpos, &sub_comp_len);
#if _DEBUG
	dbg("gcin_attN %d sub_comp_len:%d\n", gcin_attN, sub_comp_len);
#endif
	bool composition_started = !!*cs->getCompStr();

	if(gcompstr && gcompstr[0]) {
		has_comp_str = true;
		wchar_t wchibuf[256];
		utf8_to_16(gcompstr, wchibuf, sizeof(wchibuf));
		cs->setCompStr(wchibuf);
	}
	else
		cs->setCompStr( L"" );

	if (gcompstr)
		free(gcompstr);

	cs->setCursorPos(cursorpos);

	if( !ret ) {
		if (cs->comp_started && !has_comp_str && !sub_comp_len) {
			cs->comp_started = false;
			GenerateIMEMessage( hIMC, WM_IME_ENDCOMPOSITION );
		}
				
		ImmUnlockIMC(hIMC);
		return FALSE;
	}
#if _DEBUG
	pr_pos("ImeProcessKey", ic);
#endif


	if(rstr) {
#if _DEBUG
		dbg("Commit '%s'\n", rstr);
#endif
		wchar_t wcstr[256];
		utf8_to_16(rstr, wcstr, sizeof(wcstr));

		cs->setResultStr( wcstr );
		free(rstr);
	}
	else {
		dbg("empty\n");
		cs->setResultStr( L"" );
	}
	
#if 1
	{
		cs->setInvervalArray( NULL, 0 );
	}
#endif

	cs->beforeGenerateMsg();

	WORD word = *(WORD*)cs->getCompStr();
	bool has_result = !!*cs->getResultStr();

	if(!cs->comp_started && (has_comp_str||sub_comp_len))
	{
		cs->comp_started = true;
		GenerateIMEMessage( hIMC, WM_IME_STARTCOMPOSITION );
#if _DEBUG
		dbg("WM_IME_STARTCOMPOSITION\n");
#endif
		composition_started = true;
	}

	ImmUnlockIMCC(ic->hCompStr);

#if 0
	GenerateIMEMessage(hIMC, WM_IME_COMPOSITION, 0,	GCS_COMPSTR|  (has_result ? GCS_RESULTSTR:0) );
#else
    GenerateIMEMessage( hIMC, WM_IME_COMPOSITION, 
                        (composition_started ? word : 0),
                         (GCS_COMPSTR|GCS_COMPATTR | GCS_COMPREADSTR|GCS_COMPREADATTR|
                          GCS_COMPCLAUSE|GCS_COMPREADCLAUSE|
                          GCS_COMPREADATTR|  GCS_CURSORPOS|
                          (composition_started ? GCS_DELTASTART : 0 )|
                          (has_result ? (GCS_RESULTCLAUSE|GCS_RESULTSTR|GCS_RESULTREADSTR|GCS_RESULTREADCLAUSE):0 ) ) );
#endif

	CandList* candList = (CandList*)ImmLockIMCC(ic->hCandInfo);
	if( !candList )
		goto stop;

	candList->setPageStart(0);
	candList->setPageSize(10);
	candList->setTotalCount(2);
	candList->setSelection(1);
	candList->setCand(0, L"a");
	candList->setCand(1, L"b");

	ImmUnlockIMCC(ic->hCandInfo);

#if 0

	if (!cs->old_sub_comp_len && sub_comp_len)
		GenerateIMEMessage( hIMC, WM_IME_NOTIFY, IMN_OPENCANDIDATE, 1);
	
	GenerateIMEMessage( hIMC, WM_IME_NOTIFY, IMN_CHANGECANDIDATE, 1);

	if (cs->old_sub_comp_len && !sub_comp_len) {
		GenerateIMEMessage( hIMC, WM_IME_NOTIFY, IMN_CLOSECANDIDATE, 1 );
#if 0
		GenerateIMEMessage( hIMC, WM_IME_NOTIFY, IMN_OPENCANDIDATE, 1); // place the phrase selection win
		GenerateIMEMessage( hIMC, WM_IME_NOTIFY, IMN_CLOSECANDIDATE, 1 );
#endif
	}
#else
	bool open_cand = !(cs->old_sub_comp_len & 1) && (sub_comp_len & 1) || !(cs->old_sub_comp_len & 2) && (sub_comp_len & 2);

	if (open_cand) {
		GenerateIMEMessage( hIMC, WM_IME_NOTIFY, IMN_OPENCANDIDATE, 1); // place the phrase selection win
		GenerateIMEMessage( hIMC, WM_IME_NOTIFY, IMN_CLOSECANDIDATE, 1 );
	}
#endif
	

	cs->old_sub_comp_len = sub_comp_len;


//	dbg("WM_IME_COMPOSITION %s\n", has_result ? "GCS_RESULTSTR":"");

	if (!has_comp_str && !sub_comp_len && cs->comp_started) {
		cs->comp_started = false;
		GenerateIMEMessage( hIMC, WM_IME_ENDCOMPOSITION );
//		dbg("WM_IME_ENDCOMPOSITION\n");
	}

stop:
	ImmUnlockIMC(hIMC);

	return TRUE;
}

#if 0
bool is_ie;
#endif

BOOL    APIENTRY ImeSelect(HIMC hIMC, BOOL fSelect)
{
	if ( g_isWinLogon )
		return FALSE;
#if _DEBUG
	dbg("ImeSelect %d\n", fSelect);
#endif
#if 0
	if (is_exe_file("\\iexplore.exe"))
		is_ie=true;
#endif
	IMCLock imc( hIMC );
	INPUTCONTEXT* ic = imc.getIC();
	if( !ic )
		return FALSE;
#if 1
	ic->fdwInit |= INIT_COMPFORM;
#endif
	if(fSelect)
	{
		ic->fOpen = TRUE;

		ImmReSizeIMCC( imc.getIC()->hCompStr, sizeof(CompStr) );
		CompStr* cs = imc.getCompStr();
		if(!cs)
			return FALSE;
		cs = new (cs) CompStr;	// placement new
#if _DEBUG
		dbg("ImeSelect cs:%x hand:%x\n", cs, cs->gcin_handle);
#endif

#if 0
		cs->gcin_handle = gcin_im_client_open(NULL);
		if (!cs->gcin_handle)
			return TRUE;
#endif
		ImmReSizeIMCC( imc.getIC()->hCandInfo, sizeof(CandList) );

		CandList* cl = imc.getCandList();
		if(!cl)
			return FALSE;
		cl = new (cl) CandList;	// placement new

		if( !(ic->fdwInit & INIT_CONVERSION) )		// Initialize
		{
			ic->fdwConversion = IME_CMODE_CHINESE;
			ic->fdwInit |= INIT_CONVERSION;
		}
		if( !(ic->fdwInit & INIT_STATUSWNDPOS) )
		{
			RECT rc;
			IMEUI::getWorkingArea( &rc, ic->hWnd );
			ic->ptStatusWndPos.x = rc.right - (9+20*3+4) - 150;
			ic->ptStatusWndPos.y = rc.bottom - 26;
			ic->fdwInit |= INIT_STATUSWNDPOS;
		}
		if( !(ic->fdwInit & INIT_LOGFONT) )
		{
			// TODO: initialize font here
			ic->lfFont;
		}
#if 0
		if (ic->hWnd) {
			gcin_im_client_set_window(cs->gcin_handle, ic->hWnd);
		}
#endif
		// Set Chinese or English mode
		if( imc.isChinese() )	//	Chinese mode
		{
		}
		else
		{
			ic->fdwConversion &= ~IME_CMODE_CHINESE;
		}
	}
	else
	{
		CompStr* cs = imc.getCompStr();
#if _DEBUG
		dbg("gcin_im_client_close\n");
#endif
		if (cs->gcin_handle) {
			gcin_im_client_close(cs->gcin_handle);
			cs->gcin_handle = NULL;
		}

		cs->comp_started = false;
		cs->~CompStr();	// delete cs;
		CandList* cl = imc.getCandList();
		cl->~CandList();	// delete cl;
	}
	return TRUE;
}

//  Activates or deactivates an input context and notifies the IME of the newly active input context. 
//  The IME can use the notification for initialization.
BOOL    APIENTRY ImeSetActiveContext(HIMC hIMC, BOOL fFlag)
{
	if ( g_isWinLogon )
		return TRUE;

	// true : focus in, fase : focus out
	INPUTCONTEXT* ic = (INPUTCONTEXT*)ImmLockIMC(hIMC);

	if (!ic)
		return TRUE;

#if _DEBUG
	dbg("ImeSetActiveContext ic:%x %d\n",ic, fFlag);
#endif

	CompStr* cs = (CompStr*)ImmLockIMCC(ic->hCompStr);
	if (!cs)
		goto ret1;

	if (cs->gcin_handle)  {
		if( fFlag)
		{
			gcin_im_client_focus_in(cs->gcin_handle);
			if (ic->hWnd) {
				gcin_im_client_set_window(cs->gcin_handle, ic->hWnd);
			}
//			cs->comp_started = false;
		} else {
			gcin_im_client_focus_out(cs->gcin_handle);
			cs->comp_started = false;
		}
	}

	ImmUnlockIMCC(ic->hCompStr);

ret1:
	ImmUnlockIMC(hIMC);

	return TRUE;
}

UINT    APIENTRY ImeToAsciiEx(UINT uVirtKey, UINT uScaCode, CONST LPBYTE lpbKeyState, LPDWORD lpdwTransBuf, UINT fuState, HIMC)
{
	return FALSE;
}

BOOL CommitBuffer( IMCLock& imc )
{
	CompStr* cs = imc.getCompStr();
	if( !cs )
		return FALSE;
#if _DEBUG
	dbg("Enter CommitBuffer\n");
#endif
	if( *cs->getCompStr() )
	{
		if (cs->gcin_handle)
			gcin_im_client_reset(cs->gcin_handle);
#if _DEBUG
		dbg("CommitBuffer\n");
#endif

		cs->comp_started = false;
		cs->setResultStr( cs->getCompStr() );
		cs->setZuin( L"" );
		cs->setCompStr( L"" );
		cs->setCursorPos(0);
		cs->beforeGenerateMsg();

		GenerateIMEMessage( imc.getHIMC(), WM_IME_COMPOSITION, 
			0,	(GCS_RESULTSTR|GCS_COMPSTR|GCS_COMPATTR|GCS_COMPREADSTR|GCS_COMPREADATTR|GCS_CURSORPOS/*|GCS_DELTASTART */) );

		GenerateIMEMessage( imc.getHIMC(), WM_IME_ENDCOMPOSITION );
	}
	return TRUE;
}


BOOL    APIENTRY NotifyIME(HIMC hIMC, DWORD dwAction, DWORD dwIndex, DWORD dwValue )
{
	if( !hIMC )
		return FALSE;

	switch( dwAction )
	{
	case NI_OPENCANDIDATE:
		break;
	case NI_CLOSECANDIDATE:
		break;
	case NI_SELECTCANDIDATESTR:
		break;
	case NI_CHANGECANDIDATELIST:
		break;
	case NI_SETCANDIDATE_PAGESTART:
		break;
	case NI_SETCANDIDATE_PAGESIZE:
		break;
	case NI_CONTEXTUPDATED:
		{
			switch(dwValue)
			{
			case IMC_SETCANDIDATEPOS:
				break;
			case IMC_SETCOMPOSITIONFONT:
				break;
			case IMC_SETCOMPOSITIONWINDOW:
				break;
			case IMC_SETCONVERSIONMODE:
				break;
			case IMC_SETSENTENCEMODE:
				break;
			case IMC_SETOPENSTATUS :
				break;
			}
			break;
		}
	case NI_COMPOSITIONSTR:
		{
			if ( g_isWinLogon )
				return FALSE;
#if _DEBUG
			dbg("NI_COMPOSITIONSTR\n");
#endif
			IMCLock imc( hIMC );
			CompStr* cs = imc.getCompStr();
			if( !cs )
				return FALSE;
			switch( dwIndex )
			{
			case CPS_COMPLETE:
				return CommitBuffer( imc );
				break;
			case CPS_CONVERT:
				break;
			case CPS_CANCEL:
				cs->setCompStr( L"" );
				cs->setZuin( L"" );
				break;
			}
		}
		break;
	}
	return TRUE;
}

BOOL    APIENTRY ImeRegisterWord(LPCTSTR, DWORD, LPCTSTR)
{
	return 0;
}

BOOL    APIENTRY ImeUnregisterWord(LPCTSTR, DWORD, LPCTSTR)
{
	return 0;
}

UINT    APIENTRY ImeGetRegisterWordStyle(UINT nItem, LPSTYLEBUF)
{
	return 0;
}

DWORD WINAPI  ImeGetImeMenuItems(  HIMC  hIMC,  DWORD  dwFlags,  DWORD  dwType,
    LPIMEMENUITEMINFO  lpImeParentMenu, LPIMEMENUITEMINFO  lpImeMenu, DWORD  dwSize )
{
	return 0;
}

UINT    APIENTRY ImeEnumRegisterWord(REGISTERWORDENUMPROC, LPCTSTR, DWORD, LPCTSTR, LPVOID)
{
	return 0;
}

BOOL    APIENTRY ImeSetCompositionString(HIMC, DWORD dwIndex, LPCVOID lpComp, DWORD, LPCVOID lpRead, DWORD)
{
	return FALSE;
}



BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  dwReason, 
                       LPVOID lpReserved
					 )
{
	switch(dwReason)
	{
	case DLL_PROCESS_ATTACH:
		{

			DisableThreadLibraryCalls((HMODULE)hModule);
			g_dllInst = (HINSTANCE)hModule;

			OSVERSIONINFO osv = {0};
			osv.dwOSVersionInfoSize = sizeof(osv);
			GetVersionEx( &osv );
			
			g_isWindowNT = (osv.dwPlatformId == VER_PLATFORM_WIN32_NT);

			if( osv.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS )	{
				// We are under Windows 95, 98, ME
				if( osv.dwMajorVersion == 4 && osv.dwMinorVersion == 0 )	// Windows  95
					g_useUnicode = false;	// There is no unicode IME support in Windows 95
			}

			if( !IMEUI::registerUIClasses() )
				return FALSE;

//			LoadConfig();

			break;
		}

	case DLL_PROCESS_DETACH:
//		dbg("DLL_PROCESS_DETACH\n");
		IMEUI::unregisterUIClasses();
		break;
	case DLL_THREAD_ATTACH:
//		dbg("DLL_THREAD_ATTACH\n");
		break;
	case DLL_THREAD_DETACH:
//		dbg("DLL_THREAD_DETACH\n");
		break;
	}
    return TRUE;
}

