#include ".\compwnd.h"
#include "ChewingIME.h"
#include "DrawUtil.h"
#include "CandWnd.h"
#include "CompStr.h"
#include "IMCLock.h"
#include "IMEUI.h"
#include "IMEUILock.h"

CompWnd::CompWnd(void)
{
	font = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	LOGFONT lf;
	GetObject( font, sizeof(lf), &lf);
	lf.lfHeight = 16;
	font = CreateFontIndirect( &lf );
}

CompWnd::~CompWnd(void)
{
	DeleteObject( font );
}

BOOL CompWnd::registerClass(void)
{
	dbg("CompWnd::registerClass\n");

	WNDCLASSEX wc;
	wc.cbSize			= sizeof(WNDCLASSEX);
	wc.style			= CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS| CS_IME;
	wc.lpfnWndProc		= (WNDPROC)CompWnd::wndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= g_dllInst;
	wc.hCursor			= LoadCursor( NULL, IDC_ARROW );
	wc.hIcon			= NULL;
	wc.lpszMenuName		= (LPTSTR)NULL;
	wc.lpszClassName	= g_compWndClass;
	wc.hbrBackground	= NULL;
	wc.hIconSm			= NULL;
	if( !RegisterClassEx( (LPWNDCLASSEX)&wc ) )
		return FALSE;

	return TRUE;
}

LRESULT CompWnd::wndProc( HWND hwnd , UINT msg, WPARAM wp , LPARAM lp)
{
//	dbg("CompWnd::wndProc\n");
	if ( g_isWinLogon )
		return 0;
	HIMC hIMC = getIMC(hwnd);
	IMCLock imc( hIMC );
	IMEUILock lock( GetParent(hwnd) );
	IMEUI* ui = lock.getIMEUI();
	switch (msg)
	{
		case WM_PAINT:
			{
				dbg("CompWnd::wndProc WM_PAINT\n");
				PAINTSTRUCT ps;
				BeginPaint( hwnd, &ps );
				if( ui )
					ui->compWnd.onPaint( imc, ps );
				EndPaint(hwnd, &ps);
				break;
			}
		case WM_ERASEBKGND:
			return TRUE;
			break;
		case WM_LBUTTONDOWN:
			if( ui )
				ui->compWnd.onLButtonDown(wp, lp);
			break;
		case WM_MOUSEMOVE:
			if( ui )
				ui->compWnd.onMouseMove(wp, lp);
			break;
		case WM_LBUTTONUP:
			if( ui )
				ui->compWnd.onLButtonUp(wp, lp);
			break;
		case WM_MOUSEACTIVATE:
			return MA_NOACTIVATE;
		default:
			if (!IsImeMessage(msg))
				return DefWindowProc(hwnd, msg, wp, lp);
	}
	return 0;
}



void CompWnd::onPaint(IMCLock& imc, PAINTSTRUCT& ps)
{
	dbg("CompWnd::onPain\n");
#if 1

	wstring compStr = getDisplayedCompStr(imc);
	wstring zuin = getDisplayedZuin( imc );
	int cursorPos = getDisplayedCursorPos(imc);

	HFONT oldFont;
	RECT rc;


	GetClientRect( hwnd, &rc );
	HDC memdc = CreateCompatibleDC( ps.hdc );
	HBITMAP membmp = CreateCompatibleBitmap( ps.hdc, rc.right, rc.bottom );
	HGDIOBJ oldbmp = SelectObject( memdc, membmp );

	HBRUSH hBrush = (HBRUSH)NULL;
	HBRUSH hOldBrush = (HBRUSH)NULL;
	HPEN hPen = (HPEN)CreatePen(PS_SOLID, (int)(rc.bottom-rc.top)/10, RGB(0, 0, 255));
	HPEN hOldPen = (HPEN)SelectObject(memdc, hPen);

	InflateRect( &rc, -1, -1 );

	oldFont = (HFONT)SelectObject(memdc, font);
	if( !compStr.empty() )
	{
		SetTextColor( memdc, GetSysColor( COLOR_WINDOWTEXT ) );
		SetBkColor( memdc, GetSysColor( COLOR_WINDOW ) );
		ExtTextOutW( memdc, 1, 1, ETO_OPAQUE, &rc, compStr.c_str(), 
			compStr.length(), NULL);
		int cursor = indexToXPos( compStr, cursorPos );
#if 0
        if ( g_ColoredCompCursor==false )
        {
		    BitBlt( memdc, cursor, 0, 2, rc.bottom, memdc, cursor, 0, NOTSRCCOPY );
        }
        else
#endif
        {
            // #15235, block cursor
			int selend = indexToXPos( compStr, cursorPos + 1 );
		    int curWidth = selend - cursor;

			BitBlt( memdc, cursor, 0, curWidth, rc.bottom, memdc, cursor, 0, DSTINVERT );
        }

//		if( g_phraseMark )
		{
			DWORD len = 0;
			DWORD* interval = getIntervalAry( imc, len );
			if ( len>0 && interval!=NULL ){
				for( DWORD i = 0; i < len - 1; ++i )
				{
					if( interval[i+1] - interval[i] < 2 )
						continue;
					MoveToEx( memdc, indexToXPos( compStr, interval[i] ) + 3, rc.bottom-2, NULL );
					LineTo( memdc, indexToXPos( compStr, interval[i+1] ) - 3, rc.bottom-2 );
				}
			}
		}
	}

	SelectObject(memdc, hOldPen);
	DeleteObject(hPen);

	InflateRect( &rc, 1, 1 );
//	Draw3DBorder( memdc, &rc, GetSysColor(COLOR_3DFACE), 0/*GetSysColor(COLOR_3DDKSHADOW)*/);

	BitBlt( ps.hdc, ps.rcPaint.left, ps.rcPaint.top, 
		(ps.rcPaint.right-ps.rcPaint.left), 
		(ps.rcPaint.bottom-ps.rcPaint.top), 
		memdc, ps.rcPaint.left, ps.rcPaint.top, SRCCOPY);

	SelectObject( memdc, oldbmp );
	DeleteObject( membmp );
	DeleteDC( memdc );

	SelectObject(memdc, oldFont);
#endif
}

void CompWnd::setFont(LOGFONT* lf)
{
#if 1
	LOGFONT lf2;

	dbg("CompWnd::setFont\n");

	memcpy( &lf2, lf, sizeof( lf2) );
	if( g_useUnicode )	{
		// Convert unicode font face to ANSI encoding
		WideCharToMultiByte( CP_ACP, 0, (LPCWSTR)lf->lfFaceName, wcslen( (LPCWSTR)lf->lfFaceName)+1, 
								lf2.lfFaceName, sizeof(lf2.lfFaceName), NULL, NULL );
	}

	if( abs(lf2.lfHeight) < 16 )
		lf2.lfHeight = 16;

	if( font )
		DeleteObject( font );

	font = CreateFontIndirect( &lf2 );
#endif
}

void CompWnd::getSize(int* w, int* h)
{
	dbg("CompWnd::getSize\n");

	HDC dc = GetDC( hwnd );
	HGDIOBJ oldfont = SelectObject( dc, font );
	SIZE size;
	wstring compStr = getDisplayedCompStr();
	GetTextExtentPointW( dc, compStr.c_str(), compStr.length(), &size );
	SelectObject( dc, oldfont );
	ReleaseDC( hwnd, dc );
	*w = size.cx + 4;
	*h = size.cy + 4;
}

int CompWnd::indexToXPos( wstring compStr, int idx)
{
	if( compStr.empty() || idx <=0 )
		return 2;
	HDC dc = GetDC( hwnd );
	HGDIOBJ oldfont = SelectObject( dc, font );
	SIZE size;
	GetTextExtentPointW( dc, compStr.c_str(), idx, &size );
	SelectObject( dc, oldfont );
	ReleaseDC( hwnd, dc );
	return size.cx + 2;
}



wstring CompWnd::getDisplayedCompStr(IMCLock& imc)
{
	CompStr* compStr = imc.getCompStr();
	if( compStr )
		return wstring( compStr->getCompStr() );
	return wstring( L"" );
}

wstring CompWnd::getDisplayedZuin( IMCLock& imc )
{
	CompStr* compStr = imc.getCompStr();
	if( compStr )
		return wstring( compStr->getZuin() );
	return wstring( L"" );
}

int CompWnd::getDisplayedCursorPos(IMCLock& imc)
{
	INPUTCONTEXT* ic = imc.getIC();
	if( !ic )
		return 0;
	CompStr* compStr = imc.getCompStr();
	if( !compStr )
		return 0;
	int cursorPos = compStr->getCursorPos();
	return cursorPos;
}

bool CompWnd::create(HWND imeUIWnd)
{
/*	RECT rc;
	IMCLock imc( getIMC(imeUIWnd) );
	if( imc.getIC() )
		IMEUI::getWorkingArea( &rc, imc.getIC()->hWnd );
	rc.left += 10;
	rc.bottom -= 50;
*/
	dbg("CompWnd::create\n");
	hwnd = CreateWindowEx(0, g_compWndClass, NULL,
					WS_POPUP|WS_CLIPCHILDREN,
					/*rc.left, rc.bottom*/ 0, 0, 0, 0, imeUIWnd, NULL, g_dllInst, NULL);
	return !!hwnd;
}

void CompWnd::getRelativeCandPos(IMCLock& imc, POINT* pt)
{
	RECT rc;
	GetWindowRect(hwnd, &rc );
	INPUTCONTEXT* ic = imc.getIC();
	if(!ic)
		return;
	wstring compstr = imc.getCompStr()->getCompStr();
	pt->x = indexToXPos( compstr, getDisplayedCursorPos());
	pt->y = (rc.bottom - rc.top);

}

void CompWnd::getCandPos(IMCLock& imc, POINT* pt)
{
	if (!hwnd) {
		dbg("no hwnd\n");
		return;
	}

	RECT rc;
	GetWindowRect(hwnd, &rc );
	INPUTCONTEXT* ic = imc.getIC();
	if(!ic)
		return;
	getRelativeCandPos(imc, pt);

//	dbg("getCandPos %d,%d %d,%d\n", pt->x, pt->y, rc.left, rc.top);
	if (ic->hWnd) {
		RECT rcap;
		GetWindowRect(ic->hWnd, &rcap);
		pt->x = pt->x + rc.left - rcap.left;
		pt->y = pt->y + rc.top - rcap.top;
	}

	dbg("getCandPos %d,%d\n", pt->x, pt->y);

	if (pt->x<3 && pt->y<3) {
		if (GetCaretPos(pt)) {
			dbg("pt %d,%d\n", pt->x, pt->y);
			pt->y+=18;
		}
	}
}

DWORD* CompWnd::getIntervalAry( IMCLock& imc, DWORD& count ) {
	CompStr* compStr = imc.getCompStr();
	count = compStr->getInternalLen();
	return compStr->getIntervalArray();
}
