#include ".\candwnd.h"
#include "IMCLock.h"
#include "ChewingIME.h"
#include "DrawUtil.h"
#include "CandList.h"
#include "imm.h"
#include "IMCLock.h"
#include "IMEUI.h"
#include "IMEUILock.h"

#include "CompWnd.h"

#include <tchar.h>
#include <windows.h>


void CandWnd::UpdateFont()
{
#if 0
    if ( font_size==g_FontSize )
        return;
    
    font_size = g_FontSize;
    if ( font!=NULL )
        DeleteObject(font);
	font = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	LOGFONT lf;
	GetObject( font, sizeof(lf), &lf);
	lf.lfHeight = font_size;
	font = CreateFontIndirect( &lf );
#endif
}

CandWnd::CandWnd()
{
    font_size = 0;
    UpdateFont();
}

CandWnd::~CandWnd(void)
{
}


BOOL CandWnd::registerClass(void)
{
	WNDCLASSEX wc;
	wc.cbSize         = sizeof(WNDCLASSEX);
	wc.style          = CS_IME;
	wc.lpfnWndProc    = (WNDPROC)CandWnd::wndProc;
	wc.cbClsExtra     = 0;
	wc.cbWndExtra     = 0;
	wc.hInstance      = g_dllInst;
	wc.hCursor        = LoadCursor( NULL, IDC_ARROW );
	wc.hIcon          = NULL;
	wc.lpszMenuName   = (LPTSTR)NULL;
	wc.lpszClassName  = g_candWndClass;
	wc.hbrBackground  = NULL;
	wc.hIconSm        = NULL;

	if( !RegisterClassEx( (LPWNDCLASSEX)&wc ) )
		return FALSE;

	return TRUE;
}

LRESULT CandWnd::wndProc( HWND hwnd , UINT msg, WPARAM wp , LPARAM lp)
{
#if 0
	HIMC hIMC = getIMC(hwnd);
	IMEUILock lock( GetParent( hwnd ) );
	IMEUI* ui = lock.getIMEUI();

	switch (msg)
	{
		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				BeginPaint( hwnd, &ps );
				if(ui)
					ui->candWnd.onPaint(hIMC, ps);
				EndPaint(hwnd, &ps);
				break;
			}
		case WM_ERASEBKGND:
			return TRUE;
			break;
		case WM_LBUTTONDOWN:
			if(ui)
				ui->candWnd.onLButtonDown(wp, lp);
			break;
		case WM_MOUSEMOVE:
			if(ui)
				ui->candWnd.onMouseMove(wp, lp);
			break;
		case WM_LBUTTONUP:
			if(ui)
				ui->candWnd.onLButtonUp(wp, lp);
			break;
		case WM_MOUSEACTIVATE:
			return MA_NOACTIVATE;
		default:
			if (!IsImeMessage(msg))
				return DefWindowProc(hwnd, msg, wp, lp);
	}
#endif
	return 0;
}

static void _DecideCandStringcolor(DWORD &CandIndex, DWORD &CandBody, BOOL bCandPage)
{
}

void CandWnd::onPaint(HIMC hIMC, PAINTSTRUCT& ps)
{
}

void CandWnd::getSize(int* w, int* h)
{
}

void CandWnd::updateSize(void)
{
	int w, h;
	getSize(&w, &h);
	SetWindowPos( hwnd, NULL, 0, 0, w, h, SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOZORDER);
}

bool CandWnd::create(HWND imeUIWnd)
{
	hwnd = CreateWindowExA(0, g_candWndClass, NULL,
					WS_POPUP|WS_CLIPCHILDREN,
					0, 0, 0, 0, imeUIWnd, NULL, g_dllInst, NULL);
	return !!hwnd;
}
