﻿Imports QuantisDemo.idQ
Imports System.Text

Public Class QuantisDemoForm
  Private deviceType As QuantisDeviceType
  Private deviceNumber As UInteger


  Private Sub QuantisDemoForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    ' Display library version
    textBoxInfo.Text = String.Concat("Using Quantis library version ", Quantis.GetLibVersion(), Environment.NewLine)

    ' Count Quantis devices
    Dim countPci As Integer = 0 'Quantis.Count(QuantisDeviceType.QUANTIS_DEVICE_PCI)
    Dim countUsb As Integer = Quantis.Count(QuantisDeviceType.QUANTIS_DEVICE_USB)
    textBoxInfo.Text += String.Concat("Found: ", Environment.NewLine)
    textBoxInfo.Text += String.Concat("   - ", countPci, " Quantis PCI/PCIe", Environment.NewLine)
    textBoxInfo.Text += String.Concat("   - ", countUsb, " Quantis USB", Environment.NewLine)
    textBoxInfo.Text += Environment.NewLine

    ' Select first available device
    ' Note that in a real application, it would be better to let the user choose the device he wants to use...
    If (countPci > 0) Then
      deviceType = QuantisDeviceType.QUANTIS_DEVICE_PCI
      deviceNumber = 0
      textBoxInfo.Text += String.Concat("Using PCI card #", deviceNumber, Environment.NewLine)
    ElseIf (countUsb > 0) Then
      deviceType = QuantisDeviceType.QUANTIS_DEVICE_USB
      deviceNumber = 0
      textBoxInfo.Text += String.Concat("Using USB device #", deviceNumber, Environment.NewLine)
    Else
      textBoxInfo.Text = "ERROR: No Quantis found!"
      groupBoxData.Enabled = False
      Return
    End If

    ' Display information about used device
    Try
      Dim myQuantis As New Quantis(deviceType, deviceNumber)
      textBoxInfo.Text += String.Concat("   core version:  ", myQuantis.GetBoardVersion().ToString("X"), Environment.NewLine)
      textBoxInfo.Text += String.Concat("   serial number: ", myQuantis.GetSerialNumber(), Environment.NewLine)
    Catch ex As QuantisException
      textBoxInfo.Text += String.Concat("ERROR while retrieving Quantis information: ", ex.Message, Environment.NewLine)
    End Try

  End Sub

  Private Sub ButtonGenerate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonGenerate.Click
    Try
      Dim myQuantis As New Quantis(deviceType, deviceNumber)

      ' Read random data
      Dim buffer As Byte() = myQuantis.Read(Convert.ToUInt32(NumericUpDown1.Value))

      ' Convert data to HEX string and display it
      Dim hex As New StringBuilder(buffer.Length * 3)
      For Each b As Byte In buffer
        hex.AppendFormat("{0:x2} ", b)
      Next

      textBoxBuffer.Text = hex.ToString().ToUpper()

    Catch ex As QuantisException
      textBoxBuffer.Text = String.Concat("Error while retrieving random data: ", ex.Message, Environment.NewLine)
    End Try
  End Sub

End Class