/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.KeyAndCertificate;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.x509.X509Certificate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Util {
    protected static Hashtable mechansimCodes_;

    public static Long mechanismCodeToString(String string) {
        Long l;
        if (string == null) {
            throw new NullPointerException("Argument \"mechansimName\" must not be null.");
        }
        if (string.startsWith("0x")) {
            l = new Long(Long.parseLong(string, 16));
        } else {
            if (mechansimCodes_ == null) {
                mechansimCodes_ = new Hashtable(160);
                mechansimCodes_.put("CKM_RSA_PKCS_KEY_PAIR_GEN", new Long(0L));
                mechansimCodes_.put("CKM_RSA_PKCS", new Long(1L));
                mechansimCodes_.put("CKM_RSA_9796", new Long(2L));
                mechansimCodes_.put("CKM_RSA_X_509", new Long(3L));
                mechansimCodes_.put("CKM_MD2_RSA_PKCS", new Long(4L));
                mechansimCodes_.put("CKM_MD5_RSA_PKCS", new Long(5L));
                mechansimCodes_.put("CKM_SHA1_RSA_PKCS", new Long(6L));
                mechansimCodes_.put("CKM_RIPEMD128_RSA_PKCS", new Long(7L));
                mechansimCodes_.put("CKM_RIPEMD160_RSA_PKCS", new Long(8L));
                mechansimCodes_.put("CKM_RSA_PKCS_OAEP", new Long(9L));
                mechansimCodes_.put("CKM_DSA_KEY_PAIR_GEN", new Long(16L));
                mechansimCodes_.put("CKM_DSA", new Long(17L));
                mechansimCodes_.put("CKM_DSA_SHA1", new Long(18L));
                mechansimCodes_.put("CKM_DH_PKCS_KEY_PAIR_GEN", new Long(32L));
                mechansimCodes_.put("CKM_DH_PKCS_DERIVE", new Long(33L));
                mechansimCodes_.put("CKM_RC2_KEY_GEN", new Long(256L));
                mechansimCodes_.put("CKM_RC2_ECB", new Long(257L));
                mechansimCodes_.put("CKM_RC2_CBC", new Long(258L));
                mechansimCodes_.put("CKM_RC2_MAC", new Long(259L));
                mechansimCodes_.put("CKM_RC2_MAC_GENERAL", new Long(260L));
                mechansimCodes_.put("CKM_RC2_CBC_PAD", new Long(261L));
                mechansimCodes_.put("CKM_RC4_KEY_GEN", new Long(272L));
                mechansimCodes_.put("CKM_RC4", new Long(273L));
                mechansimCodes_.put("CKM_DES_KEY_GEN", new Long(288L));
                mechansimCodes_.put("CKM_DES_ECB", new Long(289L));
                mechansimCodes_.put("CKM_DES_CBC", new Long(290L));
                mechansimCodes_.put("CKM_DES_MAC", new Long(291L));
                mechansimCodes_.put("CKM_DES_MAC_GENERAL", new Long(292L));
                mechansimCodes_.put("CKM_DES_CBC_PAD", new Long(293L));
                mechansimCodes_.put("CKM_DES2_KEY_GEN", new Long(304L));
                mechansimCodes_.put("CKM_DES3_KEY_GEN", new Long(305L));
                mechansimCodes_.put("CKM_DES3_ECB", new Long(306L));
                mechansimCodes_.put("CKM_DES3_CBC", new Long(307L));
                mechansimCodes_.put("CKM_DES3_MAC", new Long(308L));
                mechansimCodes_.put("CKM_DES3_MAC_GENERAL", new Long(309L));
                mechansimCodes_.put("CKM_DES3_CBC_PAD", new Long(310L));
                mechansimCodes_.put("CKM_CDMF_KEY_GEN", new Long(320L));
                mechansimCodes_.put("CKM_CDMF_ECB", new Long(321L));
                mechansimCodes_.put("CKM_CDMF_CBC", new Long(322L));
                mechansimCodes_.put("CKM_CDMF_MAC", new Long(323L));
                mechansimCodes_.put("CKM_CDMF_MAC_GENERAL", new Long(324L));
                mechansimCodes_.put("CKM_CDMF_CBC_PAD", new Long(325L));
                mechansimCodes_.put("CKM_MD2", new Long(512L));
                mechansimCodes_.put("CKM_MD2_HMAC", new Long(513L));
                mechansimCodes_.put("CKM_MD2_HMAC_GENERAL", new Long(514L));
                mechansimCodes_.put("CKM_MD5", new Long(528L));
                mechansimCodes_.put("CKM_MD5_HMAC", new Long(529L));
                mechansimCodes_.put("CKM_MD5_HMAC_GENERAL", new Long(530L));
                mechansimCodes_.put("CKM_SHA_1", new Long(544L));
                mechansimCodes_.put("CKM_SHA_1_HMAC", new Long(545L));
                mechansimCodes_.put("CKM_SHA_1_HMAC_GENERAL", new Long(546L));
                mechansimCodes_.put("CKM_RIPEMD128", new Long(560L));
                mechansimCodes_.put("CKM_RIPEMD128_HMAC", new Long(561L));
                mechansimCodes_.put("CKM_RIPEMD128_HMAC_GENERAL", new Long(562L));
                mechansimCodes_.put("CKM_RIPEMD160", new Long(576L));
                mechansimCodes_.put("CKM_RIPEMD160_HMAC", new Long(577L));
                mechansimCodes_.put("CKM_RIPEMD160_HMAC_GENERAL", new Long(578L));
                mechansimCodes_.put("CKM_CAST_KEY_GEN", new Long(768L));
                mechansimCodes_.put("CKM_CAST_ECB", new Long(769L));
                mechansimCodes_.put("CKM_CAST_CBC", new Long(770L));
                mechansimCodes_.put("CKM_CAST_MAC", new Long(771L));
                mechansimCodes_.put("CKM_CAST_MAC_GENERAL", new Long(772L));
                mechansimCodes_.put("CKM_CAST_CBC_PAD", new Long(773L));
                mechansimCodes_.put("CKM_CAST3_KEY_GEN", new Long(784L));
                mechansimCodes_.put("CKM_CAST3_ECB", new Long(785L));
                mechansimCodes_.put("CKM_CAST3_CBC", new Long(786L));
                mechansimCodes_.put("CKM_CAST3_MAC", new Long(787L));
                mechansimCodes_.put("CKM_CAST3_MAC_GENERAL", new Long(788L));
                mechansimCodes_.put("CKM_CAST3_CBC_PAD", new Long(789L));
                mechansimCodes_.put("CKM_CAST5_KEY_GEN", new Long(800L));
                mechansimCodes_.put("CKM_CAST128_KEY_GEN", new Long(800L));
                mechansimCodes_.put("CKM_CAST5_ECB", new Long(801L));
                mechansimCodes_.put("CKM_CAST128_ECB", new Long(801L));
                mechansimCodes_.put("CKM_CAST5_CBC", new Long(802L));
                mechansimCodes_.put("CKM_CAST128_CBC", new Long(802L));
                mechansimCodes_.put("CKM_CAST5_MAC", new Long(803L));
                mechansimCodes_.put("CKM_CAST128_MAC", new Long(803L));
                mechansimCodes_.put("CKM_CAST5_MAC_GENERAL", new Long(804L));
                mechansimCodes_.put("CKM_CAST128_MAC_GENERAL", new Long(804L));
                mechansimCodes_.put("CKM_CAST5_CBC_PAD", new Long(805L));
                mechansimCodes_.put("CKM_CAST128_CBC_PAD", new Long(805L));
                mechansimCodes_.put("CKM_RC5_KEY_GEN", new Long(816L));
                mechansimCodes_.put("CKM_RC5_ECB", new Long(817L));
                mechansimCodes_.put("CKM_RC5_CBC", new Long(818L));
                mechansimCodes_.put("CKM_RC5_MAC", new Long(819L));
                mechansimCodes_.put("CKM_RC5_MAC_GENERAL", new Long(820L));
                mechansimCodes_.put("CKM_RC5_CBC_PAD", new Long(821L));
                mechansimCodes_.put("CKM_IDEA_KEY_GEN", new Long(832L));
                mechansimCodes_.put("CKM_IDEA_ECB", new Long(833L));
                mechansimCodes_.put("CKM_IDEA_CBC", new Long(834L));
                mechansimCodes_.put("CKM_IDEA_MAC", new Long(835L));
                mechansimCodes_.put("CKM_IDEA_MAC_GENERAL", new Long(836L));
                mechansimCodes_.put("CKM_IDEA_CBC_PAD", new Long(837L));
                mechansimCodes_.put("CKM_GENERIC_SECRET_KEY_GEN", new Long(848L));
                mechansimCodes_.put("CKM_CONCATENATE_BASE_AND_KEY", new Long(864L));
                mechansimCodes_.put("CKM_CONCATENATE_BASE_AND_DATA", new Long(866L));
                mechansimCodes_.put("CKM_CONCATENATE_DATA_AND_BASE", new Long(867L));
                mechansimCodes_.put("CKM_XOR_BASE_AND_DATA", new Long(868L));
                mechansimCodes_.put("CKM_EXTRACT_KEY_FROM_KEY", new Long(869L));
                mechansimCodes_.put("CKM_SSL3_PRE_MASTER_KEY_GEN", new Long(880L));
                mechansimCodes_.put("CKM_SSL3_MASTER_KEY_DERIVE", new Long(881L));
                mechansimCodes_.put("CKM_SSL3_KEY_AND_MAC_DERIVE", new Long(882L));
                mechansimCodes_.put("CKM_SSL3_MD5_MAC", new Long(896L));
                mechansimCodes_.put("CKM_SSL3_SHA1_MAC", new Long(897L));
                mechansimCodes_.put("CKM_MD5_KEY_DERIVATION", new Long(912L));
                mechansimCodes_.put("CKM_MD2_KEY_DERIVATION", new Long(913L));
                mechansimCodes_.put("CKM_SHA1_KEY_DERIVATION", new Long(914L));
                mechansimCodes_.put("CKM_PBE_MD2_DES_CBC", new Long(928L));
                mechansimCodes_.put("CKM_PBE_MD5_DES_CBC", new Long(929L));
                mechansimCodes_.put("CKM_PBE_MD5_CAST_CBC", new Long(930L));
                mechansimCodes_.put("CKM_PBE_MD5_CAST3_CBC", new Long(931L));
                mechansimCodes_.put("CKM_PBE_MD5_CAST5_CBC", new Long(932L));
                mechansimCodes_.put("CKM_PBE_MD5_CAST128_CBC", new Long(932L));
                mechansimCodes_.put("CKM_PBE_SHA1_CAST5_CBC", new Long(933L));
                mechansimCodes_.put("CKM_PBE_SHA1_CAST128_CBC", new Long(933L));
                mechansimCodes_.put("CKM_PBE_SHA1_RC4_128", new Long(934L));
                mechansimCodes_.put("CKM_PBE_SHA1_RC4_40", new Long(935L));
                mechansimCodes_.put("CKM_PBE_SHA1_DES3_EDE_CBC", new Long(936L));
                mechansimCodes_.put("CKM_PBE_SHA1_DES2_EDE_CBC", new Long(937L));
                mechansimCodes_.put("CKM_PBE_SHA1_RC2_128_CBC", new Long(938L));
                mechansimCodes_.put("CKM_PBE_SHA1_RC2_40_CBC", new Long(939L));
                mechansimCodes_.put("CKM_PKCS5_PBKD2", new Long(944L));
                mechansimCodes_.put("CKM_PBA_SHA1_WITH_SHA1_HMAC", new Long(960L));
                mechansimCodes_.put("CKM_KEY_WRAP_LYNKS", new Long(1024L));
                mechansimCodes_.put("CKM_KEY_WRAP_SET_OAEP", new Long(1025L));
                mechansimCodes_.put("CKM_SKIPJACK_KEY_GEN", new Long(4096L));
                mechansimCodes_.put("CKM_SKIPJACK_ECB64", new Long(4097L));
                mechansimCodes_.put("CKM_SKIPJACK_CBC64", new Long(4098L));
                mechansimCodes_.put("CKM_SKIPJACK_OFB64", new Long(4099L));
                mechansimCodes_.put("CKM_SKIPJACK_CFB64", new Long(4100L));
                mechansimCodes_.put("CKM_SKIPJACK_CFB32", new Long(4101L));
                mechansimCodes_.put("CKM_SKIPJACK_CFB16", new Long(4102L));
                mechansimCodes_.put("CKM_SKIPJACK_CFB8", new Long(4103L));
                mechansimCodes_.put("CKM_SKIPJACK_WRAP", new Long(4104L));
                mechansimCodes_.put("CKM_SKIPJACK_PRIVATE_WRAP", new Long(4105L));
                mechansimCodes_.put("CKM_SKIPJACK_RELAYX", new Long(4106L));
                mechansimCodes_.put("CKM_KEA_KEY_PAIR_GEN", new Long(4112L));
                mechansimCodes_.put("CKM_KEA_KEY_DERIVE", new Long(4113L));
                mechansimCodes_.put("CKM_FORTEZZA_TIMESTAMP", new Long(4128L));
                mechansimCodes_.put("CKM_BATON_KEY_GEN", new Long(4144L));
                mechansimCodes_.put("CKM_BATON_ECB128", new Long(4145L));
                mechansimCodes_.put("CKM_BATON_ECB96", new Long(4146L));
                mechansimCodes_.put("CKM_BATON_CBC128", new Long(4147L));
                mechansimCodes_.put("CKM_BATON_COUNTER", new Long(4148L));
                mechansimCodes_.put("CKM_BATON_SHUFFLE", new Long(4149L));
                mechansimCodes_.put("CKM_BATON_WRAP", new Long(4150L));
                mechansimCodes_.put("CKM_ECDSA_KEY_PAIR_GEN", new Long(4160L));
                mechansimCodes_.put("CKM_ECDSA", new Long(4161L));
                mechansimCodes_.put("CKM_ECDSA_SHA1", new Long(4162L));
                mechansimCodes_.put("CKM_JUNIPER_KEY_GEN", new Long(4192L));
                mechansimCodes_.put("CKM_JUNIPER_ECB128", new Long(4193L));
                mechansimCodes_.put("CKM_JUNIPER_CBC128", new Long(4194L));
                mechansimCodes_.put("CKM_JUNIPER_COUNTER", new Long(4195L));
                mechansimCodes_.put("CKM_JUNIPER_SHUFFLE", new Long(4196L));
                mechansimCodes_.put("CKM_JUNIPER_WRAP", new Long(4197L));
                mechansimCodes_.put("CKM_FASTHASH", new Long(4208L));
                mechansimCodes_.put("CKM_VENDOR_DEFINED", new Long(Integer.MIN_VALUE));
            }
            l = (Long)mechansimCodes_.get(string);
        }
        return l;
    }

    public static Session openAuthorizedSession(Token token, boolean bl, PrintWriter printWriter, BufferedReader bufferedReader) throws TokenException, IOException {
        if (token == null) {
            throw new NullPointerException("Argument \"token\" must not be null.");
        }
        if (printWriter == null) {
            throw new NullPointerException("Argument \"output\" must not be null.");
        }
        if (bufferedReader == null) {
            throw new NullPointerException("Argument \"input\" must not be null.");
        }
        printWriter.println("################################################################################");
        printWriter.println("opening session");
        Session session = token.openSession(true, bl, null, null);
        TokenInfo tokenInfo = token.getTokenInfo();
        if (tokenInfo.isLoginRequired()) {
            if (tokenInfo.isProtectedAuthenticationPath()) {
                printWriter.print("Please enter the user-PIN at the PIN-pad of your reader.");
                printWriter.flush();
                session.login(true, null);
            } else {
                printWriter.print("Enter user-PIN and press [return key]: ");
                printWriter.flush();
                String string = bufferedReader.readLine();
                session.login(true, string.toCharArray());
            }
        }
        printWriter.println("################################################################################");
        return session;
    }

    public static KeyAndCertificate selectKeyAndCertificate(Session session, Key key, PrintWriter printWriter, BufferedReader bufferedReader) throws TokenException, IOException {
        iaik.pkcs.pkcs11.objects.Object[] objectArray;
        Object object;
        Object object2;
        PrivateKey privateKey;
        iaik.pkcs.pkcs11.objects.Object[] objectArray2;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"keyTemplate\" must not be null.");
        }
        if (printWriter == null) {
            throw new NullPointerException("Argument \"output\" must not be null.");
        }
        if (bufferedReader == null) {
            throw new NullPointerException("Argument \"input\" must not be null.");
        }
        printWriter.println("################################################################################");
        printWriter.println("searching for keys");
        Vector<iaik.pkcs.pkcs11.objects.Object> vector = new Vector<iaik.pkcs.pkcs11.objects.Object>(4);
        session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)key);
        while ((objectArray2 = session.findObjects(1)).length > 0) {
            vector.addElement(objectArray2[0]);
        }
        session.findObjectsFinal();
        Hashtable<PrivateKey, iaik.pkcs.pkcs11.objects.Object> hashtable = new Hashtable<PrivateKey, iaik.pkcs.pkcs11.objects.Object>(4);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            privateKey = (PrivateKey)enumeration.nextElement();
            object2 = privateKey.getId().getByteArrayValue();
            object = new X509PublicKeyCertificate();
            object.getId().setByteArrayValue(object2);
            session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)object);
            objectArray = session.findObjects(1);
            if (objectArray.length > 0) {
                hashtable.put(privateKey, objectArray[0]);
            }
            session.findObjectsFinal();
        }
        privateKey = null;
        object2 = null;
        if (vector.size() == 0) {
            printWriter.println("Found NO matching key that can be used.");
        } else if (vector.size() == 1) {
            privateKey = (Key)vector.elementAt(0);
            object2 = (X509PublicKeyCertificate)hashtable.get(privateKey);
            object = Util.toString((X509PublicKeyCertificate)object2);
            printWriter.println("Found just one private RSA signing key. This key will be used:");
            printWriter.println(privateKey);
            printWriter.println("--------------------------------------------------------------------------------");
            printWriter.println("The certificate for this key is:");
            printWriter.println((String)(object != null ? object : "<no certificate found>"));
        } else {
            printWriter.println("found these private RSA signing keys:");
            object = new Hashtable(vector.size());
            objectArray = vector.elements();
            while (objectArray.hasMoreElements()) {
                iaik.pkcs.pkcs11.objects.Object object3 = (iaik.pkcs.pkcs11.objects.Object)objectArray.nextElement();
                long l = object3.getObjectHandle();
                ((Hashtable)object).put(new Long(l), object3);
                object2 = (X509PublicKeyCertificate)hashtable.get(object3);
                String string = Util.toString((X509PublicKeyCertificate)object2);
                printWriter.println("________________________________________________________________________________");
                printWriter.println("RSA signature key with handle: " + l);
                printWriter.println(object3);
                printWriter.println("--------------------------------------------------------------------------------");
                printWriter.println("The certificate for this key is: ");
                printWriter.println(string != null ? string : "<no certificate found>");
                printWriter.println("________________________________________________________________________________");
            }
            boolean bl = false;
            while (!bl) {
                printWriter.print("Enter the handle of the key to use for signing or 'x' to exit: ");
                printWriter.flush();
                String string = bufferedReader.readLine();
                if (string.equalsIgnoreCase("x")) break;
                try {
                    Long l = new Long(string);
                    privateKey = (RSAPrivateKey)((Hashtable)object).get(l);
                    if (privateKey != null) {
                        object2 = (X509PublicKeyCertificate)hashtable.get(privateKey);
                        bl = true;
                        continue;
                    }
                    printWriter.println("An object with the handle \"" + string + "\" does not exist. Try again.");
                }
                catch (NumberFormatException numberFormatException) {
                    printWriter.println("The entered handle \"" + string + "\" is invalid. Try again.");
                }
            }
        }
        printWriter.println("################################################################################");
        return privateKey != null ? new KeyAndCertificate((Key)privateKey, (X509PublicKeyCertificate)object2) : null;
    }

    public static Token selectToken(Module module, PrintWriter printWriter, BufferedReader bufferedReader) throws TokenException, IOException {
        TokenInfo tokenInfo;
        if (module == null) {
            throw new NullPointerException("Argument \"pkcs11Module\" must not be null.");
        }
        if (printWriter == null) {
            throw new NullPointerException("Argument \"output\" must not be null.");
        }
        if (bufferedReader == null) {
            throw new NullPointerException("Argument \"input\" must not be null.");
        }
        printWriter.println("################################################################################");
        printWriter.println("getting list of all tokens");
        Slot[] slotArray = module.getSlotList(true);
        Token[] tokenArray = new Token[slotArray.length];
        Hashtable<Long, Token> hashtable = new Hashtable<Long, Token>(tokenArray.length);
        int n = 0;
        while (n < slotArray.length) {
            printWriter.println("________________________________________________________________________________");
            tokenArray[n] = slotArray[n].getToken();
            tokenInfo = tokenArray[n].getTokenInfo();
            long l = tokenArray[n].getTokenID();
            hashtable.put(new Long(l), tokenArray[n]);
            printWriter.println("Token ID: " + l);
            printWriter.println(tokenInfo);
            printWriter.println("________________________________________________________________________________");
            ++n;
        }
        printWriter.println("################################################################################");
        printWriter.println("################################################################################");
        tokenInfo = null;
        Long l = null;
        if (tokenArray.length == 0) {
            printWriter.println("There is no slot with a present token.");
        } else if (tokenArray.length == 1) {
            printWriter.println("Taking token with ID: " + tokenArray[0].getTokenID());
            l = new Long(tokenArray[0].getTokenID());
            tokenInfo = tokenArray[0];
        } else {
            boolean bl = false;
            while (!bl) {
                printWriter.print("Enter the ID of the token to use or 'x' to exit: ");
                printWriter.flush();
                String string = bufferedReader.readLine();
                if (string.equalsIgnoreCase("x")) break;
                try {
                    l = new Long(string);
                    tokenInfo = (Token)hashtable.get(l);
                    if (tokenInfo != null) {
                        bl = true;
                        continue;
                    }
                    printWriter.println("A token with the entered ID \"" + string + "\" does not exist. Try again.");
                }
                catch (NumberFormatException numberFormatException) {
                    printWriter.println("The entered ID \"" + string + "\" is invalid. Try again.");
                }
            }
        }
        printWriter.println("################################################################################");
        return tokenInfo;
    }

    public static String toString(X509PublicKeyCertificate x509PublicKeyCertificate) {
        String string;
        block2: {
            string = null;
            if (x509PublicKeyCertificate == null) break block2;
            try {
                X509Certificate x509Certificate = new X509Certificate(x509PublicKeyCertificate.getValue().getByteArrayValue());
                string = x509Certificate.toString(true);
            }
            catch (Exception exception) {
                string = x509PublicKeyCertificate.toString();
            }
        }
        return string;
    }
}

