/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.KeyAndCertificate;
import demo.pkcs.pkcs11.Util;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs7.DigestInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;

public class SignAndVerify {
    static BufferedReader input_;
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            SignAndVerify.printUsage();
            System.exit(1);
        }
        try {
            try {
                Session session;
                Module module;
                block27: {
                    boolean bl;
                    int n;
                    MechanismInfo mechanismInfo;
                    module = Module.getInstance((String)stringArray[0]);
                    module.initialize(null);
                    Token token = Util.selectToken(module, output_, input_);
                    if (token == null) {
                        output_.println("We have no token to proceed. Finished.");
                        output_.flush();
                        System.exit(0);
                    }
                    Mechanism[] mechanismArray = token.getMechanismList();
                    Hashtable<Mechanism, Mechanism> hashtable = new Hashtable<Mechanism, Mechanism>(mechanismArray.length);
                    int n2 = 0;
                    while (n2 < mechanismArray.length) {
                        hashtable.put(mechanismArray[n2], mechanismArray[n2]);
                        ++n2;
                    }
                    if (hashtable.contains(Mechanism.RSA_PKCS)) {
                        mechanismInfo = token.getMechanismInfo(Mechanism.RSA_PKCS);
                    } else {
                        mechanismInfo = null;
                        output_.println("The token does not support mechanism RSA_PKCS. Going to exit.");
                        System.exit(0);
                    }
                    if (mechanismInfo == null || !mechanismInfo.isSign()) {
                        output_.println("The token does not support signing with mechanism RSA_PKCS. Going to exit.");
                        System.exit(0);
                    }
                    session = Util.openAuthorizedSession(token, false, output_, input_);
                    output_.println("################################################################################");
                    output_.println("find private signature key");
                    RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
                    rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                    KeyAndCertificate keyAndCertificate = Util.selectKeyAndCertificate(session, (Key)rSAPrivateKey, output_, input_);
                    if (keyAndCertificate == null) {
                        output_.println("We have no signature key to proceed. Finished.");
                        output_.flush();
                        System.exit(0);
                    }
                    Key key = keyAndCertificate.getKey();
                    output_.println("################################################################################");
                    output_.println("################################################################################");
                    output_.println("signing data from file: " + stringArray[1]);
                    FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                    Mechanism mechanism = Mechanism.RSA_PKCS;
                    session.signInit(mechanism, key);
                    byte[] byArray = new byte[1024];
                    while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                        messageDigest.update(byArray, 0, n);
                    }
                    byte[] byArray2 = messageDigest.digest();
                    DigestInfo digestInfo = new DigestInfo(AlgorithmID.sha1, byArray2);
                    byte[] byArray3 = digestInfo.toByteArray();
                    byte[] byArray4 = session.sign(byArray3);
                    output_.println("The siganture value is: " + new BigInteger(1, byArray4).toString(16));
                    if (stringArray.length == 3) {
                        output_.println("Writing signature to file: " + stringArray[2]);
                        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                        ((OutputStream)fileOutputStream).write(byArray4);
                        fileOutputStream.flush();
                        ((OutputStream)fileOutputStream).close();
                    }
                    output_.println("################################################################################");
                    if (mechanismInfo == null || !mechanismInfo.isVerify()) {
                        output_.println("The token does not support verification with mechanism RSA_PKCS. Going to exit.");
                        System.exit(0);
                    }
                    output_.println("################################################################################");
                    output_.println("find public verification key");
                    RSAPublicKey rSAPublicKey = new RSAPublicKey();
                    rSAPublicKey.getVerify().setBooleanValue(Boolean.TRUE);
                    rSAPublicKey.getId().setByteArrayValue(key.getId().getByteArrayValue());
                    session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)rSAPublicKey);
                    iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
                    RSAPublicKey rSAPublicKey2 = null;
                    if (objectArray.length > 0) {
                        rSAPublicKey2 = (RSAPublicKey)objectArray[0];
                        output_.println("________________________________________________________________________________");
                        output_.println(rSAPublicKey2);
                        output_.println("________________________________________________________________________________");
                        bl = false;
                    } else {
                        if (keyAndCertificate.getCertificate() != null) {
                            output_.println("No matching public key found! Will verify in software.");
                        } else {
                            output_.println("No matching public key found and no certificate found! Going to exit.");
                            System.exit(0);
                        }
                        bl = true;
                    }
                    session.findObjectsFinal();
                    output_.println("################################################################################");
                    output_.println("################################################################################");
                    if (bl) {
                        output_.println("verifying signature in software");
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        byte[] byArray5 = keyAndCertificate.getCertificate().getValue().getByteArrayValue();
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray5));
                        Signature signature = Signature.getInstance("SHA1withRSA");
                        signature.initVerify(x509Certificate.getPublicKey());
                        fileInputStream = new FileInputStream(stringArray[1]);
                        while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                            signature.update(byArray, 0, n);
                        }
                        try {
                            if (signature.verify(byArray4)) {
                                output_.println("Verified the signature successfully");
                                break block27;
                            }
                            output_.println("Signature Invalid.");
                        }
                        catch (SignatureException signatureException) {
                            output_.println("Verification FAILED: " + signatureException.getMessage());
                        }
                    } else {
                        output_.println("verifying signature on token");
                        fileInputStream = new FileInputStream(stringArray[1]);
                        while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                            messageDigest.update(byArray, 0, n);
                        }
                        byArray2 = messageDigest.digest();
                        digestInfo = new DigestInfo(AlgorithmID.sha1, byArray2);
                        byArray3 = digestInfo.toByteArray();
                        Mechanism mechanism2 = Mechanism.RSA_PKCS;
                        session.verifyInit(mechanism2, (Key)rSAPublicKey2);
                        try {
                            session.verify(byArray3, byArray4);
                            output_.println("Verified the signature successfully");
                        }
                        catch (TokenException tokenException) {
                            output_.println("Verification FAILED: " + tokenException.getMessage());
                        }
                    }
                }
                output_.println("################################################################################");
                session.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_33 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_34 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: SignAndVerify <PKCS#11 module> <file to be signed> [<signature value file>]");
        output_.println(" e.g.: SignAndVerify pk2priv.dll data.dat signature.bin");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

