/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.GenericSecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.SSL3KeyMaterialOutParameters;
import iaik.pkcs.pkcs11.parameters.SSL3KeyMaterialParameters;
import iaik.pkcs.pkcs11.parameters.SSL3MasterKeyDeriveParameters;
import iaik.pkcs.pkcs11.parameters.SSL3RandomDataParameters;
import iaik.pkcs.pkcs11.parameters.VersionParameters;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;

public class SSLMechanisms {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 2) {
            SSLMechanisms.printUsage();
            System.exit(1);
        }
        try {
            SSL3KeyMaterialOutParameters sSL3KeyMaterialOutParameters;
            Object object;
            Object object2;
            SSL3RandomDataParameters sSL3RandomDataParameters;
            VersionParameters versionParameters;
            byte[] byArray;
            Object object3;
            SecureRandom secureRandom;
            VersionParameters versionParameters2;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            List<Mechanism> list = Arrays.asList(token.getMechanismList());
            Session session = token.openSession(true, true, null, null);
            if (stringArray.length == 2) {
                session.login(true, stringArray[1].toCharArray());
            }
            GenericSecretKey genericSecretKey = null;
            if (list.contains(Mechanism.SSL3_PRE_MASTER_KEY_GEN)) {
                output_.println("################################################################################");
                output_.println("Generating premaster secret");
                versionParameters2 = new VersionParameters(3, 0);
                secureRandom = (Mechanism)Mechanism.SSL3_PRE_MASTER_KEY_GEN.clone();
                secureRandom.setParameters((Parameters)versionParameters2);
                object3 = new GenericSecretKey();
                genericSecretKey = (GenericSecretKey)session.generateKey((Mechanism)secureRandom, (iaik.pkcs.pkcs11.objects.Object)object3);
                output_.println("the premaster secret is");
                output_.println(genericSecretKey.toString());
                output_.println("################################################################################");
            }
            versionParameters2 = null;
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
            if (list.contains(Mechanism.SSL3_MASTER_KEY_DERIVE) && genericSecretKey != null) {
                output_.println("################################################################################");
                output_.println("Deriving master secret");
                object3 = new byte[28];
                byArray = new byte[28];
                output_.print("generating client random... ");
                output_.flush();
                secureRandom.nextBytes((byte[])object3);
                output_.println("finished");
                output_.print("generating server random... ");
                output_.flush();
                secureRandom.nextBytes(byArray);
                output_.println("finished");
                versionParameters = new VersionParameters();
                sSL3RandomDataParameters = new SSL3RandomDataParameters(object3, byArray);
                object2 = new SSL3MasterKeyDeriveParameters(sSL3RandomDataParameters, versionParameters);
                object = (Mechanism)Mechanism.SSL3_MASTER_KEY_DERIVE.clone();
                object.setParameters((Parameters)object2);
                sSL3KeyMaterialOutParameters = new GenericSecretKey();
                versionParameters2 = (GenericSecretKey)session.deriveKey(object, (Key)genericSecretKey, (Key)sSL3KeyMaterialOutParameters);
                output_.println("the client version is");
                output_.println(object2.getVersion().toString());
                output_.println("the master secret is");
                output_.println(versionParameters2.toString());
                output_.println("################################################################################");
            }
            if (list.contains(Mechanism.SSL3_KEY_AND_MAC_DERIVE) && versionParameters2 != null) {
                output_.println("################################################################################");
                output_.println("Deriving key material");
                object3 = new byte[28];
                byArray = new byte[28];
                output_.print("generating client random... ");
                output_.flush();
                secureRandom.nextBytes((byte[])object3);
                output_.println("finished");
                output_.print("generating server random... ");
                output_.flush();
                secureRandom.nextBytes(byArray);
                output_.println("finished");
                versionParameters = new VersionParameters();
                sSL3RandomDataParameters = new SSL3RandomDataParameters(object3, byArray);
                object2 = new byte[16];
                object = new byte[16];
                sSL3KeyMaterialOutParameters = new SSL3KeyMaterialOutParameters((byte[])object2, (byte[])object);
                SSL3KeyMaterialParameters sSL3KeyMaterialParameters = new SSL3KeyMaterialParameters(80L, 128L, 128L, false, sSL3RandomDataParameters, sSL3KeyMaterialOutParameters);
                Mechanism mechanism = (Mechanism)Mechanism.SSL3_KEY_AND_MAC_DERIVE.clone();
                mechanism.setParameters((Parameters)sSL3KeyMaterialParameters);
                session.deriveKey(mechanism, (Key)versionParameters2, null);
                output_.println("the key material is");
                output_.println(sSL3KeyMaterialOutParameters.toString());
                output_.println("################################################################################");
            }
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: SSLMechanisms <PKCS#11 module> [<user-PIN>]");
        output_.println(" e.g.: SSLMechanisms cryptoki.dll");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

