/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GenericFind {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 2) {
            GenericFind.printUsage();
            System.exit(1);
        }
        try {
            try {
                iaik.pkcs.pkcs11.objects.Object object;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Slot[] slotArray = module.getSlotList(true);
                if (slotArray.length == 0) {
                    output_.println("No slot with present token found!");
                    System.exit(0);
                }
                Slot slot = slotArray[0];
                Token token = slot.getToken();
                Session session = token.openSession(true, false, null, null);
                if (stringArray.length == 2) {
                    session.login(true, stringArray[1].toCharArray());
                }
                output_.println("################################################################################");
                output_.println("Find all signature keys.");
                GenericTemplate genericTemplate = new GenericTemplate();
                BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.SIGN);
                booleanAttribute.setBooleanValue(Boolean.TRUE);
                genericTemplate.addAttribute((Attribute)booleanAttribute);
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)genericTemplate);
                iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
                Vector<iaik.pkcs.pkcs11.objects.Object> vector = null;
                if (objectArray.length > 0) {
                    vector = new Vector<iaik.pkcs.pkcs11.objects.Object>();
                    output_.println("________________________________________________________________________________");
                    output_.println(objectArray[0]);
                    vector.add(objectArray[0]);
                    while ((objectArray = session.findObjects(1)).length > 0) {
                        output_.println("________________________________________________________________________________");
                        output_.println(objectArray[0]);
                        vector.add(objectArray[0]);
                    }
                    output_.println("________________________________________________________________________________");
                } else {
                    output_.println("There is no object with a CKA_SIGN attribute set to true.");
                    output_.flush();
                    System.exit(0);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("Find corresponding certificates for private signature keys.");
                Vector<iaik.pkcs.pkcs11.objects.Object> vector2 = new Vector<iaik.pkcs.pkcs11.objects.Object>();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    object = (iaik.pkcs.pkcs11.objects.Object)iterator.next();
                    if (!(object instanceof PrivateKey)) continue;
                    vector2.add(object);
                }
                object = vector2.iterator();
                Hashtable<PrivateKey, iaik.pkcs.pkcs11.objects.Object> hashtable = new Hashtable<PrivateKey, iaik.pkcs.pkcs11.objects.Object>(vector2.size());
                while (object.hasNext()) {
                    PrivateKey privateKey = (PrivateKey)object.next();
                    byte[] byArray = privateKey.getId().getByteArrayValue();
                    X509PublicKeyCertificate x509PublicKeyCertificate = new X509PublicKeyCertificate();
                    x509PublicKeyCertificate.getId().setByteArrayValue(byArray);
                    session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)x509PublicKeyCertificate);
                    iaik.pkcs.pkcs11.objects.Object[] objectArray2 = session.findObjects(1);
                    if (objectArray2.length > 0) {
                        hashtable.put(privateKey, objectArray2[0]);
                        output_.println("________________________________________________________________________________");
                        output_.println("The certificate for this private signature key");
                        output_.println(privateKey);
                        output_.println("--------------------------------------------------------------------------------");
                        output_.println("is");
                        output_.println(objectArray2[0]);
                        output_.println("________________________________________________________________________________");
                    } else {
                        output_.println("________________________________________________________________________________");
                        output_.println("There is no certificate for this private signature key");
                        output_.println(privateKey);
                        output_.println("________________________________________________________________________________");
                    }
                    session.findObjectsFinal();
                }
                output_.println("################################################################################");
                session.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_19 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_20 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: GenericFind <PKCS#11 module> [<userPIN>]");
        output_.println(" e.g.: GenericFind pk2priv.dll password");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

