/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.security.provider.IAIK;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;

public class GenerateKeyPairDSA {
    static BufferedReader input_;
    static PrintWriter output_;
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            GenerateKeyPairDSA.printUsage();
            System.exit(1);
        }
        try {
            Security.addProvider((Provider)new IAIK());
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            Session session = Util.openAuthorizedSession(token, true, output_, input_);
            output_.println("################################################################################");
            output_.print("Generating new 1024 bit DSA parameters (in software)... ");
            output_.flush();
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA");
            algorithmParameterGenerator.init(1024);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$DSAParameterSpec != null ? class$java$security$spec$DSAParameterSpec : (class$java$security$spec$DSAParameterSpec = GenerateKeyPairDSA.class$("java.security.spec.DSAParameterSpec")));
            output_.println("Success");
            output_.println("P: " + Functions.toHexString((byte[])dSAParameterSpec.getP().toByteArray()));
            output_.println("Q: " + Functions.toHexString((byte[])dSAParameterSpec.getQ().toByteArray()));
            output_.println("G: " + Functions.toHexString((byte[])dSAParameterSpec.getG().toByteArray()));
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.print("Generating new 1024 bit DSA key-pair... ");
            output_.flush();
            HashSet<Mechanism> hashSet = new HashSet<Mechanism>(Arrays.asList(token.getMechanismList()));
            MechanismInfo mechanismInfo = hashSet.contains(Mechanism.DSA) ? token.getMechanismInfo(Mechanism.DSA) : null;
            Mechanism mechanism = Mechanism.DSA_KEY_PAIR_GEN;
            iaik.pkcs.pkcs11.objects.DSAPublicKey dSAPublicKey = new iaik.pkcs.pkcs11.objects.DSAPublicKey();
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey();
            dSAPublicKey.getPrime().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getP()));
            dSAPublicKey.getSubprime().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getQ()));
            dSAPublicKey.getBase().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getG()));
            dSAPublicKey.getToken().setBooleanValue(Boolean.TRUE);
            byte[] byArray = new byte[20];
            new Random().nextBytes(byArray);
            dSAPublicKey.getId().setByteArrayValue(byArray);
            dSAPrivateKey.getSensitive().setBooleanValue(Boolean.TRUE);
            dSAPrivateKey.getToken().setBooleanValue(Boolean.TRUE);
            dSAPrivateKey.getPrivate().setBooleanValue(Boolean.TRUE);
            dSAPrivateKey.getId().setByteArrayValue(byArray);
            if (mechanismInfo != null) {
                dSAPublicKey.getVerify().setBooleanValue(new Boolean(mechanismInfo.isVerify()));
                dSAPublicKey.getVerifyRecover().setBooleanValue(new Boolean(mechanismInfo.isVerifyRecover()));
                dSAPublicKey.getEncrypt().setBooleanValue(new Boolean(mechanismInfo.isEncrypt()));
                dSAPublicKey.getDerive().setBooleanValue(new Boolean(mechanismInfo.isDerive()));
                dSAPublicKey.getWrap().setBooleanValue(new Boolean(mechanismInfo.isWrap()));
                dSAPrivateKey.getSign().setBooleanValue(new Boolean(mechanismInfo.isSign()));
                dSAPrivateKey.getSignRecover().setBooleanValue(new Boolean(mechanismInfo.isSignRecover()));
                dSAPrivateKey.getDecrypt().setBooleanValue(new Boolean(mechanismInfo.isDecrypt()));
                dSAPrivateKey.getDerive().setBooleanValue(new Boolean(mechanismInfo.isDerive()));
                dSAPrivateKey.getUnwrap().setBooleanValue(new Boolean(mechanismInfo.isUnwrap()));
            } else {
                dSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                dSAPublicKey.getVerify().setBooleanValue(Boolean.TRUE);
            }
            dSAPublicKey.getKeyType().setPresent(false);
            dSAPublicKey.getObjectClass().setPresent(false);
            dSAPrivateKey.getKeyType().setPresent(false);
            dSAPrivateKey.getObjectClass().setPresent(false);
            KeyPair keyPair = session.generateKeyPair(mechanism, (iaik.pkcs.pkcs11.objects.Object)dSAPublicKey, (iaik.pkcs.pkcs11.objects.Object)dSAPrivateKey);
            iaik.pkcs.pkcs11.objects.DSAPublicKey dSAPublicKey2 = (iaik.pkcs.pkcs11.objects.DSAPublicKey)keyPair.getPublicKey();
            DSAPrivateKey dSAPrivateKey2 = (DSAPrivateKey)keyPair.getPrivateKey();
            output_.println("Success");
            output_.println("The public key is");
            output_.println("_______________________________________________________________________________");
            output_.println(dSAPublicKey2);
            output_.println("_______________________________________________________________________________");
            output_.println("The private key is");
            output_.println("_______________________________________________________________________________");
            output_.println(dSAPrivateKey2);
            output_.println("_______________________________________________________________________________");
            output_.println("################################################################################");
            output_.println("Writing the public key of the generated key-pair to file: " + stringArray[1]);
            iaik.pkcs.pkcs11.objects.DSAPublicKey dSAPublicKey3 = dSAPublicKey2;
            BigInteger bigInteger = new BigInteger(1, dSAPublicKey3.getPrime().getByteArrayValue());
            BigInteger bigInteger2 = new BigInteger(1, dSAPublicKey3.getSubprime().getByteArrayValue());
            BigInteger bigInteger3 = new BigInteger(1, dSAPublicKey3.getBase().getByteArrayValue());
            BigInteger bigInteger4 = new BigInteger(1, dSAPublicKey3.getValue().getByteArrayValue());
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            DSAPublicKey dSAPublicKey4 = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keyFactory.getKeySpec(dSAPublicKey4, class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = GenerateKeyPairDSA.class$("java.security.spec.X509EncodedKeySpec")));
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
            fileOutputStream.write(x509EncodedKeySpec.getEncoded());
            fileOutputStream.flush();
            fileOutputStream.close();
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("Trying to search for the public key of the generated key-pair by ID: " + Functions.toHexString((byte[])byArray));
            iaik.pkcs.pkcs11.objects.DSAPublicKey dSAPublicKey5 = new iaik.pkcs.pkcs11.objects.DSAPublicKey();
            dSAPublicKey5.getId().setByteArrayValue(byArray);
            session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)dSAPublicKey5);
            iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
            session.findObjectsFinal();
            if (objectArray.length != 1) {
                output_.println("Error: Cannot find the public key under the given ID!");
            } else {
                output_.println("Found public key!");
                output_.println("_______________________________________________________________________________");
                output_.println(objectArray[0]);
                output_.println("_______________________________________________________________________________");
            }
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: GenerateKeyPair <PKCS#11 module> <X.509 encoded public key output file>");
        output_.println(" e.g.: GenerateKeyPair pk2priv.dll publicKey.xpk");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

