/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.GenericSecretKey;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;

public class GenerateKey {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 2) {
            GenerateKey.printUsage();
            System.exit(1);
        }
        try {
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            List<Mechanism> list = Arrays.asList(token.getMechanismList());
            Session session = token.openSession(true, true, null, null);
            if (stringArray.length == 2) {
                session.login(true, stringArray[1].toCharArray());
            }
            if (list.contains(Mechanism.GENERIC_SECRET_KEY_GEN)) {
                output_.println("################################################################################");
                output_.println("Generating generic secret key");
                Mechanism mechanism = (Mechanism)Mechanism.GENERIC_SECRET_KEY_GEN.clone();
                GenericSecretKey genericSecretKey = new GenericSecretKey();
                genericSecretKey.getValueLen().setLongValue(new Long(16L));
                GenericSecretKey genericSecretKey2 = (GenericSecretKey)session.generateKey(mechanism, (iaik.pkcs.pkcs11.objects.Object)genericSecretKey);
                output_.println("the secret key is");
                output_.println(genericSecretKey2.toString());
                output_.println("################################################################################");
            }
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: GenerateKey <PKCS#11 module> [<user-PIN>]");
        output_.println(" e.g.: GenerateKey cryptoki.dll");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

