/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.parameters.InitializationVectorParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;

public class EncryptDecrypt {
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            EncryptDecrypt.printUsage();
            System.exit(1);
        }
        try {
            int n;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            Session session = token.openSession(true, false, null, null);
            session.login(true, stringArray[1].toCharArray());
            output_.println("################################################################################");
            output_.println("generate secret encryption/decryption key");
            Mechanism mechanism = Mechanism.DES3_KEY_GEN;
            DES3SecretKey dES3SecretKey = new DES3SecretKey();
            dES3SecretKey.getEncrypt().setBooleanValue(Boolean.TRUE);
            dES3SecretKey.getDecrypt().setBooleanValue(Boolean.TRUE);
            DES3SecretKey dES3SecretKey2 = (DES3SecretKey)session.generateKey(mechanism, (iaik.pkcs.pkcs11.objects.Object)dES3SecretKey);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("encrypting data from file: " + stringArray[2]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            Arrays.fill(byArray, (byte)0);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Mechanism mechanism2 = Mechanism.DES3_CBC_PAD;
            byte[] byArray3 = new byte[8];
            InitializationVectorParameters initializationVectorParameters = new InitializationVectorParameters(byArray3);
            mechanism2.setParameters((Parameters)initializationVectorParameters);
            session.encryptInit(mechanism2, (Key)dES3SecretKey2);
            byte[] byArray4 = session.encrypt(byArray2);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("trying to decrypt");
            Mechanism mechanism3 = Mechanism.DES3_CBC_PAD;
            byte[] byArray5 = new byte[8];
            InitializationVectorParameters initializationVectorParameters2 = new InitializationVectorParameters(byArray5);
            mechanism3.setParameters((Parameters)initializationVectorParameters2);
            session.decryptInit(mechanism3, (Key)dES3SecretKey2);
            byte[] byArray6 = session.decrypt(byArray4);
            boolean bl = false;
            if (byArray2.length != byArray6.length) {
                bl = false;
            } else {
                bl = true;
                int n2 = 0;
                while (n2 < byArray2.length) {
                    if (byArray2[n2] != byArray6[n2]) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
            output_.println(bl ? "successful" : "ERROR");
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: EncryptDecrypt <PKCS#11 module> <user-PIN> <file to be encrypted>");
        output_.println(" e.g.: EncryptDecrypt pk2priv.dll password data.dat");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

