/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;

public class Digest {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3 && stringArray.length != 4) {
            Digest.printUsage();
            System.exit(1);
        }
        try {
            Object object;
            int n;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                System.out.println("No slot with present token found!");
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            Session session = token.openSession(true, false, null, null);
            System.out.println("################################################################################");
            System.out.println("digesting data from file: " + stringArray[2]);
            Mechanism mechanism = Mechanism.SHA_1;
            byte[] byArray = new byte[4096];
            FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
            int n2 = 0;
            long l = System.currentTimeMillis();
            session.digestInit(mechanism);
            while ((n = fileInputStream.read(byArray)) >= 0) {
                if (n < byArray.length) {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    session.digestUpdate(byArray2);
                } else {
                    session.digestUpdate(byArray);
                }
                ++n2;
            }
            byte[] byArray3 = session.digestFinal();
            long l2 = System.currentTimeMillis();
            fileInputStream.close();
            Arrays.fill(byArray, (byte)0);
            System.out.println("The digest value is: " + new BigInteger(1, byArray3).toString(16));
            System.out.println("Calculation took " + (l2 - l) + " milliseconds using " + n2 + " update calls.");
            if (stringArray.length == 4) {
                System.out.println("Writing digest value to file: " + stringArray[3]);
                object = new FileOutputStream(stringArray[3]);
                ((FileOutputStream)object).write(byArray3);
                ((OutputStream)object).flush();
                ((FileOutputStream)object).close();
            }
            System.out.println("################################################################################");
            System.out.println("################################################################################");
            System.out.println("verifying digest with software digest");
            object = MessageDigest.getInstance("SHA-1");
            fileInputStream = new FileInputStream(stringArray[2]);
            n2 = 0;
            l = System.currentTimeMillis();
            while ((n = fileInputStream.read(byArray)) >= 0) {
                ((MessageDigest)object).update(byArray, 0, n);
                ++n2;
            }
            byte[] byArray4 = ((MessageDigest)object).digest();
            l2 = System.currentTimeMillis();
            fileInputStream.close();
            Arrays.fill(byArray, (byte)0);
            System.out.println("The digest value is: " + new BigInteger(1, byArray4).toString(16));
            System.out.println("Calculation took " + (l2 - l) + " milliseconds using " + n2 + " update calls.");
            if (Arrays.equals(byArray3, byArray4)) {
                System.out.println("Verified Message Digest successfully");
            } else {
                System.out.println("Verification of Message Digest FAILED");
            }
            System.out.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("Usage: Digest <PKCS#11 module> <user-PIN> <file to be digested> [<digest value file>]");
        System.out.println(" e.g.: Digest pk2priv.dll password data.dat digest.bin");
        System.out.println("The given DLL must be in the search path of the system.");
    }
}

