/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.KeyAndCertificate;
import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;

public class DSASignAndVerify {
    static BufferedReader input_;
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            DSASignAndVerify.printUsage();
            System.exit(1);
        }
        try {
            try {
                FileOutputStream fileOutputStream;
                byte[] byArray;
                int n;
                MechanismInfo mechanismInfo;
                HashSet<Mechanism> hashSet;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Token token = Util.selectToken(module, output_, input_);
                if (token == null) {
                    output_.println("We have no token to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                if ((hashSet = new HashSet<Mechanism>(Arrays.asList(token.getMechanismList()))).contains(Mechanism.DSA_SHA1)) {
                    mechanismInfo = token.getMechanismInfo(Mechanism.DSA_SHA1);
                } else {
                    mechanismInfo = null;
                    output_.println("The token does not support mechanism DSA_SHA1. Going to exit.");
                    System.exit(0);
                }
                if (mechanismInfo == null || !mechanismInfo.isSign()) {
                    output_.println("The token does not support signing with mechanism DSA_SHA1. Going to exit.");
                    System.exit(0);
                }
                Session session = Util.openAuthorizedSession(token, false, output_, input_);
                output_.println("################################################################################");
                output_.println("find private signature key");
                DSAPrivateKey dSAPrivateKey = new DSAPrivateKey();
                dSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                KeyAndCertificate keyAndCertificate = Util.selectKeyAndCertificate(session, (Key)dSAPrivateKey, output_, input_);
                if (keyAndCertificate == null) {
                    output_.println("We have no signature key to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                Key key = keyAndCertificate.getKey();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("signing data from file: " + stringArray[1]);
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                Mechanism mechanism = Mechanism.DSA_SHA1;
                session.signInit(mechanism, key);
                byte[] byArray2 = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray2)) >= 0) {
                    byArray = new byte[n];
                    System.arraycopy(byArray2, 0, byArray, 0, n);
                    session.signUpdate(byArray);
                    Arrays.fill(byArray, (byte)0);
                }
                byte[] byArray3 = session.signFinal();
                Arrays.fill(byArray2, (byte)0);
                output_.println("The siganture value is: " + new BigInteger(1, byArray3).toString(16));
                if (stringArray.length == 3) {
                    output_.println("Writing signature to file: " + stringArray[2]);
                    fileOutputStream = new FileOutputStream(stringArray[2]);
                    ((OutputStream)fileOutputStream).write(byArray3);
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
                output_.println("################################################################################");
                if (mechanismInfo == null || !mechanismInfo.isVerify()) {
                    output_.println("The token does not support verification with mechanism RSA_PKCS. Going to exit.");
                    System.exit(0);
                }
                output_.println("################################################################################");
                output_.println("find public verification key");
                fileOutputStream = new DSAPublicKey();
                fileOutputStream.getVerify().setBooleanValue(Boolean.TRUE);
                fileOutputStream.getId().setByteArrayValue(key.getId().getByteArrayValue());
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)fileOutputStream);
                iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
                DSAPublicKey dSAPublicKey = null;
                if (objectArray.length > 0) {
                    dSAPublicKey = (DSAPublicKey)objectArray[0];
                    output_.println("________________________________________________________________________________");
                    output_.println(dSAPublicKey);
                    output_.println("________________________________________________________________________________");
                } else {
                    output_.println("No matching public key found!");
                    System.exit(0);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("verifying signature");
                fileInputStream = new FileInputStream(stringArray[1]);
                while ((n = ((InputStream)fileInputStream).read(byArray2)) >= 0) {
                    byArray = new byte[n];
                    System.arraycopy(byArray2, 0, byArray, 0, n);
                    session.signUpdate(byArray);
                    Arrays.fill(byArray, (byte)0);
                }
                Mechanism mechanism2 = Mechanism.DSA_SHA1;
                session.verifyInit(mechanism2, (Key)dSAPublicKey);
                try {
                    session.verifyFinal(byArray3);
                    output_.println("Verified the signature successfully");
                }
                catch (TokenException tokenException) {
                    output_.println("Verification FAILED: " + tokenException.getMessage());
                }
                output_.println("################################################################################");
                session.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_21 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_22 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: DSASignAndVerify <PKCS#11 module> <file to be signed> [<signature value file>]");
        output_.println(" e.g.: DSASignAndVerify pk2priv.dll data.dat signature.bin");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

